#version 120

uniform sampler2D texture;

uniform vec2 screen;
uniform vec2 position;
uniform float radius;
uniform vec3 ci;

void main(){
	vec2 uv = gl_FragCoord.xy / screen;
	vec4 col = texture2D(texture, uv);
	float posy = screen.y - position.y;
	float c = radius / ((position.x - gl_FragCoord.x) * (position.x - gl_FragCoord.x) + (posy - gl_FragCoord.y) * (posy - gl_FragCoord.y));
	
	gl_FragColor = col + vec4(c * ci.r, c * ci.g, c * ci.b, 0.0);
}