#version 110

uniform sampler2D texture;
uniform vec2 screen;
uniform float phase; // Phase from 0.0 to 1.0

void main()
{
	vec2 uv = gl_TexCoord[0].xy;
	vec4 c = texture2D(texture, uv);
	
	float fade = 1.0;
	float bonus = 0.0;
	
	if(uv.x > phase)
	{
		fade = 0.35;
	}
	
	if(abs(phase-uv.x) <= 0.01)
	{
		fade = 2.0;
		bonus = 1.0;
	}
	
	gl_FragColor = vec4(c.rgb * fade + vec3(1.0, 1.0, 1.0) * bonus, c.a);
}

