#version 120

uniform sampler2D texture; // 0
uniform vec2 screen;
uniform vec2 center; // Mouse position
uniform float time; // effect elapsed time
uniform vec3 shockParams; // 10.0, 0.8, 0.1

void main() 
{
	float ratio = screen.x / screen.y;
	vec2 nratio = vec2(1.f, 1.f);
	
	if(ratio == 16.0 / 9.0)
		nratio = vec2(screen.x / 1600.0, screen.y / 900.0);
	else if(ratio == 16.0 / 10.0)
		nratio = vec2(screen.x / 1600.0, screen.y / 1000.0);
	
	vec2 ncenter = vec2(center.x * nratio.x, screen.y - center.y * nratio.y) / screen;
	
	vec2 uv = gl_FragCoord.xy / screen;
	vec2 texCoord = uv;
	
	float distance = length(uv / vec2(1.0, ratio) - ncenter / vec2(1.0, ratio));
	
	if ( (distance <= (time + shockParams.z)) && 
	   (distance >= (time - shockParams.z)) ) 
	{
		float diff = (distance - time); 
		float powDiff = 1.0 - pow(abs(diff*shockParams.x), shockParams.y);
		float diffTime = diff * powDiff;
		
		vec2 diffUV = normalize(uv - ncenter);
		
		texCoord = uv + (diffUV * diffTime);
	}
	
	gl_FragColor = texture2D(texture, texCoord);
}
