//#version 100


// glorified edge filter

// most of the math in this shader is wrong, copy-paste on your own risk :p.

varying vec3 normal;
uniform sampler2D depthTex;

uniform vec4 ScreenRes;
uniform vec4 ScreenInv;
uniform vec4 dUV;

const float near = 1.0;
const float far = 1000.0;


vec3 cPos( vec2 sPos ) {
	float d = texture2D (depthTex, sPos).a;
	d =  (2.0 * near) / (far + near - d * (far - near));

	//d = 1 - 1/(d+1);
	float y = sPos.y * ScreenRes.w;
	float x = sPos.x;
	vec2 s = (vec2(x, y) - 0.5 ) * ( d ) * 0.76;
	return vec3(s.x, s.y, d);
}

//const vec2 dUV = vec2( 1.0/400.0, 1.0/300.0 );



float sat( float v ) {
	//return clamp( v, 0.0, 1.0);
	return min( 1.0, max( 0.0, v));
}

void main()
{
//	vec3 lightdir = -normalize(vec3(10,10,10));
//	float c = dot(lightdir, normal);
//	gl_FragColor = vec4(vec3(0.5,0.5,0.5)+normal*0.5, 1.0); //vec4(0.4,0.4,0.8,1.0);
	
/*	vec2 poissonDisk[64];
	poissonDisk[0] = vec2(-0.613392, 0.617481);
	poissonDisk[1] = vec2(0.170019, -0.040254);
	poissonDisk[2] = vec2(-0.299417, 0.791925);
	poissonDisk[3] = vec2(0.645680, 0.493210);
	poissonDisk[4] = vec2(-0.651784, 0.717887);
	poissonDisk[5] = vec2(0.421003, 0.027070);
	poissonDisk[6] = vec2(-0.817194, -0.271096);
	poissonDisk[7] = vec2(-0.705374, -0.668203);
	poissonDisk[8] = vec2(0.977050, -0.108615);
	poissonDisk[9] = vec2(0.063326, 0.142369);
	poissonDisk[10] = vec2(0.203528, 0.214331);
	poissonDisk[11] = vec2(-0.667531, 0.326090);
	poissonDisk[12] = vec2(-0.098422, -0.295755);
	poissonDisk[13] = vec2(-0.885922, 0.215369);
	poissonDisk[14] = vec2(0.566637, 0.605213);
	poissonDisk[15] = vec2(0.039766, -0.396100);
	poissonDisk[16] = vec2(0.751946, 0.453352);
	poissonDisk[17] = vec2(0.078707, -0.715323);
	poissonDisk[18] = vec2(-0.075838, -0.529344);
	poissonDisk[19] = vec2(0.724479, -0.580798);
	poissonDisk[20] = vec2(0.222999, -0.215125);
	poissonDisk[21] = vec2(-0.467574, -0.405438);
	poissonDisk[22] = vec2(-0.248268, -0.814753);
	poissonDisk[23] = vec2(0.354411, -0.887570);
	poissonDisk[24] = vec2(0.175817, 0.382366);
	poissonDisk[25] = vec2(0.487472, -0.063082);
	poissonDisk[26] = vec2(-0.084078, 0.898312);
	poissonDisk[27] = vec2(0.488876, -0.783441);
	poissonDisk[28] = vec2(0.470016, 0.217933);
	poissonDisk[29] = vec2(-0.696890, -0.549791);
	poissonDisk[30] = vec2(-0.149693, 0.605762);
	poissonDisk[31] = vec2(0.034211, 0.979980);
	poissonDisk[32] = vec2(0.503098, -0.308878);
	poissonDisk[33] = vec2(-0.016205, -0.872921);
	poissonDisk[34] = vec2(0.385784, -0.393902);
	poissonDisk[35] = vec2(-0.146886, -0.859249);
	poissonDisk[36] = vec2(0.643361, 0.164098);
	poissonDisk[37] = vec2(0.634388, -0.049471);
	poissonDisk[38] = vec2(-0.688894, 0.007843);
	poissonDisk[39] = vec2(0.464034, -0.188818);
	poissonDisk[40] = vec2(-0.440840, 0.137486);
	poissonDisk[41] = vec2(0.364483, 0.511704);
	poissonDisk[42] = vec2(0.034028, 0.325968);
	poissonDisk[43] = vec2(0.099094, -0.308023);
	poissonDisk[44] = vec2(0.693960, -0.366253);
	poissonDisk[45] = vec2(0.678884, -0.204688);
	poissonDisk[46] = vec2(0.001801, 0.780328);
	poissonDisk[47] = vec2(0.145177, -0.898984);
	poissonDisk[48] = vec2(0.062655, -0.611866);
	poissonDisk[49] = vec2(0.315226, -0.604297);
	poissonDisk[50] = vec2(-0.780145, 0.486251);
	poissonDisk[51] = vec2(-0.371868, 0.882138);
	poissonDisk[52] = vec2(0.200476, 0.494430);
	poissonDisk[53] = vec2(-0.494552, -0.711051);
	poissonDisk[54] = vec2(0.612476, 0.705252);
	poissonDisk[55] = vec2(-0.578845, -0.768792);
	poissonDisk[56] = vec2(-0.772454, -0.090976);
	poissonDisk[57] = vec2(0.504440, 0.372295);
	poissonDisk[58] = vec2(0.155736, 0.065157);
	poissonDisk[59] = vec2(0.391522, 0.849605);
	poissonDisk[60] = vec2(-0.620106, -0.328104);
	poissonDisk[61] = vec2(0.789239, -0.419965);
	poissonDisk[62] = vec2(-0.545396, 0.538133);
	poissonDisk[63] = vec2(-0.178564, -0.596057); */
	
	
	float col;
	
	vec2 sp = gl_TexCoord[0].st;

	
	vec3 cV = cPos( sp );
	vec3 cpxV = cPos( sp + vec2(dUV.x, 0.0) ) - cV;
	vec3 cnxV = cPos( sp + vec2(dUV.x*-1.0, 0.0) ) - cV;

	vec3 cpyV = cPos( sp + vec2(0.0, dUV.y )  )  - cV;
	vec3 cnyV = cPos( sp + vec2(0.0, dUV.y*-1.0 ) )  - cV;

	vec3 dX = vec3( 0.0 );

	const float cdzLimit = 0.001;
	if ( abs(cpxV.z) < cdzLimit &&  abs(cnxV.z) < cdzLimit ) {
		dX = (cpxV - cnxV) * 0.5;
	} else  if (  abs(cpxV.z) < abs(cnxV.z) ) {
		dX =  cpxV;
	} else {
		dX =  -cnxV;
	}
//	if (abs( dX.z ) > 0.1 ) {
//		dX = cpxV;
//		dX.z = 0.0;
//	}

	vec3 dY = vec3( 0.0 );
	if ( abs(cpyV.z) < cdzLimit &&  abs(cnyV.z) < cdzLimit ) {
		dY = (cpyV - cnyV) * 0.5;
	} else if (  abs(cpyV.z) < abs(cnyV.z) ) {
		dY =  cpyV;
	} else {
		dY =  -cnyV;
	}
//	if (abs( dY.z ) > 0.1 ) {
//		dY = cpyV;
//		dY.z = 0.0;
//	}

//	dX = cpxV;
//	dY = cpyV;
	//vec3 cnV = normalize( vec3( dX, dY, dUV.x) );
	
//	vec3 cnV = -normalize( cross( vec3( dUV.x, 0, dX ) , vec3( 0, dUV.y, dY ) )  );
	vec3 cnV = normalize( cross( dY , dX )  );
	
	
	float rad = 0.010;
	rad = 0.015 * (1.0 - sat(cV.z*5.0)*0.9 );
	
	
	int x = int(sp.x*ScreenRes.x);
	int y = int(sp.y*ScreenRes.y);
	
	
	const int blurSize = 5;
	
	float seed = mod( float(x), float(blurSize) ) + mod( float(y), float(blurSize) );
	
	float aSum = 0.0;
	float aWeight = 0.0;
	const int nSamp = 5;
	for( int u=0; u<5; u++) {
		for ( int i=0; i<nSamp; i++ ) {
			float r = rad * ( float(u)+1.0 );
			//int samp = ( u*nSamp + i  ) % 8;
			//vec2 pSV = poissonDisk[ samp ] * r;
			float ang = float(u)*1.5 + float(i)*3.14/float(nSamp*2) + seed*3.4;
			vec2 pSV = vec2 ( cos( ang ), sin( ang ) ) * r;
			
			//pSV = vec2( dUV.x, dUV.y )*-8.0;
			
			vec3 pV = cPos( sp + pSV );
			
			vec3 dpV = pV - cV;
			
			vec3 ndpV = normalize( dpV );
			
			float ao = sat ( dot( cnV, ndpV ) * 2.0  );
			
			ao *= float( 16 - u ) / 16.0;
			
			//if( abs( ndpV.z ) < 0.8 && abs(dpV.z) < 0.02 ) {
			if( abs(dpV.z) < 0.005 ) {
				aSum += ao;
				aWeight += 1.0;
			}
		}
	}
	
	float ao = 0.0;
	if( aWeight > 0.0 ) {
		ao = aSum/aWeight;
	}


	//col = cPos( gl_TexCoord[0].st ).x;
	
	
/*	vec3 pV = cPos( sp + vec2( 0, dUV.y )*1 );
	
	vec3 dpV = pV - cV;
	
	vec3 ndpV = normalize( dpV );
	
	ao = saturate ( dot( -cnV, ndpV ) );
//	ao = ndpV.x ;
	
	*/
	
	col =  ao * 1.5;
		
//	col = abs( cV.z )*10;
	
//	col = ScreenRes.w;
	
	float d = cV.z;
	
	
//	if (d > 0.95 && d < 1 ) 
//		col = 1;
//	else
//	col = 0;
//	col = d;
//	col = sat( ( d - 0.95 ) * 20 );

//	gl_FragColor = vec4( 0.127, 0.11, 0.096, col);
	gl_FragColor = vec4( col, col, col, 1);
	
}
