/*
 * Decompiled with CFR 0.152.
 */
package engine;

import engine.Point3D;
import entities.Entity;

public class Camera {
    public Point3D pos;
    public double xrot = 0.0;
    public double yrot = 0.0;
    public double zrot = 0.0;
    public static final int FLY_FREE = 1;
    public static final int FOLLOW_ENTITY = 2;
    public static final int CIRCLE_ENTITY = 3;
    public static final int CIRCLE_POINT = 4;
    private int state = 4;
    private Entity entity;
    private Point3D point = new Point3D(500.0, 0.0, 500.0);
    private int counter;

    public Camera(int x, int y, int z) {
        this.pos = new Point3D(x, y, z);
    }

    public void setState(int s, Entity e, Point3D p) {
        this.state = s;
        this.entity = e;
        this.point = p;
        this.counter = 0;
    }

    public void update() {
        switch (this.state) {
            case 1: {
                break;
            }
            case 2: {
                double dis = 40.0 + 10.0 * this.entity.getSpeed();
                this.pos.x = this.entity.pos.x - Math.sin(this.entity.heading) * dis;
                this.pos.y = this.entity.pos.y + 5.0;
                this.pos.z = this.entity.pos.z - Math.cos(this.entity.heading) * dis;
                this.pos.y += 20.0 + 0.2 * dis;
                this.yrot = this.entity.heading;
                this.xrot = 0.0;
                this.zrot = 0.0;
                break;
            }
            case 3: {
                ++this.counter;
                this.pos.y = 50.0;
                this.yrot = (double)this.counter / 100.0;
                this.xrot = 0.7853981633974483;
                this.pos.x = this.entity.pos.x - Math.sin((double)this.counter / 100.0) * 100.0;
                this.pos.z = this.entity.pos.z - Math.cos((double)this.counter / 100.0) * 100.0;
                break;
            }
            case 4: {
                ++this.counter;
                this.pos.y = 50.0;
                this.yrot = (double)this.counter / 100.0;
                this.xrot = 0.7853981633974483;
                this.pos.x = this.point.x - Math.sin((double)this.counter / 100.0) * 100.0;
                this.pos.z = this.point.z - Math.cos((double)this.counter / 100.0) * 100.0;
            }
        }
    }
}

