/*
 * Decompiled with CFR 0.152.
 */
package engine;

import engine.Camera;
import engine.FastMath;
import engine.Point3D;
import game.Game;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;

public class GraphicsEngine {
    private final double V_FOV = 1.5707963267948966;
    private final double H_FOV = 1.5707963267948966;
    private final double TAN_VFOV = FastMath.tan(0.7853981633974483);
    private final double TAN_HFOV = FastMath.tan(0.7853981633974483);
    private int SCREEN_W = 0;
    private int SCREEN_H = 0;
    private final double HALF_SCREEN_H;
    private final double HALF_SCREEN_W;
    public int player;
    private Game game;
    public Camera cam = new Camera(500, 50, 500);
    Point3D p2 = new Point3D(0.0, 0.0, 0.0);
    int[] pixels = new int[this.SCREEN_W * this.SCREEN_H];
    Point3D p = new Point3D(0.0, 0.0, 0.0);
    boolean[] pixallow = new boolean[this.SCREEN_W * this.SCREEN_H];
    boolean pixelsInitialize = false;
    Point3D p3;

    public GraphicsEngine(int sw, int sh, int player, Game g) {
        this.player = player;
        this.game = g;
        this.SCREEN_W = sw;
        this.SCREEN_H = sh;
        this.HALF_SCREEN_H = (double)this.SCREEN_H / 2.0;
        this.HALF_SCREEN_W = (double)this.SCREEN_W / 2.0;
    }

    public void renderMap(int[][] mapImg, BufferedImage screen, boolean snow, boolean rain) {
        if (!this.pixelsInitialize) {
            this.pixels = ((DataBufferInt)screen.getRaster().getDataBuffer()).getData();
            this.pixelsInitialize = true;
        }
        this.pixallow = new boolean[this.SCREEN_W * this.SCREEN_H];
        int x = 0;
        while (x < this.SCREEN_W) {
            int y = 0;
            while (y < this.SCREEN_H) {
                if (!this.pixallow[x + y * this.SCREEN_W]) {
                    this.p = this.getScreenPoint(x, y);
                    double t = -this.cam.pos.y / (this.p.y - this.cam.pos.y);
                    int px = (int)(this.cam.pos.x + t * (this.p.x - this.cam.pos.x));
                    int pz = (int)(this.cam.pos.z + t * (this.p.z - this.cam.pos.z));
                    this.pixels[x + y * this.SCREEN_W] = t < 0.0 || px < 0 || pz < 0 || px >= mapImg.length || pz >= mapImg[0].length ? (t < 0.0 ? this.game.map.skyColor : this.game.map.groundColor) : mapImg[px][pz];
                    if (snow && Math.random() > 0.95) {
                        this.pixels[x + y * this.SCREEN_W] = 0xFFFFFF;
                    }
                    if (rain && Math.random() > 0.95 && (y + 1) * this.SCREEN_W < this.SCREEN_H * this.SCREEN_W) {
                        this.pixels[x + y * this.SCREEN_W] = 4821759;
                        this.pixels[x + (y + 1) * this.SCREEN_W] = 5217279;
                        this.pixallow[x + (y + 1) * this.SCREEN_W] = true;
                    }
                }
                ++y;
            }
            ++x;
        }
    }

    public Point pointOnScreen(Point3D lo) {
        Point3D po = this.getScreenPoint(0, 0);
        Point3D n1 = Point3D.sub(this.getScreenPoint(0, 0), this.getScreenPoint(0, 1));
        Point3D n2 = Point3D.sub(this.getScreenPoint(0, 0), this.getScreenPoint(1, 0));
        Point3D n = Point3D.cross(n1, n2);
        Point3D l = Point3D.sub(this.cam.pos, lo);
        l = Point3D.mult(1.0 / Point3D.len(l), l);
        double d = Point3D.dot(Point3D.sub(po, lo), n) / Point3D.dot(l, n);
        Point3D ip = Point3D.add(lo, Point3D.mult(d, l));
        Point3D b = Point3D.sub(this.getScreenPoint(this.SCREEN_W, this.SCREEN_H), this.getScreenPoint(0, this.SCREEN_H));
        Point3D b2 = Point3D.sub(this.getScreenPoint(0, 0), this.getScreenPoint(0, this.SCREEN_H));
        Point3D v = Point3D.sub(ip, this.getScreenPoint(0, this.SCREEN_H));
        Point3D a = Point3D.proj(v, b);
        Point3D c = Point3D.sub(v, Point3D.proj(v, b));
        int x = (int)(this.HALF_SCREEN_W * Point3D.len(Point3D.proj(v, b)));
        int y = this.SCREEN_H - (int)(this.HALF_SCREEN_H * Point3D.len(Point3D.sub(v, Point3D.proj(v, b))));
        double d2 = Point3D.len(Point3D.sub(lo, this.cam.pos));
        if (!Point3D.sameSign(a, b) || !Point3D.sameSign(c, b2) || d2 < d) {
            x = -1000;
            y = -1000;
        }
        return new Point(x, y);
    }

    public Point3D getScreenPoint(int x, int y) {
        this.p3 = new Point3D(0.0, this.cam.pos.y - this.TAN_VFOV * ((double)y - this.HALF_SCREEN_H) / this.HALF_SCREEN_H, this.cam.pos.z + 1.0);
        this.p3.x = this.cam.pos.x - this.TAN_HFOV * (this.HALF_SCREEN_W - (double)x) / this.HALF_SCREEN_W;
        this.p3.rotx(this.cam.xrot, this.cam.pos);
        this.p3.roty(this.cam.yrot, this.cam.pos);
        return this.p3;
    }
}

