/*
 * Decompiled with CFR 0.152.
 */
package engine;

import engine.FastMath;

public class Point3D {
    public double x;
    public double y;
    public double z;

    public Point3D(double xo, double yo, double zo) {
        this.x = xo;
        this.y = yo;
        this.z = zo;
    }

    public void rotz(double a, Point3D po) {
        double cosa = FastMath.cos(a);
        double sina = FastMath.sin(a);
        double tx = this.x;
        this.x = (this.x - po.x) * cosa - (this.y - po.y) * sina;
        this.y = (tx - po.x) * sina + (this.y - po.y) * cosa;
        this.x += po.x;
        this.y += po.y;
    }

    public void rotx(double a, Point3D po) {
        double ty = this.y;
        double cosa = FastMath.cos(a);
        double sina = FastMath.sin(a);
        this.y = (this.y - po.y) * cosa - (this.z - po.z) * sina;
        this.z = (ty - po.y) * sina + (this.z - po.z) * cosa;
        this.y += po.y;
        this.z += po.z;
    }

    public void roty(double a, Point3D po) {
        double tx = this.x;
        double cosa = FastMath.cos(a);
        double sina = FastMath.sin(a);
        this.x = (this.x - po.x) * cosa + (this.z - po.z) * sina;
        this.z = -(tx - po.x) * sina + (this.z - po.z) * cosa;
        this.x += po.x;
        this.z += po.z;
    }

    public static int sign(double d) {
        if (Math.abs(d) < 1.0E-4) {
            return 0;
        }
        if (d < 0.0) {
            return -1;
        }
        return 1;
    }

    public static boolean sameSign(Point3D a, Point3D b) {
        return Point3D.sign(a.x) == Point3D.sign(b.x) && Point3D.sign(a.y) == Point3D.sign(b.y) && Point3D.sign(a.z) == Point3D.sign(b.z);
    }

    public static double len(Point3D p) {
        return Math.sqrt(Point3D.dot(p, p));
    }

    public static Point3D mult(double s, Point3D p) {
        return new Point3D(s * p.x, s * p.y, s * p.z);
    }

    public static Point3D cross(Point3D pf, Point3D ps) {
        return new Point3D(pf.y * ps.z - pf.z * ps.y, pf.z * ps.x - pf.x * ps.z, pf.x * ps.y - pf.y * ps.x);
    }

    public static double dot(Point3D pf, Point3D ps) {
        return pf.x * ps.x + pf.y * ps.y + pf.z * ps.z;
    }

    public static Point3D sub(Point3D pf, Point3D ps) {
        return new Point3D(pf.x - ps.x, pf.y - ps.y, pf.z - ps.z);
    }

    public static Point3D add(Point3D pf, Point3D ps) {
        return new Point3D(pf.x + ps.x, pf.y + ps.y, pf.z + ps.z);
    }

    public static Point3D proj(Point3D pf, Point3D ps) {
        return Point3D.mult(Point3D.dot(pf, ps) / Point3D.dot(ps, ps), ps);
    }

    public Point3D clone() {
        return new Point3D(this.x, this.y, this.z);
    }
}

