/*
 * Decompiled with CFR 0.152.
 */
package entities;

import engine.GraphicsEngine;
import engine.Point3D;
import entities.Checkpoint;
import entities.Entity;
import entities.Racer;
import game.Game;
import game.MapCity;
import game.MapDesert;
import game.MapIcy;
import game.MapWood;
import items.ItemBoulder;
import items.ItemFakeItem;
import items.ItemFusRoDah;
import items.ItemMissile;
import items.ItemTrollMagnet;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Stack;

public class Bot
extends Racer {
    private boolean kUse;
    private boolean kUp;
    private boolean kLeft;
    private boolean kRight;
    private boolean kDown;
    private ArrayList<Point3D> botPoints;
    boolean allowCheat = true;
    private int cheatCounter = 0;
    private int currentItemCounter = 0;
    private long last;
    private long current;

    public Bot(Game g, Point3D po, int type, Stack<Checkpoint> checkpoints, double startheading, ArrayList<Point3D> botPoints, int totalCheckpoints, String name) {
        super(g, po, type, startheading, totalCheckpoints, name);
        this.checkpoints = checkpoints;
        this.botPoints = botPoints;
    }

    @Override
    public void update() {
        this.currentItemCounter = this.item != null ? ++this.currentItemCounter : 0;
        ++this.cheatCounter;
        if (this.cheatCounter % 200 == 0) {
            this.allowCheat = true;
        }
        this.setKeys();
        this.item();
        this.input();
        this.move();
        this.updateCheckpoints();
    }

    public Point3D bestBotPoint() {
        Point3D closest = ((Checkpoint)this.checkpoints.peek()).pos;
        double disToCheck = this.disTo((Entity)this.checkpoints.peek());
        int i = 0;
        while (i < this.botPoints.size()) {
            double d = Point3D.len(Point3D.sub(this.botPoints.get(i), ((Checkpoint)this.checkpoints.peek()).pos));
            if (d < disToCheck) {
                closest = this.pointClosest(this.botPoints.get(i), closest);
            }
            ++i;
        }
        return closest;
    }

    public Point3D pointClosest(Point3D p1, Point3D p2) {
        double d2;
        double d1 = Point3D.len(Point3D.sub(p1, this.pos));
        if (d1 < (d2 = Point3D.len(Point3D.sub(p2, this.pos)))) {
            return p1;
        }
        return p2;
    }

    public double normalizeAngel(double a) {
        if ((a %= Math.PI * 2) < 0.0) {
            a += Math.PI * 2;
        }
        return a;
    }

    public void setKeys() {
        this.kUse = false;
        this.kUp = false;
        this.kLeft = false;
        this.kRight = false;
        this.kDown = false;
        if (this.checkpoints.empty() || this.game.startCounter > 0) {
            return;
        }
        Point3D bp = this.bestBotPoint();
        double a = Math.atan2(bp.x - this.pos.x, bp.z - this.pos.z);
        a = this.normalizeAngel(a);
        double h = this.normalizeAngel(this.heading);
        double d = this.normalizeAngel(a - h);
        this.kUse = this.checkItemUse();
        if (d < Math.PI) {
            this.kRight = true;
        } else {
            this.kLeft = true;
        }
        if (Math.abs(a - h) < 0.15707963267948966) {
            this.kUp = true;
        } else {
            this.kUp = true;
            this.kDown = true;
        }
        if (this.game.map instanceof MapIcy) {
            if (Math.random() > 0.975 && this.allowCheat) {
                this.vel = new Point3D(this.getSpeed() * Math.sin(a), 0.0, this.getSpeed() * Math.cos(a));
            }
            if (Math.abs(a - h) < 0.3141592653589793) {
                this.kUp = true;
            } else if (Math.abs(a - h) < 0.6283185307179586) {
                this.kUp = true;
                this.kDown = true;
            } else {
                this.kDown = true;
            }
        } else if (this.game.map instanceof MapWood) {
            if (Math.random() > 0.975 && this.allowCheat) {
                this.vel = new Point3D(this.getSpeed() * Math.sin(a), 0.0, this.getSpeed() * Math.cos(a));
            }
            if (Math.abs(a - h) < 0.3141592653589793) {
                this.kUp = true;
            } else if (Math.abs(a - h) < 0.6283185307179586) {
                this.kUp = true;
                this.kDown = true;
            } else {
                this.kDown = true;
            }
        } else if (this.game.map instanceof MapDesert) {
            if (Math.random() > 0.975 && this.allowCheat) {
                this.vel = new Point3D(this.getSpeed() * Math.sin(a), 0.0, this.getSpeed() * Math.cos(a));
            }
            if (Math.abs(a - h) < 0.3141592653589793) {
                this.kUp = true;
            } else if (Math.abs(a - h) < 0.6283185307179586) {
                this.kUp = true;
                this.kDown = true;
            } else {
                this.kDown = true;
            }
        } else if (this.game.map instanceof MapCity) {
            if (Math.random() > 0.975 && this.allowCheat) {
                this.vel = new Point3D(this.getSpeed() * Math.sin(a), 0.0, this.getSpeed() * Math.cos(a));
            }
            if (Math.abs(a - h) < 0.3141592653589793) {
                this.kUp = true;
            } else if (Math.abs(a - h) < 0.6283185307179586) {
                this.kUp = true;
                this.kDown = true;
            } else {
                this.kDown = true;
            }
        }
        if (this.allowCheat) {
            this.heading = a;
        }
    }

    @Override
    public boolean kUse() {
        return this.kUse;
    }

    @Override
    public boolean kUp() {
        return this.kUp;
    }

    @Override
    public boolean kLeft() {
        return this.kLeft;
    }

    @Override
    public boolean kRight() {
        return this.kRight;
    }

    @Override
    public boolean kDown() {
        return this.kDown;
    }

    public boolean checkItemUse() {
        if (this.item instanceof ItemFakeItem) {
            if (this.currentItemCounter == 1 && Math.random() > 0.5) {
                return true;
            }
            if (Math.random() > 0.9995) {
                return true;
            }
        } else if (this.item instanceof ItemFusRoDah) {
            int i = 0;
            while (i < this.game.racers.size()) {
                double d;
                Racer r = this.game.racers.get(i);
                if (r != this && (d = this.disTo(r)) < ItemFusRoDah.range) {
                    return true;
                }
                ++i;
            }
        } else if (this.item instanceof ItemTrollMagnet) {
            if (Math.random() > 0.999) {
                return true;
            }
        } else if (this.item instanceof ItemBoulder) {
            if (Math.random() > 0.9995) {
                return true;
            }
            double fireAngle = 1.0471975511965976;
            double range = 150.0;
            int i = 0;
            while (i < this.game.racers.size()) {
                Racer r = this.game.racers.get(i);
                if (r != this) {
                    double d;
                    double a = Math.atan2(r.pos.x - this.pos.x, r.pos.z - this.pos.z);
                    double h = this.heading;
                    if (Math.abs((a = this.normalizeAngel(a)) - (h = this.normalizeAngel(h))) < fireAngle && (d = this.disTo(r)) < range) {
                        return true;
                    }
                }
                ++i;
            }
        } else if (this.item instanceof ItemMissile) {
            return ((ItemMissile)this.item).botFire();
        }
        return false;
    }

    @Override
    public void draw(Graphics g, int dy, GraphicsEngine GE, Dimension ingres, Dimension res) {
        super.draw(g, dy, GE, ingres, res);
    }
}

