/*
 * Decompiled with CFR 0.152.
 */
package entities;

import engine.Point3D;
import engine.Sound;
import engine.Sprite;
import entities.Entity;
import entities.GFX;
import entities.Racer;
import game.Game;

public class Boulder
extends Entity {
    private int life = 100;

    public Boulder(Game g, Point3D po, Point3D vel) {
        super(g, po);
        this.pos = po;
        this.vel = vel;
        this.sprite = new Sprite(this, 5);
        this.radius = 7;
    }

    @Override
    public void update() {
        this.move();
    }

    private void move() {
        this.pos.x += this.vel.x;
        this.pos.y += this.vel.y;
        this.pos.z += this.vel.z;
        this.vel.x *= 0.98;
        this.vel.z *= 0.98;
    }

    @Override
    public void collide(Entity entity) {
        if (entity instanceof Racer) {
            Racer r = (Racer)entity;
            entity.vel = new Point3D(0.0, 0.0, 0.0);
            r.slowcounter = r.slowcounter < 0 ? 500 : (r.slowcounter += 500);
            this.game.sound.play3D(Sound.SPLASH, this.game.player1.pos, this.game.player2.pos, this.pos);
            this.game.addEntity(new GFX(this.game, this.pos.clone(), 4, new Point3D(0.0, 0.0, 0.0)));
            this.shallBeRemoved = true;
        }
    }
}

