/*
 * Decompiled with CFR 0.152.
 */
package entities;

import engine.GraphicsEngine;
import engine.Point3D;
import engine.Sound;
import entities.Checkpoint;
import entities.Racer;
import game.Game;
import game.Input;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Stack;

public class Player
extends Racer {
    public static final int PLAYER_ONE = 1;
    public static final int PLAYER_TWO = 2;
    public static final int PLAYER_NUMPAD = 3;
    public int player;
    private String name = "N/A";
    int kUse;
    int kUp;
    int kLeft;
    int kRight;
    int kDown;
    private Input input;
    private long last;
    private long current;

    public Player(Game g, Point3D po, int type, int controls, Stack<Checkpoint> c, int p, double startheading, int totalCheckpoints, String name) {
        super(g, po, type, startheading, totalCheckpoints, name);
        this.checkpoints = c;
        this.player = p;
        this.setKeys(controls);
        this.input = g.input;
    }

    public void setKeys(int playernum) {
        switch (playernum) {
            case 1: {
                this.kUse = 81;
                this.kUp = 87;
                this.kDown = 83;
                this.kLeft = 65;
                this.kRight = 68;
                break;
            }
            case 2: {
                this.kUse = 17;
                this.kUp = 38;
                this.kDown = 40;
                this.kLeft = 37;
                this.kRight = 39;
                break;
            }
            case 3: {
                this.kUse = 103;
                this.kUp = 104;
                this.kDown = 101;
                this.kLeft = 100;
                this.kRight = 102;
            }
        }
    }

    @Override
    public void update() {
        this.item();
        this.input();
        this.move();
        this.updateCheckpoints();
        if (this.kUp()) {
            this.current = System.currentTimeMillis();
            if (this.current - this.last > 1000L) {
                this.last = System.currentTimeMillis();
                this.game.sound.play3D(Sound.ENGINE, this.game.player1.pos, this.game.player2.pos, this.pos);
            }
        }
    }

    @Override
    public boolean kUse() {
        return this.input.isKeyDown(this.kUse) && !this.checkpoints.empty() && this.game.startCounter < 0;
    }

    @Override
    public boolean kUp() {
        return this.input.isKeyDown(this.kUp) && !this.checkpoints.empty() && this.game.startCounter < 0;
    }

    @Override
    public boolean kLeft() {
        return this.input.isKeyDown(this.kLeft) && !this.checkpoints.empty() && this.game.startCounter < 0;
    }

    @Override
    public boolean kRight() {
        return this.input.isKeyDown(this.kRight) && !this.checkpoints.empty() && this.game.startCounter < 0;
    }

    @Override
    public boolean kDown() {
        return this.input.isKeyDown(this.kDown) && !this.checkpoints.empty() && this.game.startCounter < 0;
    }

    @Override
    public void draw(Graphics g, int dy, GraphicsEngine GE, Dimension ingres, Dimension res) {
        super.draw(g, dy, GE, ingres, res);
        if (this.checkpoints.size() == 1) {
            ((Checkpoint)this.checkpoints.peek()).setGoal();
        }
        if (this.player == GE.player && !this.checkpoints.empty()) {
            ((Checkpoint)this.checkpoints.peek()).sprite.draw(g, dy, GE, ingres, res);
        }
        if (this.item != null) {
            this.item.draw(g);
        }
    }

    public String getItemName() {
        if (this.item == null) {
            return "no item";
        }
        return this.item.name;
    }
}

