/*
 * Decompiled with CFR 0.152.
 */
package entities;

import art.Art;
import engine.Point3D;
import engine.Sound;
import engine.Sprite;
import entities.Checkpoint;
import entities.Entity;
import game.Friction;
import game.Game;
import items.Item;
import java.awt.image.BufferedImage;
import java.util.Stack;

public class Racer
extends Entity {
    public static final int TYPE_USAMA = 1;
    public static final int TYPE_DICTATORS = 3;
    public static final int TYPE_BIRDIE = 4;
    public static final int TYPE_GABEN = 5;
    public static final int TYPE_HAWKING = 6;
    public static final int TYPE_DOVAHKIIN = 7;
    public static final int TYPE_SLOTH = 8;
    public static final int TYPE_VADER = 9;
    public Item item;
    public Stack<Checkpoint> checkpoints = new Stack();
    public BufferedImage leaderboardPic = Art.naLeaderboard;
    private int type;
    public int totalCheckpoints;
    protected String name;
    public static double STATS_MAX_ACC = 0.025;
    private double statsAcc;
    public static double STATS_MAX_MAX_SPEED = 4.0;
    public double statsMaxSpeed;
    public static double STATS_MAX_WEIGHT = 2.0;
    private double statsWeight;
    public int slowcounter = 0;

    public Racer(Game g, Point3D po, int type, double startheading, int totalCheckpoints, String name) {
        super(g, po);
        this.heading = startheading;
        this.type = type;
        this.init(type);
        this.totalCheckpoints = totalCheckpoints;
        this.name = name;
    }

    protected void init(int type) {
        switch (type) {
            case 1: {
                this.radius = 4;
                this.sprite = new Sprite(this, 6);
                this.leaderboardPic = Art.portraits[0][2];
                this.statsAcc = Racer.getStatsAcc(1);
                this.statsMaxSpeed = Racer.getStatsMaxSpeed(1);
                this.statsWeight = Racer.getStatsWeight(1);
                break;
            }
            case 5: {
                this.radius = 6;
                this.sprite = new Sprite(this, 15);
                this.leaderboardPic = Art.portraits[0][3];
                this.statsAcc = Racer.getStatsAcc(5);
                this.statsMaxSpeed = Racer.getStatsMaxSpeed(5);
                this.statsWeight = Racer.getStatsWeight(5);
                break;
            }
            case 3: {
                this.radius = 6;
                this.sprite = new Sprite(this, 10);
                this.leaderboardPic = Art.portraits[0][0];
                this.statsAcc = Racer.getStatsAcc(3);
                this.statsMaxSpeed = Racer.getStatsMaxSpeed(3);
                this.statsWeight = Racer.getStatsWeight(3);
                break;
            }
            case 4: {
                this.radius = 4;
                this.sprite = new Sprite(this, 12);
                this.leaderboardPic = Art.portraits[0][1];
                this.statsAcc = Racer.getStatsAcc(4);
                this.statsMaxSpeed = Racer.getStatsMaxSpeed(4);
                this.statsWeight = Racer.getStatsWeight(4);
                break;
            }
            case 6: {
                this.radius = 4;
                this.sprite = new Sprite(this, 16);
                this.leaderboardPic = Art.portraits[0][4];
                this.statsAcc = Racer.getStatsAcc(6);
                this.statsMaxSpeed = Racer.getStatsMaxSpeed(6);
                this.statsWeight = Racer.getStatsWeight(6);
                break;
            }
            case 7: {
                this.radius = 5;
                this.sprite = new Sprite(this, 17);
                this.leaderboardPic = Art.portraits[0][5];
                this.statsAcc = Racer.getStatsAcc(7);
                this.statsMaxSpeed = Racer.getStatsMaxSpeed(7);
                this.statsWeight = Racer.getStatsWeight(7);
                break;
            }
            case 8: {
                this.radius = 5;
                this.sprite = new Sprite(this, 18);
                this.leaderboardPic = Art.portraits[0][6];
                this.statsAcc = Racer.getStatsAcc(8);
                this.statsMaxSpeed = Racer.getStatsMaxSpeed(8);
                this.statsWeight = Racer.getStatsWeight(8);
                break;
            }
            case 9: {
                this.radius = 5;
                this.sprite = new Sprite(this, 19);
                this.leaderboardPic = Art.portraits[0][7];
                this.statsAcc = Racer.getStatsAcc(9);
                this.statsMaxSpeed = Racer.getStatsMaxSpeed(9);
                this.statsWeight = Racer.getStatsWeight(9);
            }
        }
    }

    public static double getStatsWeight(int t) {
        double sw = -1337.0;
        switch (t) {
            case 1: {
                sw = 0.8;
                break;
            }
            case 5: {
                sw = 1.7;
                break;
            }
            case 3: {
                sw = 2.0;
                break;
            }
            case 4: {
                sw = 0.5;
                break;
            }
            case 6: {
                sw = 0.8;
                break;
            }
            case 7: {
                sw = 1.0;
                break;
            }
            case 8: {
                sw = 1.3;
                break;
            }
            case 9: {
                sw = 1.5;
            }
        }
        return sw;
    }

    public static double getStatsAcc(int t) {
        double acc = -1337.0;
        switch (t) {
            case 1: {
                acc = 0.02;
                break;
            }
            case 5: {
                acc = 0.0175;
                break;
            }
            case 3: {
                acc = 0.015;
                break;
            }
            case 4: {
                acc = 0.025;
                break;
            }
            case 6: {
                acc = 0.018;
                break;
            }
            case 7: {
                acc = 0.0225;
                break;
            }
            case 8: {
                acc = 0.018;
                break;
            }
            case 9: {
                acc = 0.019;
            }
        }
        return acc;
    }

    public static double getStatsMaxSpeed(int t) {
        double ms = -1337.0;
        switch (t) {
            case 1: {
                ms = 2.25;
                break;
            }
            case 5: {
                ms = 2.75;
                break;
            }
            case 3: {
                ms = 4.0;
                break;
            }
            case 4: {
                ms = 2.0;
                break;
            }
            case 6: {
                ms = 3.0;
                break;
            }
            case 7: {
                ms = 2.1;
                break;
            }
            case 8: {
                ms = 2.8;
                break;
            }
            case 9: {
                ms = 2.35;
            }
        }
        return ms;
    }

    @Override
    public void collide(Entity entity) {
        if (entity instanceof Racer) {
            double s2;
            Point3D v = Point3D.mult(0.05, Point3D.sub(entity.pos, this.pos));
            double s1 = Point3D.len(this.vel);
            double speed = s1 > (s2 = Point3D.len(entity.vel)) ? s1 : s2;
            float proc = (float)(speed / 3.0);
            if (proc > 2.0f) {
                proc = 2.0f;
            }
            Racer r = (Racer)entity;
            entity.vel = Point3D.add(entity.vel, Point3D.mult(this.statsWeight / r.statsWeight, v));
            this.game.sound.play3D(Sound.CRASH, this.game.player1.pos, this.game.player1.pos, this.pos, proc);
        }
    }

    public void item() {
        if (this.item != null) {
            this.item.update();
            if (this.kUse()) {
                this.item.tryUse();
            }
            if (this.item.isConsumed()) {
                this.item = null;
            }
        }
    }

    public void move() {
        if (this.slowcounter <= 0) {
            this.statsMaxSpeed = Racer.getStatsMaxSpeed(this.type);
            this.statsAcc = Racer.getStatsAcc(this.type);
        } else {
            --this.slowcounter;
            this.statsMaxSpeed = Racer.getStatsMaxSpeed(this.type) / 2.0;
            this.statsAcc = Racer.getStatsAcc(this.type) / 2.0;
        }
        this.dRot *= 0.98;
        this.heading += this.dRot;
        Friction fr = null;
        fr = this.pos.x >= 0.0 && this.pos.z >= 0.0 && this.pos.x < (double)this.game.map.mapPic.length && this.pos.z < (double)this.game.map.mapPic[0].length ? this.game.getMap().getFriction(this.game.map.mapPic[(int)this.pos.x][(int)this.pos.z]) : this.game.getMap().getOutSideMapFriction();
        if (Point3D.len(this.vel) > 0.001) {
            Point3D hv = new Point3D(Math.sin(this.heading), 0.0, Math.cos(this.heading));
            double d = Point3D.len(Point3D.proj(hv, this.vel));
            double f = fr.l + fr.d * d / Point3D.len(hv);
            this.vel.x *= f;
            this.vel.z *= f;
            this.vel.y *= f;
        }
        this.pos.x += this.vel.x;
        this.pos.y += this.vel.y;
        this.pos.z += this.vel.z;
    }

    public void input() {
        int z2;
        int z1;
        int x2;
        this.kUse();
        if (this.kUp()) {
            double f = 1.0;
            if (this.item != null) {
                f = this.item.getSpeedBoost();
            }
            if (Point3D.len(this.vel) < this.statsMaxSpeed || f != 1.0) {
                this.vel.x += this.statsAcc * Math.sin(this.heading) * f;
                this.vel.z += this.statsAcc * Math.cos(this.heading) * f;
            }
        }
        if (this.kDown()) {
            this.vel.x *= 0.97;
            this.vel.z *= 0.97;
            int x1 = (int)(this.pos.x - 3.0 * Math.sin(this.heading + 1.5707963267948966) + 6.0 * Math.sin(this.heading));
            x2 = (int)(this.pos.x + 3.0 * Math.sin(this.heading + 1.5707963267948966) + 6.0 * Math.sin(this.heading));
            z1 = (int)(this.pos.z - 3.0 * Math.cos(this.heading + 1.5707963267948966) + 6.0 * Math.cos(this.heading));
            z2 = (int)(this.pos.z + 3.0 * Math.cos(this.heading + 1.5707963267948966) + 6.0 * Math.cos(this.heading));
            if (x1 > 0 && x1 < this.game.map.mapPic.length && x2 > 0 && x2 < this.game.map.mapPic.length && z1 > 0 && z1 < this.game.map.mapPic.length && z2 > 0 && z2 < this.game.map.mapPic.length) {
                this.game.map.mapPic[x1][z1] = 0x606060;
                this.game.map.mapPic[x2][z2] = 0x606060;
            }
        }
        if (this.kLeft()) {
            this.heading -= 0.01;
        }
        if (this.kRight()) {
            this.heading += 0.01;
        }
        if (this.slowcounter > 0) {
            int x1 = (int)(this.pos.x - 3.0 * Math.sin(this.heading + 1.5707963267948966) + 6.0 * Math.sin(this.heading));
            x2 = (int)(this.pos.x + 3.0 * Math.sin(this.heading + 1.5707963267948966) + 6.0 * Math.sin(this.heading));
            z1 = (int)(this.pos.z - 3.0 * Math.cos(this.heading + 1.5707963267948966) + 6.0 * Math.cos(this.heading));
            z2 = (int)(this.pos.z + 3.0 * Math.cos(this.heading + 1.5707963267948966) + 6.0 * Math.cos(this.heading));
            if (x1 > 0 && x1 < this.game.map.mapPic.length && x2 > 0 && x2 < this.game.map.mapPic.length && z1 > 0 && z1 < this.game.map.mapPic.length && z2 > 0 && z2 < this.game.map.mapPic.length) {
                this.game.map.mapPic[x1][z1] = 16311887;
                this.game.map.mapPic[x2][z2] = 16311887;
            }
        }
    }

    public boolean kUse() {
        return false;
    }

    public boolean kUp() {
        return false;
    }

    public boolean kLeft() {
        return false;
    }

    public boolean kRight() {
        return false;
    }

    public boolean kDown() {
        return false;
    }

    public String getName() {
        return this.name;
    }

    public int getCheckpointsLeft() {
        return this.checkpoints.size();
    }

    protected void updateCheckpoints() {
        if (this.checkpoints.empty()) {
            return;
        }
        if (this.collides(this.checkpoints.peek())) {
            this.checkpoints.pop();
            if (this.checkpoints.empty()) {
                this.game.addFinishRacer(this);
            }
        }
    }
}

