/*
 * Decompiled with CFR 0.152.
 */
package game;

import art.Art;
import engine.Camera;
import engine.FastMath;
import engine.GraphicsEngine;
import engine.Point3D;
import engine.Sound;
import entities.Bot;
import entities.Cactus;
import entities.Checkpoint;
import entities.Entity;
import entities.House;
import entities.ItemSpawn;
import entities.Player;
import entities.Pyramid;
import entities.Racer;
import entities.Sign;
import entities.Snowman;
import entities.Tree;
import game.Input;
import game.Map;
import game.MapCity;
import game.MapDesert;
import game.MapIcy;
import game.MapWood;
import game.StartScreen;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Stack;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class Game
extends JPanel {
    private static final int STATE_RACE = 1;
    private static final int STATE_CHARACTER = 2;
    private static final int STATE_TRACK = 3;
    private static final int STATE_RESULT = 4;
    private static final int STATE_START = 5;
    private int state = 5;
    private long fps;
    private ArrayList<Entity> entities;
    private boolean painted = false;
    public Input input;
    private boolean singleplayer = false;
    public GraphicsEngine GE1;
    public GraphicsEngine GE2;
    public Dimension INGM_RES = new Dimension(400, 300);
    public BufferedImage screen;
    public Player player1;
    public Player player2;
    public Dimension res;
    public ArrayList<Racer> racers;
    private ArrayList<Racer> finishRacers;
    private ArrayList<String> finishRacersTime;
    public Map map;
    private double currentRaceTime;
    public int startCounter;
    private int laps;
    public Sound sound;
    public Color player1color;
    public Color player2color;
    public int player1type;
    public int player2type;
    public int[] racerTypes;
    public int fadeCounter;
    public boolean player1charSel;
    public boolean player2charSel;
    private boolean playersFinished;
    private final int numMaps = 4;
    private boolean musicStarted;
    private boolean snow;
    private boolean rain;
    private boolean exit;
    private int thunderCounter;
    private boolean escapeMenu;
    private boolean escapeMenuYes;
    JFrame f;
    long time1;
    private boolean birdiekartplayed;
    boolean followPlayer;
    private int trackCounter;
    public Font small;
    Font big;
    Font medium;
    int introCounter;
    public Color introColor;
    int introOpacity;
    String[] tracknames;
    private int player1charPos;
    private int player2charPos;
    private String[] names;
    Color opaque;

    public static void main(String[] args) {
        new Game();
    }

    public static int[][] imgToInt(BufferedImage img) {
        int[][] ints = new int[img.getWidth()][img.getHeight()];
        int x = 0;
        while (x < img.getWidth()) {
            int y = 0;
            while (y < img.getHeight()) {
                ints[x][y] = Art.getRGB(img, x, y);
                ++y;
            }
            ++x;
        }
        return ints;
    }

    public Game() {
        this.screen = new BufferedImage(this.INGM_RES.width, this.singleplayer ? this.INGM_RES.height : this.INGM_RES.height / 2, 1);
        this.startCounter = 310;
        this.laps = 2;
        this.fadeCounter = 99999;
        this.numMaps = 4;
        this.followPlayer = false;
        this.small = new Font("Courier", 0, 16);
        this.big = new Font("Courier", 0, 60);
        this.medium = new Font("Courier", 0, 32);
        this.introCounter = 0;
        this.introColor = new Color(0x191919);
        this.introOpacity = 255;
        this.tracknames = new String[]{"Skumma skogen", "Isiga isen", "\u00d6vergivna \u00f6knen", "Stora staden"};
        this.player1charPos = 0;
        this.player2charPos = 1;
        this.names = new String[]{"Adef Staler", "Birdie", "Usama", "Gaben", "Stephen Hawking", "Dovahkiin", "Seng\u00e5ngare", "Darth Vader"};
        this.opaque = new Color(0, 0, 0, 100);
        this.sound = new Sound();
        this.f = new StartScreen(this).getFrame();
        this.res = this.f.getSize();
        this.f.add(this);
        this.f.setVisible(true);
        this.init();
    }

    public void init() {
        this.input = new Input(this);
        this.sound.playLoop(Sound.MENUSONG, 0.25f);
        this.player1color = Color.blue;
        this.player2color = Color.yellow;
        this.racerTypes = new int[]{3, 4, 1, 5, 6, 7, 8, 9};
        this.loop();
    }

    public void initNewRace() {
        this.snow = this.map instanceof MapIcy;
        this.rain = this.map instanceof MapWood;
        this.musicStarted = false;
        this.sound.stop(Sound.MENUSONG);
        this.player1charSel = false;
        this.player2charSel = false;
        this.playersFinished = false;
        this.startCounter = 310;
        this.entities = new ArrayList();
        this.racers = new ArrayList();
        this.finishRacers = new ArrayList();
        this.finishRacersTime = new ArrayList();
        ArrayList<Checkpoint> checkarray = new ArrayList<Checkpoint>();
        ArrayList<Checkpoint> botcheckarray = new ArrayList<Checkpoint>();
        ArrayList<Point3D> botPoints = new ArrayList<Point3D>();
        this.addMapSprites(checkarray, this.map.spriteMap, botcheckarray, botPoints);
        Stack<Checkpoint> checkstack = this.getCheckStack(checkarray);
        int i = 0;
        while (i < this.laps - 1) {
            checkstack.addAll((Collection)checkarray.clone());
            ++i;
        }
        int totalCheckpoints = checkstack.size();
        int typeCounter = 0;
        int i2 = 0;
        while (i2 < 6) {
            if (typeCounter == this.player1charPos || typeCounter == this.player2charPos) {
                ++typeCounter;
            }
            if (typeCounter == this.player1charPos || typeCounter == this.player2charPos) {
                ++typeCounter;
            }
            Bot b = new Bot(this, this.map.getRacerSpawn(i2 + 2), this.racerTypes[typeCounter], (Stack)checkstack.clone(), this.map.startHeading(i2 + 2), botPoints, totalCheckpoints, "B\u00e5t: " + this.names[typeCounter]);
            this.entities.add(b);
            this.racers.add(b);
            ++typeCounter;
            ++i2;
        }
        if (this.singleplayer) {
            this.GE1 = new GraphicsEngine(this.INGM_RES.width, this.INGM_RES.height, 1, this);
            this.player1 = new Player(this, this.map.getRacerSpawn(0), this.player1type, 1, (Stack)checkstack.clone(), 1, this.map.startHeading(0), totalCheckpoints, "singelpalyer lol");
            this.entities.add(this.player1);
            this.racers.add(this.player1);
            this.GE1.cam.setState(2, this.player1, null);
        } else {
            this.GE1 = new GraphicsEngine(this.INGM_RES.width, this.INGM_RES.height / 2, 1, this);
            this.GE2 = new GraphicsEngine(this.INGM_RES.width, this.INGM_RES.height / 2, 2, this);
            this.player1 = new Player(this, this.map.getRacerSpawn(0), this.player1type, 1, (Stack)checkstack.clone(), 1, this.map.startHeading(0), totalCheckpoints, "Spelare 1: " + this.names[this.player1charPos]);
            this.entities.add(this.player1);
            this.racers.add(this.player1);
            this.player2 = new Player(this, this.map.getRacerSpawn(1), this.player2type, 2, (Stack)checkstack.clone(), 2, this.map.startHeading(1), totalCheckpoints, "Spelare 2: " + this.names[this.player2charPos]);
            this.entities.add(this.player2);
            this.racers.add(this.player2);
            this.GE1.cam.setState(2, this.player1, null);
            this.GE2.cam.setState(2, this.player2, null);
        }
        this.currentRaceTime = 0.0;
        Art.nullPics();
        this.loop();
    }

    private Stack<Checkpoint> getCheckStack(ArrayList<Checkpoint> arr) {
        int i = 1;
        while (i < arr.size()) {
            int j = i;
            while (j > 0 && arr.get((int)j).num > arr.get((int)(j - 1)).num) {
                Checkpoint temp = arr.get(j);
                arr.remove(arr.get(j));
                arr.add(j - 1, temp);
                --j;
            }
            ++i;
        }
        return this.arrToStack(arr);
    }

    private Stack<Checkpoint> arrToStack(ArrayList<Checkpoint> arr) {
        Stack<Checkpoint> s = new Stack<Checkpoint>();
        int i = 0;
        while (i < arr.size()) {
            s.push(arr.get(i));
            ++i;
        }
        return s;
    }

    public void addMapSprites(ArrayList<Checkpoint> checkarray, BufferedImage spritePic, ArrayList<Checkpoint> botcheckarray, ArrayList<Point3D> botpoints) {
        int mapwidth = spritePic.getWidth();
        int mapheight = spritePic.getHeight();
        if (this.map instanceof MapDesert) {
            this.entities.add(new Pyramid(this, new Point3D(-200.0, 0.0, -200.0)));
        }
        int x = 0;
        while (x < mapwidth) {
            int y = 0;
            while (y < mapheight) {
                int mapcol = spritePic.getRGB(x, y);
                if (mapcol == -8441088) {
                    this.entities.add(new Tree(this, new Point3D(x, 0.0, y)));
                } else if (mapcol == -256) {
                    this.entities.add(new ItemSpawn(this, new Point3D(x, 0.0, y)));
                } else if (mapcol == -65281) {
                    this.entities.add(new Snowman(this, new Point3D(x, 0.0, y)));
                } else if (mapcol == -14503604) {
                    this.entities.add(new Cactus(this, new Point3D(x, 0.0, y)));
                } else if ((mapcol >> 8 ^ 0xFF000000) == 0xFFAAAA) {
                    int num = mapcol % 0xFFFFFF;
                    checkarray.add(new Checkpoint(this, new Point3D(x, 0.0, y), num));
                } else if ((mapcol >> 8 ^ 0xFF000000) != 0xFF1111) {
                    if (mapcol == -16711936) {
                        botpoints.add(new Point3D(x, 0.0, y));
                    } else if (mapcol == -2026990) {
                        this.entities.add(new Sign(this, new Point3D(x, 0.0, y)));
                    } else if (mapcol == -15585311) {
                        this.entities.add(new House(this, new Point3D(x, 0.0, y)));
                    }
                }
                ++y;
            }
            ++x;
        }
    }

    private void sleep(int time) {
        try {
            Thread.sleep(time);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loop() {
        while (!this.exit) {
            this.time1 = System.currentTimeMillis();
            if (this.input.isKeyClicked(this.input.escape)) {
                boolean bl = this.escapeMenu = !this.escapeMenu;
            }
            if (this.escapeMenu) {
                if (this.input.isKeyClicked(this.input.a) || this.input.isKeyClicked(this.input.left) || this.input.isKeyClicked(this.input.d) || this.input.isKeyClicked(this.input.right)) {
                    boolean bl = this.escapeMenuYes = !this.escapeMenuYes;
                }
                if (this.input.isKeyClicked(this.input.enter) || this.input.isKeyClicked(this.input.q) || this.input.isKeyClicked(this.input.control)) {
                    if (this.escapeMenuYes) {
                        System.exit(0);
                    } else {
                        this.escapeMenu = false;
                    }
                }
            } else {
                ++this.fadeCounter;
                switch (this.state) {
                    case 1: {
                        this.raceLoop();
                        break;
                    }
                    case 2: {
                        this.characterLoop();
                        break;
                    }
                    case 3: {
                        this.trackLoop();
                        break;
                    }
                    case 4: {
                        this.resultLoop();
                        break;
                    }
                    case 5: {
                        this.startLoop();
                    }
                }
            }
            this.repaint();
            this.calcfps();
        }
    }

    private void startLoop() {
        if (!this.birdiekartplayed && this.introCounter > 320) {
            this.sound.play(Sound.BIRDIE_KART);
            this.birdiekartplayed = true;
        }
        if (this.input.isKeyClicked(this.input.enter)) {
            this.fadeCounter = 0;
            this.state = 2;
        }
    }

    private void calcfps() {
        long time2 = System.currentTimeMillis();
        if ((double)(time2 - this.time1) < 16.666666666666668) {
            int sleep_time = (int)(16.666666666666668 - (double)(time2 - this.time1));
            this.sleep(sleep_time);
        }
        time2 = System.currentTimeMillis();
        this.fps = (int)(1000.0 / (double)(time2 - this.time1));
        if (this.startCounter < 0) {
            this.currentRaceTime += (double)(this.fps / 62L * 16L);
        }
    }

    private void raceLoop() {
        if (this.startCounter == 0) {
            this.sound.play(Sound.GO);
        } else if (this.startCounter > 0 && this.startCounter % 62 == 0) {
            this.sound.play(Sound.BEEP);
        }
        if (this.thunderCounter < 0 && this.map instanceof MapWood && Math.random() > 0.999) {
            this.thunderCounter = 150;
            this.sound.play(Sound.THUNDER);
        }
        --this.thunderCounter;
        --this.startCounter;
        if (this.startCounter < 0 && !this.musicStarted) {
            this.musicStarted = true;
            this.sound.playLoop(Sound.MUSIC);
        }
        int i = 0;
        while (i < this.entities.size()) {
            if (this.entities.get((int)i).shallBeRemoved) {
                this.entities.remove(i);
                --i;
            }
            ++i;
        }
        i = 0;
        while (i < this.entities.size()) {
            this.entities.get(i).update();
            ++i;
        }
        this.collision();
        if (this.singleplayer) {
            this.GE1.cam.update();
        } else {
            this.GE1.cam.update();
            this.GE2.cam.update();
        }
        if (this.racers.size() == 0) {
            this.sound.stop(Sound.MUSIC);
            this.fadeCounter = 0;
            this.sound.playLoop(Sound.MENUSONG);
            this.state = 4;
        }
        if (!this.racers.contains(this.player1) && !this.racers.contains(this.player2)) {
            this.playersFinished = true;
        }
        if (this.input.isKeyClicked(this.input.enter) && this.playersFinished) {
            this.sound.stop(Sound.MUSIC);
            this.sound.playLoop(Sound.MENUSONG);
            this.forceRaceFinish();
        }
    }

    private void forceRaceFinish() {
        this.fadeCounter = 0;
        this.state = 4;
        this.sortRacerList();
        int i = 0;
        while (i < this.racers.size()) {
            this.finishRacers.add(this.racers.get(i));
            this.finishRacersTime.add("--:--");
            ++i;
        }
    }

    public void collision() {
        int i = 0;
        while (i < this.entities.size()) {
            Entity e1 = this.entities.get(i);
            int j = i + 1;
            while (j < this.entities.size() && i + 1 < this.entities.size()) {
                Entity e2 = this.entities.get(j);
                if (e1.collides(e2)) {
                    e1.collide(e2);
                    e2.collide(e1);
                }
                ++j;
            }
            ++i;
        }
    }

    private void resultLoop() {
        if (this.input.isKeyClicked(this.input.enter)) {
            this.state = 2;
        }
    }

    private void trackLoop() {
        if (this.input.isKeyClicked(this.input.a) || this.input.isKeyClicked(this.input.left)) {
            --this.trackCounter;
        } else if (this.input.isKeyClicked(this.input.d) || this.input.isKeyClicked(this.input.right)) {
            ++this.trackCounter;
        }
        if (this.input.isKeyClicked(this.input.s) || this.input.isKeyClicked(this.input.down)) {
            --this.laps;
            if (this.laps < 1) {
                this.laps = 1;
            }
        } else if (this.input.isKeyClicked(this.input.w) || this.input.isKeyClicked(this.input.up)) {
            ++this.laps;
        }
        if (this.input.isKeyClicked(this.input.enter)) {
            int currentTrack = this.trackCounter % 4;
            if (currentTrack < 0) {
                currentTrack += 4;
            }
            if (currentTrack == 0) {
                Art.reloadPicWoods();
                this.map = new MapWood();
            } else if (currentTrack == 1) {
                Art.reloadPicIce();
                this.map = new MapIcy();
            } else if (currentTrack == 2) {
                Art.reloadPicDesert();
                this.map = new MapDesert();
            } else if (currentTrack == 3) {
                Art.reloadPicCity();
                this.map = new MapCity();
            }
            this.fadeCounter = 0;
            this.state = 1;
            this.initNewRace();
        }
    }

    private void characterLoop() {
        int p1prev = this.player1charPos;
        int p2prev = this.player2charPos;
        if (this.input.isKeyClicked(this.input.w) && !this.player1charSel) {
            this.player1charPos -= 4;
            this.player1charPos %= 8;
            if (this.player1charPos < 0) {
                this.player1charPos += 8;
            }
            if (this.player1charPos == this.player2charPos) {
                this.player1charPos = p1prev;
            }
        }
        if (this.input.isKeyClicked(this.input.s) && !this.player1charSel) {
            this.player1charPos += 4;
            this.player1charPos %= 8;
            if (this.player1charPos == this.player2charPos) {
                this.player1charPos = p1prev;
            }
        }
        if (this.input.isKeyClicked(this.input.a) && !this.player1charSel) {
            --this.player1charPos;
            this.player1charPos %= 8;
            if (this.player1charPos < 0) {
                this.player1charPos += 8;
            }
            if (this.player1charPos == this.player2charPos) {
                this.player1charPos = p1prev;
            }
        }
        if (this.input.isKeyClicked(this.input.d) && !this.player1charSel) {
            ++this.player1charPos;
            this.player1charPos %= 8;
            if (this.player1charPos == this.player2charPos) {
                this.player1charPos = p1prev;
            }
        }
        if (this.input.isKeyClicked(this.input.q)) {
            boolean bl = this.player1charSel = !this.player1charSel;
            if (this.player1charSel) {
                this.sound.play(Sound.CHARACTER_SELECT[this.player1charPos]);
            }
        }
        if (this.input.isKeyClicked(this.input.up) && !this.player2charSel) {
            this.player2charPos -= 4;
            this.player2charPos %= 8;
            if (this.player2charPos < 0) {
                this.player2charPos += 8;
            }
            if (this.player1charPos == this.player2charPos) {
                this.player2charPos = p2prev;
            }
        }
        if (this.input.isKeyClicked(this.input.down) && !this.player2charSel) {
            this.player2charPos += 4;
            this.player2charPos %= 8;
            if (this.player1charPos == this.player2charPos) {
                this.player2charPos = p2prev;
            }
        }
        if (this.input.isKeyClicked(this.input.left) && !this.player2charSel) {
            --this.player2charPos;
            this.player2charPos %= 8;
            if (this.player2charPos < 0) {
                this.player2charPos += 8;
            }
            if (this.player1charPos == this.player2charPos) {
                this.player2charPos = p2prev;
            }
        }
        if (this.input.isKeyClicked(this.input.right) && !this.player2charSel) {
            ++this.player2charPos;
            this.player2charPos %= 8;
            if (this.player1charPos == this.player2charPos) {
                this.player2charPos = p2prev;
            }
        }
        if (this.input.isKeyClicked(this.input.control)) {
            boolean bl = this.player2charSel = !this.player2charSel;
            if (this.player2charSel) {
                this.sound.play(Sound.CHARACTER_SELECT[this.player2charPos]);
            }
        }
        if (this.input.isKeyClicked(this.input.enter) && this.player1charSel && this.player2charSel) {
            this.player1type = this.racerTypes[this.player1charPos];
            this.player2type = this.racerTypes[this.player2charPos];
            this.fadeCounter = 0;
            this.state = 3;
        }
    }

    @Override
    public void paint(Graphics g) {
        if (!this.escapeMenu) {
            g.setFont(this.small);
            switch (this.state) {
                case 1: {
                    this.racePaint(g);
                    break;
                }
                case 2: {
                    this.characterPaint(g);
                    break;
                }
                case 3: {
                    this.trackPaint(g);
                    break;
                }
                case 4: {
                    this.resultPaint(g);
                    break;
                }
                case 5: {
                    this.startPaint(g);
                }
            }
            g.setColor(Color.black);
            g.fillRect(0, this.fadeCounter * 4 + this.res.height / 2, this.res.width, this.res.height);
            g.fillRect(0, this.res.height / 2 - this.fadeCounter * 4, this.res.width, -this.res.height);
            this.painted = true;
        } else {
            g.setColor(Color.black);
            g.fillRect(0, 0, this.res.width, this.res.height);
            g.setColor(Color.white);
            if (this.escapeMenuYes) {
                g.fillRect(this.res.width / 2 - 125, this.res.height / 2 - 50, 120, 65);
            } else {
                g.fillRect(this.res.width / 2 + 90, this.res.height / 2 - 50, 120, 65);
            }
            g.setFont(this.big);
            g.drawString("AVSLUTA?", this.res.width / 2 - 80, this.res.height / 2 - 100);
            g.setColor(Color.RED);
            g.drawString("JA", this.res.width / 2 - 100, this.res.height / 2);
            g.setColor(Color.GREEN);
            g.drawString("NEJ", this.res.width / 2 + 100, this.res.height / 2);
        }
    }

    private void startPaint(Graphics g) {
        ++this.introCounter;
        if (this.introCounter % 2 == 0) {
            --this.introOpacity;
        }
        g.setColor(this.introColor);
        g.fillRect(0, 0, this.res.width, this.res.height);
        if (this.introCounter == 280) {
            this.introOpacity = 0;
            this.fadeCounter = 0;
        } else if (this.introCounter < 280) {
            g.drawImage(Art.introOJ, 0, 0, this.res.width, this.res.height, null);
        } else {
            g.drawImage(Art.introBirdie, 0, 0, this.res.width, this.res.height, null);
        }
        this.introOpacity = this.introOpacity < 0 ? 0 : this.introOpacity;
        g.setColor(new Color(0, 0, 0, this.introOpacity));
        g.fillRect(0, 0, this.res.width, this.res.height);
    }

    private void resultPaint(Graphics g) {
        g.setColor(Color.black);
        g.fillRect(0, 0, this.res.width, this.res.height);
        int x = 100;
        int y = 100;
        int i = 0;
        while (i < this.finishRacers.size()) {
            if (this.finishRacers.get(i) == this.player1) {
                g.setColor(this.player1color);
            } else if (this.finishRacers.get(i) == this.player2) {
                g.setColor(this.player2color);
            } else {
                g.setColor(Color.white);
            }
            g.drawString(i + 1 + ": " + this.finishRacersTime.get(i) + " " + this.finishRacers.get(i).getName(), x, y);
            y += 20;
            ++i;
        }
    }

    private void trackPaint(Graphics g) {
        g.setColor(this.introColor);
        g.fillRect(0, 0, this.res.width, this.res.height);
        g.setColor(Color.white);
        int x = this.trackCounter % 4;
        if (x < 0) {
            x += 4;
        }
        g.fillRect(this.res.width / 2 - 340 + x * 170 - 10, this.res.height / 2 - 10, 170, 170);
        int i = 0;
        while (i < 4) {
            if (i == 0) {
                g.drawImage(Art.woodyPic, this.res.width / 2 - 340 + i * 170, this.res.height / 2, null);
            } else if (i == 1) {
                g.drawImage(Art.picIcy, this.res.width / 2 - 340 + i * 170, this.res.height / 2, null);
            } else if (i == 2) {
                g.drawImage(Art.picDesert, this.res.width / 2 - 340 + i * 170, this.res.height / 2, null);
            } else {
                g.drawImage(Art.picCity, this.res.width / 2 - 340 + i * 170, this.res.height / 2, null);
            }
            g.drawString(this.tracknames[i], this.res.width / 2 - 340 + i * 170, this.res.height / 2 - 25);
            ++i;
        }
        g.setFont(this.big);
        g.drawString("V\u00e4lj bana", 160, this.res.height / 2 - 200);
        g.setFont(this.medium);
        g.drawString("Antal varv: " + this.laps, this.res.width - 350, this.res.height / 2 - 100);
        g.setFont(this.small);
        g.drawString("\u00d6ka: W/upp Minska: S/ned", this.res.width - 350, this.res.height / 2 - 80);
    }

    private void characterPaint(Graphics g) {
        g.setColor(this.introColor);
        g.fillRect(0, 0, this.res.width, this.res.height);
        g.setColor(this.player1color);
        g.setFont(this.small);
        g.translate(this.res.width / 2 - 320, this.res.height / 2 - 150);
        g.drawString("Spelare 1", 0, 0);
        g.drawString("Styrning: WASD", 0, 20);
        g.drawString("Anv\u00e4nd/V\u00e4lj: Q", 0, 40);
        g.drawString("Karakt\u00e4r: " + this.names[this.player1charPos], 0, 60);
        if (this.player1charSel) {
            g.drawString("Redo: Ja", 0, 80);
        } else {
            g.drawString("Redo: Nej", 0, 80);
        }
        g.drawString("Vikt:", 0, 120);
        g.drawString("Acc:", 0, 160);
        g.drawString("Fart:", 0, 200);
        double v = Racer.getStatsWeight(this.racerTypes[this.player1charPos]) / Racer.STATS_MAX_WEIGHT;
        int rgb = (int)(v * 255.0);
        g.setColor(new Color(255 - rgb, rgb, 0));
        g.fillRect(110, 105, (int)(v * 75.0), 20);
        v = Racer.getStatsAcc(this.racerTypes[this.player1charPos]) / Racer.STATS_MAX_ACC;
        rgb = (int)(v * 255.0);
        g.setColor(new Color(255 - rgb, rgb, 0));
        g.fillRect(110, 145, (int)(v * 75.0), 20);
        v = Racer.getStatsMaxSpeed(this.racerTypes[this.player1charPos]) / Racer.STATS_MAX_MAX_SPEED;
        rgb = (int)(v * 255.0);
        g.setColor(new Color(255 - rgb, rgb, 0));
        g.fillRect(110, 185, (int)(v * 75.0), 20);
        g.translate(-this.res.width / 2 + 320, -this.res.height / 2 + 150);
        g.setColor(this.player1color);
        if (this.player1charPos < 4) {
            g.fillRect(this.res.width / 2 - 125 + this.player1charPos * 60 + 10, this.res.height / 2 - 65, 60, 60);
        } else {
            g.fillRect(this.res.width / 2 - 125 + (this.player1charPos - 4) * 60 + 10, this.res.height / 2 + 5, 60, 60);
        }
        g.setColor(this.player2color);
        g.translate(this.res.width / 2 + 170, this.res.height / 2 - 150);
        g.drawString("Spelare 2", 0, 0);
        g.drawString("Styrning: Pilarna", 0, 20);
        g.drawString("Anv\u00e4nd/V\u00e4lj: CTRL", 0, 40);
        g.drawString("Karakt\u00e4r: " + this.names[this.player2charPos], 0, 60);
        if (this.player2charSel) {
            g.drawString("Redo: Ja", 0, 80);
        } else {
            g.drawString("Redo: Nej", 0, 80);
        }
        g.drawString("Vikt:", 0, 120);
        g.drawString("Acc:", 0, 160);
        g.drawString("Fart:", 0, 200);
        v = Racer.getStatsWeight(this.racerTypes[this.player2charPos]) / Racer.STATS_MAX_WEIGHT;
        rgb = (int)(v * 255.0);
        g.setColor(new Color(255 - rgb, rgb, 0));
        g.fillRect(110, 105, (int)(v * 75.0), 20);
        v = Racer.getStatsAcc(this.racerTypes[this.player2charPos]) / Racer.STATS_MAX_ACC;
        rgb = (int)(v * 255.0);
        g.setColor(new Color(255 - rgb, rgb, 0));
        g.fillRect(110, 145, (int)(v * 75.0), 20);
        v = Racer.getStatsMaxSpeed(this.racerTypes[this.player2charPos]) / Racer.STATS_MAX_MAX_SPEED;
        rgb = (int)(v * 255.0);
        g.setColor(new Color(255 - rgb, rgb, 0));
        g.fillRect(110, 185, (int)(v * 75.0), 20);
        g.translate(-this.res.width / 2 - 170, -this.res.height / 2 + 150);
        g.setColor(this.player2color);
        if (this.player2charPos < 4) {
            g.fillRect(this.res.width / 2 - 125 + this.player2charPos * 60 + 10, this.res.height / 2 - 65, 60, 60);
        } else {
            g.fillRect(this.res.width / 2 - 125 + (this.player2charPos - 4) * 60 + 10, this.res.height / 2 + 5, 60, 60);
        }
        int i = 0;
        while (i < 8) {
            if (i < 4) {
                g.drawImage(Art.portraits[0][i], this.res.width / 2 - 120 + i * 60 + 10, this.res.height / 2 - 60, null);
            } else {
                g.drawImage(Art.portraits[0][i], this.res.width / 2 - 120 + (i - 4) * 60 + 10, this.res.height / 2 + 10, null);
            }
            ++i;
        }
    }

    public void sortEntities(ArrayList<Entity> arr, Camera cam) {
        int i = 1;
        while (i < arr.size()) {
            int j = i;
            while (j > 0 && arr.get(j).disToCam(cam) > arr.get(j - 1).disToCam(cam)) {
                Entity temp = arr.get(j);
                arr.remove(arr.get(j));
                arr.add(j - 1, temp);
                --j;
            }
            ++i;
        }
    }

    private void racePaint(Graphics g) {
        ArrayList e2 = (ArrayList)this.entities.clone();
        if (this.singleplayer && this.GE1 != null) {
            this.sortEntities(e2, this.GE1.cam);
            this.GE1.renderMap(this.map.mapPic, this.screen, false, false);
            g.drawImage(this.screen, 0, 0, 800, 600, null);
            int i = 0;
            while (i < e2.size()) {
                ((Entity)e2.get(i)).draw(g, 0, this.GE1, this.INGM_RES, this.res);
                ++i;
            }
            g.setColor(Color.RED);
            g.drawString("Checkpoints left: " + this.player1.checkpoints.size(), 100, 100);
            g.drawString("Item: " + this.player1.getItemName(), 100, 120);
        } else if (this.GE1 != null && this.GE2 != null) {
            this.sortEntities(e2, this.GE2.cam);
            this.GE2.renderMap(this.map.mapPic, this.screen, this.snow, this.rain);
            g.drawImage(this.screen, 0, this.res.height / 2, this.res.width, this.res.height / 2, null);
            int i = 0;
            while (i < e2.size()) {
                ((Entity)e2.get(i)).draw(g, this.res.height / 2, this.GE2, this.INGM_RES, this.res);
                ++i;
            }
            this.sortEntities(e2, this.GE1.cam);
            this.GE1.renderMap(this.map.mapPic, this.screen, this.snow, this.rain);
            g.drawImage(this.screen, 0, 0, this.res.width, this.res.height / 2, null);
            i = 0;
            while (i < e2.size()) {
                ((Entity)e2.get(i)).draw(g, 0, this.GE1, this.INGM_RES, this.res);
                ++i;
            }
            if (this.thunderCounter > 0 && this.thunderCounter % 10 == 0) {
                g.setColor(new Color(0x55FFFFFF));
                g.fillRect(0, 0, this.res.width, this.res.height);
            }
        }
        this.drawHud(g);
    }

    public void drawHud(Graphics g) {
        g.drawLine(0, this.res.height / 2, this.res.width, this.res.height / 2);
        this.drawLeaderboard(g);
        this.drawTime(g);
        this.drawItem(g);
        this.drawPlace(g);
        this.drawLap(g);
        this.drawStartCounter(g);
        this.drawFinishRace(g);
    }

    public void drawFinishRace(Graphics g) {
        if (this.playersFinished) {
            g.setFont(this.big);
            g.setColor(Color.RED);
            g.drawString("Tryck ENTER", this.res.width / 2 - 300, this.res.height / 2 - 60);
            g.drawString("f\u00f6r att avsluta", this.res.width / 2 - 300, this.res.height / 2 + 15);
        }
    }

    public void drawLap(Graphics g) {
        int lap;
        double proc;
        int taken;
        g.setColor(Color.white);
        g.setFont(this.medium);
        if (this.player1.checkpoints.size() != 0) {
            taken = this.player1.totalCheckpoints - this.player1.checkpoints.size();
            proc = (double)taken / (double)this.player1.totalCheckpoints;
            lap = (int)(proc * (double)this.laps) + 1;
            g.drawString(lap + "/" + this.laps, this.res.width - 70, 100);
        }
        if (this.player2.checkpoints.size() != 0) {
            taken = this.player2.totalCheckpoints - this.player2.checkpoints.size();
            proc = (double)taken / (double)this.player2.totalCheckpoints;
            lap = (int)(proc * (double)this.laps) + 1;
            g.drawString(lap + "/" + this.laps, this.res.width - 70, this.res.height / 2 + 100);
        }
    }

    public void drawVelocity(Graphics g) {
        g.setFont(this.small);
        g.setColor(Color.red);
        int x = 100;
        int y = this.res.height / 2 - 100;
        int len = 50;
        double proc = Math.PI * 2 * Point3D.len(this.player1.vel) / 5.0;
        g.drawArc(x - 50, y - 50, 100, 100, -45, 270);
        g.drawLine(x, y, (int)((float)x - FastMath.cos(proc - 0.7853981633974483) * (float)len), (int)((float)y - FastMath.sin(proc - 0.7853981633974483) * (float)len));
        y = this.res.height - 75;
        proc = Math.PI * 2 * Point3D.len(this.player2.vel) / 5.0;
        g.drawLine(x, y, (int)((float)x - FastMath.cos(proc - 0.7853981633974483) * (float)len), (int)((float)y - FastMath.sin(proc - 0.7853981633974483) * (float)len));
    }

    public void drawPlace(Graphics g) {
        g.setFont(this.big);
        g.setColor(this.opaque);
        g.fillRect(this.res.width - 80, 10, 100, 100);
        g.fillRect(this.res.width - 80, this.res.height / 2 + 10, 100, 100);
        g.setColor(this.player1color);
        if (this.finishRacers.contains(this.player1)) {
            g.drawString("" + (this.finishRacers.indexOf(this.player1) + 1), this.res.width - 45, 60);
        } else {
            g.drawString("" + (this.racers.indexOf(this.player1) + 1 + this.finishRacers.size()), this.res.width - 45, 60);
        }
        g.setColor(this.player2color);
        if (this.finishRacers.contains(this.player2)) {
            g.drawString("" + (this.finishRacers.indexOf(this.player2) + 1), this.res.width - 45, this.res.height / 2 + 60);
        } else {
            g.drawString("" + (this.racers.indexOf(this.player2) + 1 + this.finishRacers.size()), this.res.width - 45, this.res.height / 2 + 60);
        }
    }

    public void drawItem(Graphics g) {
        g.setFont(this.small);
        g.setColor(this.player1color);
        if (this.player1.item != null) {
            g.drawImage(this.player1.item.getPic(), 20, 20, null);
        } else {
            g.drawImage(Art.noItem, 20, 20, null);
        }
        g.setColor(this.player2color);
        if (this.player2.item != null) {
            g.drawImage(this.player2.item.getPic(), 20, this.res.height - 100, null);
        } else {
            g.drawImage(Art.noItem, 20, this.res.height - 100, null);
        }
    }

    public void drawTime(Graphics g) {
        g.setFont(this.small);
        g.setColor(this.opaque);
        g.fillRect(0, this.res.height / 2 - 70, 100, 30);
        g.setColor(Color.white);
        g.drawString(this.miliTimeToString(this.currentRaceTime), 20, this.res.height / 2 - 50);
    }

    public void drawStartCounter(Graphics g) {
        if (this.startCounter > 0) {
            g.setColor(Color.BLACK);
            g.fillRect(this.res.width / 2 - 50, this.res.height / 2 - 50, 100, 100);
            g.setFont(this.big);
            g.setColor(Color.WHITE);
            g.drawRect(this.res.width / 2 - 50, this.res.height / 2 - 50, 100, 100);
            if (this.startCounter / 62 == 0) {
                g.drawString("GO", this.res.width / 2 - 37, this.res.height / 2 + 15);
            } else {
                g.drawString("" + this.startCounter / 62, this.res.width / 2 - 18, this.res.height / 2 + 15);
            }
        }
    }

    private void sortRacerList() {
        int i = 1;
        while (i < this.racers.size()) {
            Racer newValue = this.racers.get(i);
            int j = i;
            while (j > 0 && this.racerFirst(this.racers.get(j - 1), newValue)) {
                this.racers.set(j, this.racers.get(j - 1));
                --j;
            }
            this.racers.set(j, newValue);
            ++i;
        }
    }

    private void drawLeaderboard(Graphics g) {
        this.sortRacerList();
        int i = 0;
        while (i < this.racers.size()) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.translate(i * 55 + 10 + 25, this.res.height / 2);
            g2d.rotate(this.racers.get((int)i).dRot * 50.0);
            if (this.racers.get(i) instanceof Player) {
                if (((Player)this.racers.get((int)i)).player == 1) {
                    g.setColor(this.player1color);
                } else {
                    g.setColor(this.player2color);
                }
                g.fillRect(-27, -27, 54, 54);
            }
            g.drawImage(this.racers.get((int)i).leaderboardPic, -25, -25, null);
            g2d.rotate(-this.racers.get((int)i).dRot * 50.0);
            g2d.translate(-i * 55 - 10 - 25, -this.res.height / 2);
            ++i;
        }
    }

    private boolean racerFirst(Racer r1, Racer r2) {
        if (r1.getCheckpointsLeft() > r2.getCheckpointsLeft()) {
            return true;
        }
        if (r1.getCheckpointsLeft() == r2.getCheckpointsLeft()) {
            return r1.disTo(r1.checkpoints.peek()) > r2.disTo(r2.checkpoints.peek());
        }
        return false;
    }

    public void addEntity(Entity e) {
        this.entities.add(e);
    }

    public Map getMap() {
        return this.map;
    }

    public void addFinishRacer(Racer r) {
        this.finishRacers.add(r);
        this.finishRacersTime.add(this.miliTimeToString(this.currentRaceTime));
        this.racers.remove(r);
        if (r instanceof Player) {
            if (((Player)r).player == 1) {
                this.GE1.cam.setState(3, this.player1, null);
            } else if (((Player)r).player == 2) {
                this.GE2.cam.setState(3, this.player2, null);
            }
        }
    }

    public String miliTimeToString(double time) {
        int d = (int)(time % 100.0);
        int s = (int)(time / 1000.0) % 60;
        int m = (int)(time / 60000.0);
        String ms = "" + m;
        String ss = "" + s;
        if (m < 10) {
            ms = "0" + m;
        }
        if (s < 10) {
            ss = "0" + s;
        }
        return ms + ":" + ss;
    }
}

