/*
 * test.cpp
 *
 *  Created on: 6 dec 2011
 *      Author: Reii
 */
#include "SDL/SDL.h"
#include "GameEngine.h"
#include "Player.h"
#include "Player2.h"
#include "Enemy.h"
#include "Life.h"
#include "Globals.h"

GameEngine engine;

void run(){
	Player* p1 = Player::getInstance("Images/Player1.bmp",false, true, 500, 500);
	Player2* p2 = Player2::getInstance("Images/Player2.bmp",false, true, 650, 500);
	engine.addSprite(p2);
	engine.addSprite(p1);

	int frame = 0;

	while(!globals.getQuit()){

		engine.initEngine();

		frame++;

		if(frame == 1 || frame == 180 || frame == 360){
			Enemy* enemy = Enemy::getInstance("Images/Enemy.bmp", false, false, 50,50);
			engine.addSprite(enemy);
		}else if(frame == 540){
			Life* life = Life::getInstance("Images/Life.bmp", false, false, 500,260);
			engine.addSprite(life);
		}else if(frame == 720){
			frame = 0;
		}
	}
	engine.clearEngine();
}

int main( int argc, char* args[] ){

	bool quit = false;

	while(!quit && !globals.getQuitProgram()){

		std::string menu = globals.getMenu();

		SDL_Surface* splash = SDL_LoadBMP(menu.c_str());
		SDL_BlitSurface(splash, NULL, globals.getScreen(), NULL);
		SDL_Flip(globals.getScreen());

		SDL_Event event;
		while(SDL_PollEvent(&event)){
			switch(event.type){
			case SDL_QUIT:
				quit = true;
				break;
			case SDL_KEYDOWN:
				switch(event.key.keysym.sym){
					case SDLK_RETURN:
						SDL_FreeSurface(splash);
						globals.Start();
						run();
						break;
					case SDLK_ESCAPE:
						quit = true;
						break;
					default:
						break;
				}
				break;
			}
		}
	}
return 0;
}


