

struct VS_OUTPUT {  float4 Position: POSITION;  float3 Tex0:     TEXCOORD0;};

sampler t0 = sampler_state{  MipFilter = LINEAR;  MinFilter = LINEAR;  MagFilter = LINEAR;};
sampler t1 = sampler_state{  MipFilter = LINEAR;  MinFilter = LINEAR;  MagFilter = LINEAR;};

float V_Alpha : ALPHA;
float V_Time : TIME;
float V_InvH : INVSCREENH;
float V_InvW : INVSCREENW;
float V_Var1 : VAR1;
float V_Var2 : VAR2;
float V_Var3 : VAR3;
float V_Var4 : VAR4;
float V_Var5 : VAR5;
float V_Var6 : VAR6;
float V_Var7 : VAR7;
float V_Var8 : VAR8;
float V_Var9 : VAR9;
float V_Var10 : VAR10;
float V_Rand1 : RAND1;
float V_Rand2 : RAND2;
float4 PS(VS_OUTPUT In) : COLOR0
{  
  float2 xy=In.Tex0.xy;
  float2 aspect=float2(V_InvH/V_InvW,1.0);
  float2 rxy=step(abs(sin(3.1416*0.5*xy/float2(V_InvW,V_InvH))),0.1);
  float4 color = tex2D(t0, xy)*0.0001+tex2D(t1, frac(xy*pow(V_Var1,2.0)*2.0*float2(V_Var2,1.0-V_Var2)+float2(V_Rand1,V_Rand2)));
  float lines=smoothstep(0.1,0.9,pow(abs(sin(3.1416*(1.0/round(2.0/V_Var3))*xy.y/V_InvH)),2.0));
  color.rgb*=lerp(1.0,lines,V_Var6);
  color.rgb=pow(color.rgb*1.5,V_Var7/(1.0-V_Var7));
  color.rgb*=1.0-V_Var10*length(sign(xy-0.5)*pow(2.0*abs(xy-0.5),1.0/V_Var9));
  color.a=lerp(1.0,color.r,V_Var4);
  color.a = color.a*V_Alpha;
  
  return color;
}

technique t
{
  pass p0
  {
    PixelShader = compile ps_2_0 PS();
  }
}

