/*
 * Decompiled with CFR 0.152.
 */
package dalexfractal;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Timer;
import java.util.TimerTask;

public final class alexFractal
extends Applet
implements Runnable {
    private int maxCount = 192;
    private int fractal = 0;
    private boolean smooth = false;
    private boolean antialias = false;
    private boolean toDrag = false;
    private boolean rect = true;
    private Color[][] colors;
    private int pal = 0;
    private boolean julia = false;
    private double juliaX = 0.56667;
    private double juliaY = -0.5;
    private boolean toDrawAll = true;
    private boolean toDrawPreview = false;
    private double viewX = 0.0;
    private double viewY = 0.0;
    private double zoom = 1.0;
    private Image image;
    private Graphics graphics;
    private int width;
    private int height;
    private Image previewImage;
    private Image bufferImage;
    private Graphics bufferGraphics;
    private Thread thread = null;
    private static final int[][][] colpal = new int[][][]{new int[][]{{12, 0, 10, 20}, {12, 50, 100, 240}, {12, 20, 3, 26}, {12, 230, 60, 20}, {12, 25, 10, 9}, {12, 230, 170, 0}, {12, 20, 40, 10}, {12, 0, 100, 0}, {12, 5, 10, 10}, {12, 210, 70, 30}, {12, 90, 0, 50}, {12, 180, 90, 120}, {12, 0, 20, 40}, {12, 30, 70, 200}}, new int[][]{{10, 70, 0, 20}, {10, 100, 0, 100}, {14, 255, 0, 0}, {10, 255, 200, 0}}, new int[][]{{8, 40, 70, 10}, {9, 40, 170, 10}, {6, 100, 255, 70}, {8, 255, 255, 255}}, new int[][]{{12, 0, 0, 64}, {12, 0, 0, 255}, {10, 0, 255, 255}, {12, 128, 255, 255}, {14, 64, 128, 255}}, new int[][]{{16, 0, 0, 0}, {32, 255, 255, 255}}};
    public Timer timer;
    private int timerCount = 0;
    public Timer timer2;
    private static final int[][] rows = new int[][]{{0, 16, 8}, {8, 16, 8}, {4, 16, 4}, {12, 16, 4}, {2, 16, 2}, {10, 16, 2}, {6, 16, 2}, {14, 16, 2}, {1, 16, 1}, {9, 16, 1}, {5, 16, 1}, {13, 16, 1}, {3, 16, 1}, {11, 16, 1}, {7, 16, 1}, {15, 16, 1}};

    public void Reminder(int seconds) {
        this.timer = new Timer();
        this.timer.schedule((TimerTask)new Task1(), 0L, (long)(seconds * 1000));
    }

    @Override
    public void init() {
        this.colors = new Color[colpal.length][];
        for (int p = 0; p < colpal.length; ++p) {
            int i;
            int n = 0;
            for (i = 0; i < colpal[p].length; ++i) {
                n += colpal[p][i][0];
            }
            this.colors[p] = new Color[n];
            n = 0;
            for (i = 0; i < colpal[p].length; ++i) {
                int[] c1 = colpal[p][i];
                int[] c2 = colpal[p][(i + 1) % colpal[p].length];
                for (int j = 0; j < c1[0]; ++j) {
                    this.colors[p][n + j] = new Color((c1[1] * (c1[0] - 1 - j) + c2[1] * j) / (c1[0] - 1), (c1[2] * (c1[0] - 1 - j) + c2[2] * j) / (c1[0] - 1), (c1[3] * (c1[0] - 1 - j) + c2[3] * j) / (c1[0] - 1));
                }
                n += c1[0];
            }
        }
        this.thread = null;
        this.Reminder(5);
    }

    @Override
    public void start() {
        this.redraw(false);
    }

    @Override
    public void destroy() {
        Thread t = this.thread;
        this.thread = null;
        t.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.thread != null) {
            while (this.draw() || Thread.interrupted()) {
            }
            alexFractal alexFractal2 = this;
            synchronized (alexFractal2) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private void redraw(boolean preview) {
        this.markDraw(preview);
        if (this.thread != null && this.thread.isAlive()) {
            this.thread.interrupt();
        } else {
            this.thread = new Thread(this);
            this.thread.setPriority(1);
            this.thread.start();
        }
    }

    private synchronized boolean toDraw(boolean preview) {
        boolean f;
        boolean bl = f = preview ? this.toDrawPreview : this.toDrawAll;
        if (preview) {
            this.toDrawPreview = false;
        } else {
            this.toDrawAll = false;
        }
        return f;
    }

    private synchronized void markDraw(boolean preview) {
        if (preview) {
            this.toDrawPreview = true;
        } else {
            this.toDrawAll = true;
        }
    }

    private synchronized Color getColor(int i) {
        int palSize = this.colors[this.pal].length;
        if (i + palSize < 0) {
            i = Math.max(0, i + palSize);
        }
        return this.colors[this.pal][(i + palSize) % palSize];
    }

    private synchronized void nextPalette() {
        this.pal = (this.pal + 1) % this.colors.length;
    }

    private boolean draw() {
        if (!this.toDraw(false)) {
            return false;
        }
        Dimension size = this.getSize();
        if (this.image == null || size.width != this.width || size.height != this.height) {
            this.width = size.width;
            this.height = size.height;
            this.image = this.createImage(this.width, this.height);
            this.graphics = this.image.getGraphics();
            this.previewImage = this.createImage(this.width / 4, this.height / 4);
            this.bufferImage = this.createImage(this.width, this.height);
            this.bufferGraphics = this.bufferImage.getGraphics();
        }
        double r = this.zoom / (double)Math.min(this.width, this.height);
        double sx = this.width > this.height ? 2.0 * r * (double)(this.width - this.height) : 0.0;
        double sy = this.height > this.width ? 2.0 * r * (double)(this.height - this.width) : 0.0;
        for (int y = 0; y < this.height + 4; y += 8) {
            if (Thread.interrupted() && this.toDrawAll) {
                return true;
            }
            for (int x = 0; x < this.width + 4; x += 8) {
                double dx = 4.0 * ((double)x * r + this.viewX) - 2.0 - sx;
                double dy = -4.0 * ((double)y * r + this.viewY) + 2.0 + sy;
                Color color = this.color(dx, dy);
                this.graphics.setColor(color);
                this.graphics.fillRect(x - 4, y - 4, 8, 8);
            }
        }
        this.repaint();
        for (int row = 0; row < rows.length; ++row) {
            for (int y = rows[row][0]; y < this.height; y += rows[row][1]) {
                if (Thread.interrupted() && this.toDrawAll) {
                    return true;
                }
                for (int x = 0; x < this.width; ++x) {
                    double dx = 4.0 * ((double)x * r + this.viewX) - 2.0 - sx;
                    double dy = -4.0 * ((double)y * r + this.viewY) + 2.0 + sy;
                    Color color = this.color(dx, dy);
                    if (this.antialias) {
                        Color c1 = this.color(dx - 0.25 * r, dy - 0.25 * r);
                        Color c2 = this.color(dx + 0.25 * r, dy - 0.25 * r);
                        Color c3 = this.color(dx + 0.25 * r, dy + 0.25 * r);
                        Color c4 = this.color(dx - 0.25 * r, dy + 0.25 * r);
                        int red = (color.getRed() + c1.getRed() + c2.getRed() + c3.getRed() + c4.getRed()) / 5;
                        int green = (color.getGreen() + c1.getGreen() + c2.getGreen() + c3.getGreen() + c4.getGreen()) / 5;
                        int blue = (color.getBlue() + c1.getBlue() + c2.getBlue() + c3.getBlue() + c4.getBlue()) / 5;
                        color = new Color(red, green, blue);
                    }
                    this.graphics.setColor(color);
                    this.graphics.fillRect(x, y - rows[row][2] / 2, 1, rows[row][2]);
                }
            }
            this.repaint();
        }
        return this.toDraw(false);
    }

    private Color color(double x, double y) {
        int count = this.julia ? this.zfun(x, y, this.juliaX, this.juliaY) : this.zfun(0.0, 0.0, x, y);
        Color color = this.getColor(count / 256);
        if (this.smooth) {
            Color color2 = this.getColor(count / 256 - 1);
            int k1 = count % 256;
            int k2 = 255 - k1;
            int red = (k1 * color.getRed() + k2 * color2.getRed()) / 255;
            int green = (k1 * color.getGreen() + k2 * color2.getGreen()) / 255;
            int blue = (k1 * color.getBlue() + k2 * color2.getBlue()) / 255;
            color = new Color(red, green, blue);
        }
        return color;
    }

    private int zfun(double zr, double zi, double cr, double ci) {
        switch (this.fractal) {
            case 1: {
                return this.phoenix(zr, zi, cr, ci);
            }
        }
        return this.mandel(zr, zi, cr, ci);
    }

    private int mandel(double zr, double zi, double cr, double ci) {
        int count;
        double pr = zr * zr;
        double pi = zi * zi;
        double zm = 0.0;
        for (count = 0; pr + pi < 4.0 && count < this.maxCount; ++count) {
            zm = pr + pi;
            zi = 2.0 * zr * zi + ci;
            zr = pr - pi + cr;
            pr = zr * zr;
            pi = zi * zi;
        }
        if (count == 0 || count == this.maxCount) {
            return 0;
        }
        return 256 * count + (this.smooth ? (int)(255.0 * Math.log(4.0 / (zm += 1.0E-9)) / Math.log((pr + pi) / zm)) : 0);
    }

    private int phoenix(double zr, double zi, double cr, double ci) {
        int count;
        double pr = zr * zr;
        double pi = zi * zi;
        double sr = 0.0;
        double si = 0.0;
        double zm = 0.0;
        for (count = 0; pr + pi < 4.0 && count < this.maxCount; ++count) {
            zm = pr + pi;
            pr = pr - pi + ci * sr + cr;
            pi = 2.0 * zr * zi + ci * si;
            sr = zr;
            si = zi;
            zr = pr;
            zi = pi;
            pr = zr * zr;
            pi = zi * zi;
        }
        if (count == 0 || count == this.maxCount) {
            return 0;
        }
        return 256 * count + (this.smooth ? (int)(255.0 * Math.log(4.0 / (zm += 1.0E-9)) / Math.log((pr + pi) / zm)) : 0);
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        if (this.image == null) {
            return;
        }
        Dimension size = this.getSize();
        if (size.width != this.width || size.height != this.height) {
            this.redraw(false);
            return;
        }
        this.bufferGraphics.drawImage(this.image, 0, 0, null);
        g.drawImage(this.bufferImage, 0, 0, null);
    }

    public static void main(String[] args) {
        Frame frame = new Frame("Alex Fractal Viewer");
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        alexFractal applet = new alexFractal();
        frame.add((Component)applet, "Center");
        frame.setSize(1024, 768);
        frame.show();
        ((Applet)applet).init();
        ((Applet)applet).start();
    }

    public class Task1
    extends TimerTask {
        @Override
        public void run() {
            alexFractal.this.nextPalette();
            if (alexFractal.this.timerCount >= 4) {
                alexFractal.this.timerCount = 0;
                alexFractal.this.viewX = (alexFractal.this.viewY = 0.0);
                alexFractal.this.zoom = 1.0;
            } else {
                alexFractal.this.viewX += 0.2 * alexFractal.this.zoom - 0.02;
                alexFractal.this.viewY += 0.2 * alexFractal.this.zoom - 0.04;
                alexFractal.this.zoom *= 0.6;
                alexFractal.this.timerCount++;
            }
            alexFractal.this.redraw(false);
        }
    }
}

