/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.experimental;

import com.badlogic.gdx.InputAdapter;
import com.badlogic.gdx.graphics.PerspectiveCamera;
import com.badlogic.gdx.math.MathUtils;

public class PerspectiveCamController
extends InputAdapter {
    static final float MOUSE_SENSITIVITY = 0.25f;
    static final float MOVE_SPEED = 2.0f;
    static final float MOVE_SPEED_SQRT = (float)Math.sqrt(2.0);
    static final float NINETY_DEGREE = 89.99f;
    PerspectiveCamera cam;
    int lastX;
    int lastY;
    float angleX = -90.0f;
    float angleY = 0.0f;
    boolean W;
    boolean A;
    boolean S;
    boolean D;

    public PerspectiveCamController(PerspectiveCamera cam) {
        this.cam = cam;
    }

    @Override
    public boolean touchDown(int x, int y, int pointer, int button) {
        this.lastX = x;
        this.lastY = y;
        return true;
    }

    @Override
    public boolean touchDragged(int x, int y, int pointer) {
        this.angleX += (float)(this.lastX - x) * 0.25f;
        this.lastX = x;
        this.angleY += (float)(this.lastY - y) * -0.25f;
        this.lastY = y;
        if (this.angleY > 89.99f) {
            this.angleY = 89.99f;
        } else if (this.angleY < -89.99f) {
            this.angleY = -89.99f;
        }
        float cos = MathUtils.cosDeg(this.angleY);
        this.cam.direction.x = MathUtils.cosDeg(this.angleX) * cos;
        this.cam.direction.y = MathUtils.sinDeg(this.angleY) * 1.0f;
        this.cam.direction.z = MathUtils.sinDeg(this.angleX) * cos;
        this.cam.update();
        return true;
    }

    @Override
    public boolean scrolled(int amount) {
        this.cam.fieldOfView -= (float)(-amount) * 0.1f;
        this.cam.update();
        return true;
    }

    @Override
    public boolean keyDown(int keycode) {
        if (keycode == 29) {
            this.A = true;
        } else if (keycode == 32) {
            this.D = true;
        } else if (keycode == 47) {
            this.S = true;
        } else if (keycode == 51) {
            this.W = true;
        }
        return false;
    }

    @Override
    public boolean keyUp(int keycode) {
        if (keycode == 29) {
            this.A = false;
        } else if (keycode == 32) {
            this.D = false;
        } else if (keycode == 47) {
            this.S = false;
        } else if (keycode == 51) {
            this.W = false;
        }
        return false;
    }

    void update(float delta) {
        if (!(this.A | this.D | this.W | this.S)) {
            return;
        }
        delta = (this.A ^ this.D) & (this.W ^ this.S) ? (delta *= MOVE_SPEED_SQRT) : (delta *= 2.0f);
        if (this.A & !this.D) {
            this.cam.position.x += delta * MathUtils.sinDeg(this.angleX);
            this.cam.position.z -= delta * MathUtils.cosDeg(this.angleX);
        }
        if (this.D & !this.A) {
            this.cam.position.x -= delta * MathUtils.sinDeg(this.angleX);
            this.cam.position.z += delta * MathUtils.cosDeg(this.angleX);
        }
        if (this.W & !this.S) {
            this.cam.position.x += delta * this.cam.direction.x;
            this.cam.position.y += delta * this.cam.direction.y;
            this.cam.position.z += delta * this.cam.direction.z;
        }
        if (this.S & !this.W) {
            this.cam.position.x -= delta * this.cam.direction.x;
            this.cam.position.y -= delta * this.cam.direction.y;
            this.cam.position.z -= delta * this.cam.direction.z;
        }
        this.cam.update();
    }
}

