/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.experimental;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.backends.lwjgl.LwjglApplication;
import com.badlogic.gdx.backends.lwjgl.LwjglApplicationConfiguration;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.FPSLogger;
import com.badlogic.gdx.graphics.PerspectiveCamera;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g3d.AnimatedModelNode;
import com.badlogic.gdx.graphics.g3d.experimental.PerspectiveCamController;
import com.badlogic.gdx.graphics.g3d.lights.DirectionalLight;
import com.badlogic.gdx.graphics.g3d.lights.LightManager;
import com.badlogic.gdx.graphics.g3d.lights.PointLight;
import com.badlogic.gdx.graphics.g3d.loaders.ModelLoaderRegistry;
import com.badlogic.gdx.graphics.g3d.loaders.g3d.G3dLoader;
import com.badlogic.gdx.graphics.g3d.loaders.g3d.chunks.G3dExporter;
import com.badlogic.gdx.graphics.g3d.loaders.ogre.OgreXmlLoader;
import com.badlogic.gdx.graphics.g3d.materials.BlendingAttribute;
import com.badlogic.gdx.graphics.g3d.materials.ColorAttribute;
import com.badlogic.gdx.graphics.g3d.materials.GpuSkinningAttribute;
import com.badlogic.gdx.graphics.g3d.materials.Material;
import com.badlogic.gdx.graphics.g3d.materials.TextureAttribute;
import com.badlogic.gdx.graphics.g3d.model.skeleton.SkeletonAnimation;
import com.badlogic.gdx.graphics.g3d.model.skeleton.SkeletonModel;
import com.badlogic.gdx.graphics.g3d.model.skeleton.SkeletonModelGpuSkinned;
import com.badlogic.gdx.graphics.g3d.test.PrototypeRendererGL20;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Matrix3;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.math.collision.BoundingBox;

public class SkeletonModelGpuSkinningTest
implements ApplicationListener {
    static final int LIGHTS_NUM = 4;
    static final float LIGHT_INTESITY = 3.0f;
    static final boolean useGpuSkinning = true;
    LightManager lightManager;
    PerspectiveCamController camController;
    PerspectiveCamera cam;
    private Texture texture;
    FPSLogger logger = new FPSLogger();
    private final Matrix4 modelMatrix = new Matrix4();
    private final Matrix3 normalMatrix = new Matrix3();
    float timer;
    private PrototypeRendererGL20 protoRenderer;
    private SkeletonModel model;
    private int currAnimIdx;
    static final int gridSize = 4;
    private final AnimatedModelNode[][] animInstance = new AnimatedModelNode[4][4];

    public static void main(String[] argv) {
        LwjglApplicationConfiguration config = new LwjglApplicationConfiguration();
        config.title = "Hybrid Light";
        config.width = 800;
        config.height = 480;
        config.samples = 8;
        config.vSyncEnabled = true;
        config.useGL20 = true;
        new LwjglApplication(new SkeletonModelGpuSkinningTest(), config);
    }

    @Override
    public void create() {
        this.lightManager = new LightManager(4, LightManager.LightQuality.FRAGMENT);
        int i = 0;
        while (i < 4) {
            PointLight l = new PointLight();
            l.position.set(MathUtils.random(6) - 3, 1 + MathUtils.random(6), MathUtils.random(6) - 3);
            l.color.r = MathUtils.random();
            l.color.b = MathUtils.random();
            l.color.g = MathUtils.random();
            l.intensity = 3.0f;
            this.lightManager.addLigth(l);
            ++i;
        }
        this.lightManager.dirLight = new DirectionalLight();
        this.lightManager.dirLight.color.set(0.1f, 0.1f, 0.1f, 1.0f);
        this.lightManager.dirLight.direction.set(-0.4f, -1.0f, 0.03f).nor();
        this.lightManager.ambientLight.set(0.01f, 0.01f, 0.03f, 0.0f);
        this.cam = new PerspectiveCamera(45.0f, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        this.cam.near = 0.1f;
        this.cam.far = 64.0f;
        this.cam.position.set(2.0f, 2.75f, 1.0f);
        this.cam.update();
        this.camController = new PerspectiveCamController(this.cam);
        Gdx.input.setInputProcessor(this.camController);
        this.texture = new Texture(Gdx.files.internal("data/models/robot.jpg"), Pixmap.Format.RGB565, true);
        this.texture.setFilter(Texture.TextureFilter.MipMapLinearNearest, Texture.TextureFilter.Linear);
        String fileName = "data/models/cube.dae";
        if (!fileName.endsWith(".g3d") && Gdx.app.getType() == Application.ApplicationType.Desktop) {
            this.model = ModelLoaderRegistry.loadSkeletonModel(Gdx.files.internal(fileName));
            if (this.model == null) {
                this.model = new OgreXmlLoader().load(Gdx.files.internal(fileName), Gdx.files.internal(fileName.replace("mesh.xml", "skeleton.xml")));
            }
            G3dExporter.export(this.model, Gdx.files.absolute(String.valueOf(fileName) + ".g3d"));
            this.model = G3dLoader.loadSkeletonModel(Gdx.files.absolute(String.valueOf(fileName) + ".g3d"));
        } else {
            this.model = ModelLoaderRegistry.loadSkeletonModel(Gdx.files.internal(fileName));
        }
        this.model = SkeletonModelGpuSkinned.CreateFromSkeletonModel(this.model);
        this.protoRenderer = new PrototypeRendererGL20(this.lightManager);
        this.protoRenderer.cam = this.cam;
        ColorAttribute c1 = new ColorAttribute(new Color(0.75f, 0.75f, 0.75f, 0.3f), "diffuseColor");
        ColorAttribute c2 = new ColorAttribute(new Color(0.35f, 0.35f, 0.35f, 0.35f), "specularColor");
        ColorAttribute c3 = new ColorAttribute(new Color(0.2f, 1.0f, 0.15f, 1.0f), "rimColor");
        ColorAttribute c4 = new ColorAttribute(new Color(0.0f, 0.0f, 0.0f, 0.35f), "fogColor");
        BlendingAttribute b = new BlendingAttribute("translucent");
        BoundingBox box = new BoundingBox();
        int i2 = 0;
        while (i2 < 4) {
            int j = 0;
            while (j < 4) {
                AnimatedModelNode instance = new AnimatedModelNode();
                SkeletonAnimation[] animations = this.model.getAnimations();
                SkeletonAnimation sa = animations[(i2 + j * 4) % animations.length];
                instance.animation = sa.name;
                instance.time = MathUtils.random(sa.totalDuration);
                instance.looping = true;
                this.model.getBoundingBox(box);
                instance.matrix.trn(-1.75f, 0.0f, -5.5f);
                instance.matrix.scale(0.4f, 0.4f, 0.4f);
                box.mul(instance.matrix);
                instance.radius = box.getDimensions().len() / 2.0f;
                this.animInstance[i2][j] = instance;
                ++j;
            }
            ++i2;
        }
        TextureAttribute t1 = new TextureAttribute(this.texture, 0, "diffuseTexture");
        GpuSkinningAttribute gpuAttribute = new GpuSkinningAttribute(this.model.skeleton);
        Material material = new Material("s", t1, gpuAttribute);
        this.model.setMaterial(material);
    }

    @Override
    public void dispose() {
        this.model.dispose();
        this.texture.dispose();
    }

    @Override
    public void pause() {
    }

    @Override
    public void render() {
        this.logger.log();
        float delta = Gdx.graphics.getDeltaTime();
        this.camController.update(delta);
        this.timer += delta;
        int i = 0;
        while (i < 1 && i < this.lightManager.pointLights.size) {
            Vector3 v = this.lightManager.pointLights.get((int)i).position;
            v.set(this.animInstance[0][0].getSortCenter());
            v.x += MathUtils.sin(this.timer);
            v.z += MathUtils.cos(this.timer);
            ++i;
        }
        Gdx.gl.glEnable(2884);
        Gdx.gl.glFrontFace(2304);
        Gdx.gl.glCullFace(1028);
        Gdx.gl.glEnable(2929);
        Gdx.gl.glDepthMask(true);
        Gdx.gl.glClear(0x4100 | (Gdx.graphics.getBufferFormat().coverageSampling ? 32768 : 0));
        this.protoRenderer.begin();
        i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 4) {
                AnimatedModelNode instance = this.animInstance[i][j];
                instance.time += MathUtils.clamp(delta, 0.0f, 0.1f) * 0.5f;
                if (instance.time > this.model.getAnimations()[this.currAnimIdx].totalDuration) {
                    instance.time = 0.0f;
                }
                instance.matrix.val[12] = -i * 2 + 8;
                instance.matrix.val[14] = -j * 2 - 4;
                this.protoRenderer.draw(this.model, instance);
                ++j;
            }
            ++i;
        }
        this.protoRenderer.end();
    }

    @Override
    public void resize(int width, int height) {
    }

    @Override
    public void resume() {
    }
}

