/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.loaders.g3d.chunks;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.g3d.loaders.g3d.chunks.ChunkWriter;
import com.badlogic.gdx.graphics.g3d.model.keyframe.Keyframe;
import com.badlogic.gdx.graphics.g3d.model.keyframe.KeyframedAnimation;
import com.badlogic.gdx.graphics.g3d.model.keyframe.KeyframedModel;
import com.badlogic.gdx.graphics.g3d.model.keyframe.KeyframedSubMesh;
import com.badlogic.gdx.graphics.g3d.model.skeleton.SkeletonAnimation;
import com.badlogic.gdx.graphics.g3d.model.skeleton.SkeletonJoint;
import com.badlogic.gdx.graphics.g3d.model.skeleton.SkeletonKeyframe;
import com.badlogic.gdx.graphics.g3d.model.skeleton.SkeletonModel;
import com.badlogic.gdx.graphics.g3d.model.skeleton.SkeletonSubMesh;
import com.badlogic.gdx.graphics.g3d.model.still.StillModel;
import com.badlogic.gdx.graphics.g3d.model.still.StillSubMesh;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.io.IOException;
import java.io.OutputStream;

public class G3dExporter {
    public static void export(StillModel model, FileHandle file) {
        ChunkWriter writer = new ChunkWriter();
        writer.newChunk(1);
        writer.writeByte(0);
        writer.writeByte(1);
        writer.endChunk();
        writer.newChunk(4096);
        writer.writeInt(model.subMeshes.length);
        StillSubMesh[] stillSubMeshArray = model.subMeshes;
        int n = model.subMeshes.length;
        int n2 = 0;
        while (n2 < n) {
            StillSubMesh mesh = stillSubMeshArray[n2];
            writer.newChunk(4352);
            writer.writeString(mesh.name == null ? "" : mesh.name);
            writer.writeInt(mesh.primitiveType);
            writer.newChunk(4384);
            writer.writeInt(mesh.mesh.getVertexAttributes().size());
            int i = 0;
            while (i < mesh.mesh.getVertexAttributes().size()) {
                VertexAttribute attribute = mesh.mesh.getVertexAttributes().get(i);
                writer.newChunk(4385);
                writer.writeInt(attribute.usage);
                writer.writeInt(attribute.numComponents);
                writer.writeString(attribute.alias);
                writer.endChunk();
                ++i;
            }
            writer.endChunk();
            writer.newChunk(4368);
            int numFloats = mesh.mesh.getNumVertices() * mesh.mesh.getVertexSize() / 4;
            float[] vertices = new float[numFloats];
            mesh.mesh.getVertices(vertices);
            writer.writeInt(mesh.mesh.getNumVertices());
            writer.writeFloats(vertices);
            writer.endChunk();
            writer.newChunk(4369);
            int numShorts = mesh.mesh.getNumIndices();
            short[] indices = new short[numShorts];
            mesh.mesh.getIndices(indices);
            writer.writeInt(numShorts);
            writer.writeShorts(indices);
            writer.endChunk();
            writer.endChunk();
            ++n2;
        }
        writer.endChunk();
        OutputStream out = null;
        try {
            try {
                out = file.write(false);
                writer.writeToStream(out);
            }
            catch (IOException e) {
                throw new GdxRuntimeException("An error occured while exporting the still model, " + e.getMessage(), e);
            }
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void export(KeyframedModel model, FileHandle file) {
        ChunkWriter writer = new ChunkWriter();
        writer.newChunk(1);
        writer.writeByte(0);
        writer.writeByte(1);
        writer.endChunk();
        writer.newChunk(8192);
        writer.writeInt(model.subMeshes.length);
        KeyframedSubMesh[] keyframedSubMeshArray = model.subMeshes;
        int n = model.subMeshes.length;
        int n2 = 0;
        while (n2 < n) {
            KeyframedSubMesh mesh = keyframedSubMeshArray[n2];
            writer.newChunk(8704);
            writer.writeString(mesh.name == null ? "" : mesh.name);
            writer.writeInt(mesh.primitiveType);
            writer.writeInt(mesh.animatedComponents);
            writer.writeInt(mesh.animations.size);
            writer.newChunk(4384);
            writer.writeInt(mesh.mesh.getVertexAttributes().size());
            int i = 0;
            while (i < mesh.mesh.getVertexAttributes().size()) {
                VertexAttribute attribute = mesh.mesh.getVertexAttributes().get(i);
                writer.newChunk(4385);
                writer.writeInt(attribute.usage);
                writer.writeInt(attribute.numComponents);
                writer.writeString(attribute.alias);
                writer.endChunk();
                ++i;
            }
            writer.endChunk();
            writer.newChunk(4368);
            int numFloats = mesh.mesh.getNumVertices() * mesh.mesh.getVertexSize() / 4;
            float[] vertices = new float[numFloats];
            mesh.mesh.getVertices(vertices);
            writer.writeInt(mesh.mesh.getNumVertices());
            writer.writeFloats(vertices);
            writer.endChunk();
            writer.newChunk(4369);
            int numShorts = mesh.mesh.getNumIndices();
            short[] indices = new short[numShorts];
            mesh.mesh.getIndices(indices);
            writer.writeInt(mesh.mesh.getNumIndices());
            writer.writeShorts(indices);
            writer.endChunk();
            for (String animationName : mesh.animations.keys()) {
                KeyframedAnimation animation = mesh.animations.get(animationName);
                writer.newChunk(8960);
                writer.writeString(animation.name);
                writer.writeFloat(animation.frameDuration);
                writer.writeInt(animation.keyframes.length);
                Keyframe[] keyframeArray = animation.keyframes;
                int n3 = animation.keyframes.length;
                int n4 = 0;
                while (n4 < n3) {
                    Keyframe keyframe = keyframeArray[n4];
                    writer.newChunk(9216);
                    writer.writeFloat(keyframe.timeStamp);
                    writer.writeFloats(keyframe.vertices);
                    writer.endChunk();
                    ++n4;
                }
                writer.endChunk();
            }
            writer.endChunk();
            ++n2;
        }
        writer.endChunk();
        OutputStream out = null;
        try {
            try {
                out = file.write(false);
                writer.writeToStream(out);
            }
            catch (IOException e) {
                throw new GdxRuntimeException("An error occured while exporting the still model, " + e.getMessage(), e);
            }
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void export(SkeletonModel model, FileHandle file) {
        int n;
        ChunkWriter writer = new ChunkWriter();
        writer.newChunk(1);
        writer.writeByte(0);
        writer.writeByte(1);
        writer.endChunk();
        writer.newChunk(16384);
        writer.writeInt(model.subMeshes.length);
        SkeletonSubMesh[] skeletonSubMeshArray = model.subMeshes;
        int n2 = model.subMeshes.length;
        int n3 = 0;
        while (n3 < n2) {
            float[] array;
            SkeletonSubMesh mesh = skeletonSubMeshArray[n3];
            writer.newChunk(16896);
            writer.writeString(mesh.name == null ? "" : mesh.name);
            writer.writeInt(mesh.primitiveType);
            writer.newChunk(4384);
            writer.writeInt(mesh.mesh.getVertexAttributes().size());
            int i = 0;
            while (i < mesh.mesh.getVertexAttributes().size()) {
                VertexAttribute attribute = mesh.mesh.getVertexAttributes().get(i);
                writer.newChunk(4385);
                writer.writeInt(attribute.usage);
                writer.writeInt(attribute.numComponents);
                writer.writeString(attribute.alias);
                writer.endChunk();
                ++i;
            }
            writer.endChunk();
            writer.newChunk(4368);
            int numFloats = mesh.mesh.getNumVertices() * mesh.mesh.getVertexSize() / 4;
            writer.writeInt(mesh.mesh.getNumVertices());
            writer.writeFloats(mesh.vertices);
            writer.endChunk();
            writer.newChunk(4369);
            int numShorts = mesh.mesh.getNumIndices();
            writer.writeInt(numShorts);
            writer.writeShorts(mesh.indices);
            writer.endChunk();
            writer.newChunk(4400);
            writer.writeInt(mesh.boneWeights.length);
            Object object = mesh.boneWeights;
            n = mesh.boneWeights.length;
            int n4 = 0;
            while (n4 < n) {
                array = object[n4];
                writer.newChunk(4401);
                writer.writeInt(array.length);
                writer.writeFloats(array);
                writer.endChunk();
                ++n4;
            }
            writer.endChunk();
            writer.newChunk(4416);
            writer.writeInt(mesh.boneAssignments.length);
            object = mesh.boneAssignments;
            n = mesh.boneAssignments.length;
            n4 = 0;
            while (n4 < n) {
                array = object[n4];
                writer.newChunk(4417);
                writer.writeInt(array.length);
                writer.writeInts((int[])array);
                writer.endChunk();
                ++n4;
            }
            writer.endChunk();
            writer.endChunk();
            ++n3;
        }
        writer.newChunk(17664);
        writer.newChunk(17920);
        writer.writeInt(model.skeleton.hierarchy.size);
        for (SkeletonJoint joint : model.skeleton.hierarchy) {
            G3dExporter.writeSkeletonJoint(writer, joint);
        }
        writer.endChunk();
        writer.newChunk(17152);
        writer.writeInt(model.skeleton.animations.size);
        for (String animationName : model.skeleton.animations.keys()) {
            writer.newChunk(17408);
            writer.writeString(animationName);
            SkeletonAnimation animation = model.skeleton.animations.get(animationName);
            writer.writeFloat(animation.totalDuration);
            writer.writeInt(animation.perJointkeyFrames.length);
            SkeletonKeyframe[][] skeletonKeyframeArray = animation.perJointkeyFrames;
            int n5 = animation.perJointkeyFrames.length;
            int n6 = 0;
            while (n6 < n5) {
                SkeletonKeyframe[] array = skeletonKeyframeArray[n6];
                writer.writeInt(array.length);
                SkeletonKeyframe[] skeletonKeyframeArray2 = array;
                int n7 = array.length;
                n = 0;
                while (n < n7) {
                    SkeletonKeyframe frame = skeletonKeyframeArray2[n];
                    writer.writeFloat(frame.timeStamp);
                    writer.writeInt(frame.parentIndex);
                    writer.writeFloat(frame.position.x);
                    writer.writeFloat(frame.position.y);
                    writer.writeFloat(frame.position.z);
                    writer.writeFloat(frame.rotation.w);
                    writer.writeFloat(frame.rotation.x);
                    writer.writeFloat(frame.rotation.y);
                    writer.writeFloat(frame.rotation.z);
                    writer.writeFloat(frame.scale.x);
                    writer.writeFloat(frame.scale.y);
                    writer.writeFloat(frame.scale.z);
                    ++n;
                }
                ++n6;
            }
            writer.endChunk();
        }
        writer.endChunk();
        writer.endChunk();
        writer.endChunk();
        OutputStream out = null;
        try {
            try {
                out = file.write(false);
                writer.writeToStream(out);
            }
            catch (IOException e) {
                throw new GdxRuntimeException("An error occured while exporting the still model, " + e.getMessage(), e);
            }
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static void writeSkeletonJoint(ChunkWriter writer, SkeletonJoint joint) {
        writer.writeString(joint.name);
        writer.writeFloat(joint.position.x);
        writer.writeFloat(joint.position.y);
        writer.writeFloat(joint.position.z);
        writer.writeFloat(joint.rotation.w);
        writer.writeFloat(joint.rotation.x);
        writer.writeFloat(joint.rotation.y);
        writer.writeFloat(joint.rotation.z);
        writer.writeFloat(joint.scale.x);
        writer.writeFloat(joint.scale.y);
        writer.writeFloat(joint.scale.z);
        writer.writeInt(joint.children.size);
        for (SkeletonJoint child : joint.children) {
            G3dExporter.writeSkeletonJoint(writer, child);
        }
    }
}

