/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.loaders.md2;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.g3d.ModelLoaderHints;
import com.badlogic.gdx.graphics.g3d.loaders.KeyframedModelLoader;
import com.badlogic.gdx.graphics.g3d.loaders.md2.MD2Frame;
import com.badlogic.gdx.graphics.g3d.loaders.md2.MD2Header;
import com.badlogic.gdx.graphics.g3d.loaders.md2.MD2Normals;
import com.badlogic.gdx.graphics.g3d.loaders.md2.MD2Triangle;
import com.badlogic.gdx.graphics.g3d.model.keyframe.Keyframe;
import com.badlogic.gdx.graphics.g3d.model.keyframe.KeyframedAnimation;
import com.badlogic.gdx.graphics.g3d.model.keyframe.KeyframedModel;
import com.badlogic.gdx.graphics.g3d.model.keyframe.KeyframedSubMesh;
import com.badlogic.gdx.utils.LittleEndianInputStream;
import com.badlogic.gdx.utils.ObjectMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class MD2Loader
implements KeyframedModelLoader {
    private final byte[] charBuffer = new byte[16];

    @Override
    public KeyframedModel load(FileHandle file, ModelLoaderHints hints) {
        float frameDuration = 0.2f;
        if (hints instanceof MD2LoaderHints) {
            frameDuration = ((MD2LoaderHints)hints).frameDuration;
        }
        return this.load(file, frameDuration);
    }

    public KeyframedModel load(FileHandle fileHandle, float frameDuration) {
        InputStream in = fileHandle.read();
        try {
            KeyframedModel keyframedModel = this.load(in, frameDuration);
            return keyframedModel;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public KeyframedModel load(InputStream in, float frameDuration) {
        try {
            byte[] bytes = this.loadBytes(in);
            MD2Header header = this.loadHeader(bytes);
            float[] texCoords = this.loadTexCoords(header, bytes);
            MD2Triangle[] triangles = this.loadTriangles(header, bytes);
            MD2Frame[] frames = this.loadFrames(header, bytes);
            return this.buildModel(header, triangles, texCoords, frames, frameDuration);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private KeyframedModel buildModel(MD2Header header, MD2Triangle[] triangles, float[] texCoords, MD2Frame[] frames, float frameDuration) {
        VertexIndices vIdx;
        ArrayList<VertexIndices> vertCombos = new ArrayList<VertexIndices>();
        short[] indices = new short[triangles.length * 3];
        int idx = 0;
        short vertIdx = 0;
        int i = 0;
        while (i < triangles.length) {
            MD2Triangle triangle = triangles[i];
            int j = 0;
            while (j < 3) {
                VertexIndices vert = null;
                boolean contains = false;
                int k = 0;
                while (k < vertCombos.size()) {
                    vIdx = (VertexIndices)vertCombos.get(k);
                    if (vIdx.vIdx == triangle.vertices[j] && vIdx.tIdx == triangle.texCoords[j]) {
                        vert = vIdx;
                        contains = true;
                        break;
                    }
                    ++k;
                }
                if (!contains) {
                    vert = new VertexIndices(triangle.vertices[j], triangle.texCoords[j], vertIdx);
                    vertCombos.add(vert);
                    vertIdx = (short)(vertIdx + 1);
                }
                indices[idx++] = vert.nIdx;
                ++j;
            }
            ++i;
        }
        idx = 0;
        float[] uvs = new float[vertCombos.size() * 2];
        int i2 = 0;
        while (i2 < vertCombos.size()) {
            VertexIndices vtI = (VertexIndices)vertCombos.get(i2);
            uvs[idx++] = texCoords[vtI.tIdx * 2];
            uvs[idx++] = texCoords[vtI.tIdx * 2 + 1];
            ++i2;
        }
        i2 = 0;
        while (i2 < frames.length) {
            MD2Frame frame = frames[i2];
            idx = 0;
            float[] newVerts = new float[vertCombos.size() * 6];
            int j = 0;
            while (j < vertCombos.size()) {
                VertexIndices vIdx2 = (VertexIndices)vertCombos.get(j);
                newVerts[idx++] = frame.vertices[vIdx2.vIdx * 3];
                newVerts[idx++] = frame.vertices[vIdx2.vIdx * 3 + 1];
                newVerts[idx++] = frame.vertices[vIdx2.vIdx * 3 + 2];
                newVerts[idx++] = MD2Normals.normals[frame.normalIndices[vIdx2.vIdx]][1];
                newVerts[idx++] = MD2Normals.normals[frame.normalIndices[vIdx2.vIdx]][2];
                newVerts[idx++] = MD2Normals.normals[frame.normalIndices[vIdx2.vIdx]][0];
                ++j;
            }
            frame.vertices = newVerts;
            ++i2;
        }
        header.numVertices = vertCombos.size();
        float[] blendedVertices = new float[header.numVertices * 8];
        MD2Frame frame = frames[0];
        idx = 0;
        int idxV = 0;
        int idxT = 0;
        int i3 = 0;
        while (i3 < header.numVertices) {
            vIdx = (VertexIndices)vertCombos.get(i3);
            blendedVertices[idx++] = frame.vertices[idxV++];
            blendedVertices[idx++] = frame.vertices[idxV++];
            blendedVertices[idx++] = frame.vertices[idxV++];
            blendedVertices[idx++] = frame.vertices[idxV++];
            blendedVertices[idx++] = frame.vertices[idxV++];
            blendedVertices[idx++] = frame.vertices[idxV++];
            blendedVertices[idx++] = uvs[idxT++];
            blendedVertices[idx++] = uvs[idxT++];
            ++i3;
        }
        ObjectMap<String, KeyframedAnimation> animations = new ObjectMap<String, KeyframedAnimation>();
        String lastName = frames[0].name;
        int beginFrame = 0;
        int frameNum = 1;
        while (frameNum < frames.length) {
            if (!frames[frameNum].name.equals(lastName) || frameNum == frames.length - 1) {
                int subAnimLen = frameNum - beginFrame;
                KeyframedAnimation subAnim = new KeyframedAnimation(lastName, frameDuration, new Keyframe[subAnimLen]);
                int subFrame = beginFrame;
                while (subFrame < frameNum) {
                    Keyframe keyFrame;
                    int absFrameNum = subFrame - beginFrame;
                    frame = frames[subFrame];
                    float[] vertices = new float[header.numVertices * 6];
                    idx = 0;
                    idxV = 0;
                    int i4 = 0;
                    while (i4 < header.numVertices) {
                        vertices[idx++] = frame.vertices[idxV++];
                        vertices[idx++] = frame.vertices[idxV++];
                        vertices[idx++] = frame.vertices[idxV++];
                        vertices[idx++] = frame.vertices[idxV++];
                        vertices[idx++] = frame.vertices[idxV++];
                        vertices[idx++] = frame.vertices[idxV++];
                        ++i4;
                    }
                    subAnim.keyframes[absFrameNum] = keyFrame = new Keyframe((float)absFrameNum * frameDuration, vertices);
                    animations.put(subAnim.name, subAnim);
                    ++subFrame;
                }
                lastName = frames[frameNum].name;
                beginFrame = frameNum;
            }
            ++frameNum;
        }
        KeyframedAnimation animation = new KeyframedAnimation("all", frameDuration, new Keyframe[frames.length]);
        float timeStamp = 0.0f;
        int frameNum2 = 0;
        while (frameNum2 < frames.length) {
            Keyframe keyFrame;
            frame = frames[frameNum2];
            float[] vertices = new float[header.numVertices * 6];
            idx = 0;
            idxV = 0;
            int i5 = 0;
            while (i5 < header.numVertices) {
                vertices[idx++] = frame.vertices[idxV++];
                vertices[idx++] = frame.vertices[idxV++];
                vertices[idx++] = frame.vertices[idxV++];
                vertices[idx++] = frame.vertices[idxV++];
                vertices[idx++] = frame.vertices[idxV++];
                vertices[idx++] = frame.vertices[idxV++];
                ++i5;
            }
            animation.keyframes[frameNum2] = keyFrame = new Keyframe((float)frameNum2 * frameDuration, vertices);
            ++frameNum2;
        }
        Mesh mesh = new Mesh(Mesh.VertexDataType.VertexArray, false, header.numVertices, indices.length, new VertexAttribute(0, 3, "a_position"), new VertexAttribute(2, 3, "a_normal"), new VertexAttribute(3, 2, "a_texCoord0"));
        mesh.setIndices(indices);
        animations.put("all", animation);
        KeyframedSubMesh subMesh = new KeyframedSubMesh("md2-mesh", mesh, blendedVertices, animations, 6, 4);
        KeyframedModel model = new KeyframedModel(new KeyframedSubMesh[]{subMesh});
        model.setAnimation("all", 0.0f, false);
        return model;
    }

    private float[] buildTexCoords(MD2Header header, MD2Triangle[] triangles, float[] texCoords) {
        float[] uvs = new float[header.numVertices * 2];
        int i = 0;
        while (i < triangles.length) {
            MD2Triangle triangle = triangles[i];
            int j = 0;
            while (j < 3) {
                short vertIdx = triangle.vertices[j];
                int uvIdx = vertIdx * 2;
                uvs[uvIdx] = texCoords[triangle.texCoords[j] * 2];
                uvs[uvIdx + 1] = texCoords[triangle.texCoords[j] * 2 + 1];
                ++j;
            }
            ++i;
        }
        return uvs;
    }

    private short[] buildIndices(MD2Triangle[] triangles) {
        short[] indices = new short[triangles.length * 3];
        int idx = 0;
        int i = 0;
        while (i < triangles.length) {
            MD2Triangle triangle = triangles[i];
            indices[idx++] = triangle.vertices[0];
            indices[idx++] = triangle.vertices[1];
            indices[idx++] = triangle.vertices[2];
            ++i;
        }
        return indices;
    }

    private MD2Frame[] loadFrames(MD2Header header, byte[] bytes) throws IOException {
        LittleEndianInputStream in = new LittleEndianInputStream(new ByteArrayInputStream(bytes));
        in.skip(header.offsetFrames);
        MD2Frame[] frames = new MD2Frame[header.numFrames];
        int i = 0;
        while (i < header.numFrames) {
            frames[i] = this.loadFrame(header, in);
            ++i;
        }
        in.close();
        return frames;
    }

    private MD2Frame loadFrame(MD2Header header, LittleEndianInputStream in) throws IOException {
        MD2Frame frame = new MD2Frame();
        frame.vertices = new float[header.numVertices * 3];
        frame.normalIndices = new int[header.numVertices];
        float scaleX = in.readFloat();
        float scaleY = in.readFloat();
        float scaleZ = in.readFloat();
        float transX = in.readFloat();
        float transY = in.readFloat();
        float transZ = in.readFloat();
        in.read(this.charBuffer);
        int len = 0;
        int i = 0;
        while (i < this.charBuffer.length) {
            if (this.charBuffer[i] == 0) {
                len = i - 1;
                break;
            }
            ++i;
        }
        frame.name = new String(this.charBuffer, 0, len);
        int vertIdx = 0;
        int i2 = 0;
        while (i2 < header.numVertices) {
            float x = (float)in.read() * scaleX + transX;
            float y = (float)in.read() * scaleY + transY;
            float z = (float)in.read() * scaleZ + transZ;
            frame.vertices[vertIdx++] = y;
            frame.vertices[vertIdx++] = z;
            frame.vertices[vertIdx++] = x;
            frame.normalIndices[i2] = in.read();
            ++i2;
        }
        return frame;
    }

    private MD2Triangle[] loadTriangles(MD2Header header, byte[] bytes) throws IOException {
        LittleEndianInputStream in = new LittleEndianInputStream(new ByteArrayInputStream(bytes));
        in.skip(header.offsetTriangles);
        MD2Triangle[] triangles = new MD2Triangle[header.numTriangles];
        int i = 0;
        while (i < header.numTriangles) {
            MD2Triangle triangle = new MD2Triangle();
            triangle.vertices[0] = in.readShort();
            triangle.vertices[1] = in.readShort();
            triangle.vertices[2] = in.readShort();
            triangle.texCoords[0] = in.readShort();
            triangle.texCoords[1] = in.readShort();
            triangle.texCoords[2] = in.readShort();
            triangles[i] = triangle;
            ++i;
        }
        in.close();
        return triangles;
    }

    private float[] loadTexCoords(MD2Header header, byte[] bytes) throws IOException {
        LittleEndianInputStream in = new LittleEndianInputStream(new ByteArrayInputStream(bytes));
        in.skip(header.offsetTexCoords);
        float[] texCoords = new float[header.numTexCoords * 2];
        float width = header.skinWidth;
        float height = header.skinHeight;
        int i = 0;
        while (i < header.numTexCoords * 2) {
            short u = in.readShort();
            short v = in.readShort();
            texCoords[i] = (float)u / width;
            texCoords[i + 1] = (float)v / height;
            i += 2;
        }
        in.close();
        return texCoords;
    }

    private MD2Header loadHeader(byte[] bytes) throws IOException {
        LittleEndianInputStream in = new LittleEndianInputStream(new ByteArrayInputStream(bytes));
        MD2Header header = new MD2Header();
        header.ident = in.readInt();
        header.version = in.readInt();
        header.skinWidth = in.readInt();
        header.skinHeight = in.readInt();
        header.frameSize = in.readInt();
        header.numSkins = in.readInt();
        header.numVertices = in.readInt();
        header.numTexCoords = in.readInt();
        header.numTriangles = in.readInt();
        header.numGLCommands = in.readInt();
        header.numFrames = in.readInt();
        header.offsetSkin = in.readInt();
        header.offsetTexCoords = in.readInt();
        header.offsetTriangles = in.readInt();
        header.offsetFrames = in.readInt();
        header.offsetGLCommands = in.readInt();
        header.offsetEnd = in.readInt();
        in.close();
        return header;
    }

    private byte[] loadBytes(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int readBytes = 0;
        while ((readBytes = in.read(buffer)) > 0) {
            out.write(buffer, 0, readBytes);
        }
        out.close();
        return out.toByteArray();
    }

    public static class MD2LoaderHints
    extends ModelLoaderHints {
        public final float frameDuration;

        public MD2LoaderHints(float frameDuration) {
            super(false);
            this.frameDuration = frameDuration;
        }
    }

    public class VertexIndices {
        public short vIdx;
        public short tIdx;
        public short nIdx;

        public VertexIndices(short vIdx, short tIdx, short nIdx) {
            this.vIdx = vIdx;
            this.tIdx = tIdx;
            this.nIdx = nIdx;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.tIdx;
            result = 31 * result + this.vIdx;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            VertexIndices other = (VertexIndices)obj;
            if (this.tIdx != other.tIdx) {
                return false;
            }
            return this.vIdx == other.vIdx;
        }
    }
}

