/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.model.still;

import com.badlogic.gdx.graphics.g3d.materials.Material;
import com.badlogic.gdx.graphics.g3d.model.Model;
import com.badlogic.gdx.graphics.g3d.model.SubMesh;
import com.badlogic.gdx.graphics.g3d.model.still.StillSubMesh;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.collision.BoundingBox;
import java.util.ArrayList;

public class StillModel
implements Model {
    public final StillSubMesh[] subMeshes;
    private static final BoundingBox tmpBox = new BoundingBox();

    public StillModel(SubMesh[] subMeshes) {
        this.subMeshes = new StillSubMesh[subMeshes.length];
        int i = 0;
        while (i < subMeshes.length) {
            this.subMeshes[i] = (StillSubMesh)subMeshes[i];
            ++i;
        }
    }

    @Override
    public void render() {
        int len = this.subMeshes.length;
        int i = 0;
        while (i < len) {
            StillSubMesh subMesh = this.subMeshes[i];
            if (i == 0) {
                subMesh.material.bind();
            } else if (!this.subMeshes[i - 1].material.equals(subMesh.material)) {
                subMesh.material.bind();
            }
            subMesh.mesh.render(subMesh.primitiveType);
            ++i;
        }
    }

    @Override
    public void render(ShaderProgram program) {
        int len = this.subMeshes.length;
        int i = 0;
        while (i < len) {
            StillSubMesh subMesh = this.subMeshes[i];
            if (i == 0) {
                subMesh.material.bind(program);
            } else if (!this.subMeshes[i - 1].material.equals(subMesh.material)) {
                subMesh.material.bind(program);
            }
            subMesh.mesh.render(program, subMesh.primitiveType);
            ++i;
        }
    }

    @Override
    public Model getSubModel(String ... subMeshNames) {
        ArrayList<StillSubMesh> subMeshes = new ArrayList<StillSubMesh>();
        String[] stringArray = subMeshNames;
        int n = subMeshNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            StillSubMesh[] stillSubMeshArray = this.subMeshes;
            int n3 = this.subMeshes.length;
            int n4 = 0;
            while (n4 < n3) {
                StillSubMesh subMesh = stillSubMeshArray[n4];
                if (name.equals(subMesh.name)) {
                    subMeshes.add(subMesh);
                }
                ++n4;
            }
            ++n2;
        }
        if (subMeshes.size() > 0) {
            return new StillModel(subMeshes.toArray(new StillSubMesh[subMeshes.size()]));
        }
        return null;
    }

    @Override
    public StillSubMesh getSubMesh(String name) {
        StillSubMesh[] stillSubMeshArray = this.subMeshes;
        int n = this.subMeshes.length;
        int n2 = 0;
        while (n2 < n) {
            StillSubMesh subMesh = stillSubMeshArray[n2];
            if (subMesh.name.equals(name)) {
                return subMesh;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public SubMesh[] getSubMeshes() {
        return this.subMeshes;
    }

    @Override
    public void setMaterials(Material ... materials) {
        if (materials.length != this.subMeshes.length) {
            throw new UnsupportedOperationException("number of materials must equal number of sub-meshes");
        }
        int len = materials.length;
        int i = 0;
        while (i < len) {
            this.subMeshes[i].material = materials[i];
            ++i;
        }
    }

    @Override
    public void setMaterial(Material material) {
        int len = this.subMeshes.length;
        int i = 0;
        while (i < len) {
            this.subMeshes[i].material = material;
            ++i;
        }
    }

    @Override
    public void getBoundingBox(BoundingBox bbox) {
        bbox.inf();
        int i = 0;
        while (i < this.subMeshes.length) {
            this.subMeshes[i].mesh.calculateBoundingBox(tmpBox);
            bbox.ext(tmpBox);
            ++i;
        }
    }

    @Override
    public void dispose() {
        int i = 0;
        while (i < this.subMeshes.length) {
            this.subMeshes[i].mesh.dispose();
            ++i;
        }
    }
}

