/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.test;

import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.backends.lwjgl.LwjglApplication;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.FPSLogger;
import com.badlogic.gdx.graphics.PerspectiveCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g3d.StillModelNode;
import com.badlogic.gdx.graphics.g3d.lights.DirectionalLight;
import com.badlogic.gdx.graphics.g3d.lights.LightManager;
import com.badlogic.gdx.graphics.g3d.lights.PointLight;
import com.badlogic.gdx.graphics.g3d.loaders.ModelLoaderRegistry;
import com.badlogic.gdx.graphics.g3d.materials.ColorAttribute;
import com.badlogic.gdx.graphics.g3d.materials.Material;
import com.badlogic.gdx.graphics.g3d.materials.TextureAttribute;
import com.badlogic.gdx.graphics.g3d.model.still.StillModel;
import com.badlogic.gdx.graphics.g3d.test.PrototypeRendererGL20;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.collision.BoundingBox;

public class StillModelViewerGL20
implements ApplicationListener {
    PerspectiveCamera cam;
    StillModel model;
    Texture[] textures = null;
    boolean hasNormals = false;
    BoundingBox bounds = new BoundingBox();
    String fileName;
    String[] textureFileNames;
    FPSLogger fps = new FPSLogger();
    SpriteBatch batch;
    BitmapFont font;
    private LightManager lightManager;
    private PrototypeRendererGL20 protoRenderer;
    private StillModelNode instance;
    private StillModelNode instance2;
    private ShaderProgram shader2;
    private ShaderProgram shader1;

    public StillModelViewerGL20(String fileName, String ... textureFileNames) {
        this.fileName = fileName;
        this.textureFileNames = textureFileNames;
    }

    @Override
    public void create() {
        long start = System.nanoTime();
        this.model = ModelLoaderRegistry.loadStillModel(Gdx.files.internal(this.fileName));
        Gdx.app.log("StillModelViewer", "loading took: " + (float)(System.nanoTime() - start) / 1.0E9f);
        if (this.textureFileNames.length != 0) {
            this.textures = new Texture[this.textureFileNames.length];
            int i = 0;
            while (i < this.textureFileNames.length) {
                this.textures[i] = new Texture(Gdx.files.internal(this.textureFileNames[i]), i <= 0);
                ++i;
            }
        }
        this.model.getBoundingBox(this.bounds);
        float len = this.bounds.getDimensions().len();
        System.out.println("bounds: " + this.bounds);
        this.cam = new PerspectiveCamera(60.0f, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        this.cam.position.set(this.bounds.getCenter().cpy().add(len / 2.0f, len / 2.0f, len / 2.0f));
        this.cam.lookAt(this.bounds.getCenter().x, this.bounds.getCenter().y, this.bounds.getCenter().z);
        this.cam.near = 0.1f;
        this.cam.far = 64.0f;
        this.batch = new SpriteBatch();
        this.font = new BitmapFont();
        this.lightManager = new LightManager(4, LightManager.LightQuality.VERTEX);
        this.lightManager.dirLight = new DirectionalLight();
        this.lightManager.dirLight.color.set(0.09f, 0.07f, 0.09f, 0.0f);
        this.lightManager.dirLight.direction.set(-0.4f, -1.0f, 0.03f).nor();
        int i = 0;
        while (i < 4) {
            PointLight l = new PointLight();
            l.position.set(-MathUtils.random(8) + 4, MathUtils.random(3), -MathUtils.random(6) + 3);
            l.color.r = MathUtils.random();
            l.color.b = MathUtils.random();
            l.color.g = MathUtils.random();
            l.intensity = 3.0f;
            this.lightManager.addLigth(l);
            ++i;
        }
        this.lightManager.ambientLight.set(0.03f, 0.05f, 0.06f, 0.0f);
        this.protoRenderer = new PrototypeRendererGL20(this.lightManager);
        this.protoRenderer.cam = this.cam;
        ColorAttribute c1 = new ColorAttribute(new Color(0.5f, 0.51f, 0.51f, 1.0f), "specularColor");
        ColorAttribute c2 = new ColorAttribute(new Color(0.95f, 0.95f, 0.95f, 1.0f), "diffuseColor");
        TextureAttribute t0 = new TextureAttribute(this.textures[0], 0, "diffuseTexture");
        Material material = new Material("basic", c1, c2, t0);
        this.model.setMaterial(material);
        this.instance = new StillModelNode();
        this.instance.getTransform().translate(-len / 2.0f, -1.0f, 2.0f);
        this.instance.radius = this.bounds.getDimensions().len() / 2.0f;
        this.instance2 = new StillModelNode();
        this.instance2.getTransform().translate(len / 2.0f, -1.0f, -7.0f);
        this.instance2.radius = this.instance.radius;
    }

    @Override
    public void resume() {
    }

    @Override
    public void render() {
        Gdx.gl.glClear(16640);
        Gdx.gl.glEnable(2929);
        Gdx.gl.glEnable(2884);
        this.instance.getTransform().rotate(0.0f, 1.0f, -0.1f, 35.0f * Gdx.graphics.getDeltaTime());
        this.instance2.getTransform().rotate(0.0f, 1.0f, 0.1f, -15.0f * Gdx.graphics.getDeltaTime());
        this.cam.update();
        this.protoRenderer.begin();
        this.protoRenderer.draw(this.model, this.instance);
        this.protoRenderer.draw(this.model, this.instance2);
        this.protoRenderer.end();
        this.batch.begin();
        this.font.draw(this.batch, "fps: " + Gdx.graphics.getFramesPerSecond(), 20.0f, 30.0f);
        this.batch.end();
        this.fps.log();
    }

    @Override
    public void resize(int width, int height) {
    }

    @Override
    public void pause() {
    }

    @Override
    public void dispose() {
    }

    public static void main(String[] argv) {
        new LwjglApplication(new StillModelViewerGL20("data/models/basicscene.obj", "data/multipleuvs_1.png", "data/multipleuvs_2.png"), "StillModel Viewer gles2.0", 800, 480, true);
    }
}

