/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.BitmapFontCache;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;

public class Window
extends Table {
    private WindowStyle style;
    private String title;
    private BitmapFontCache titleCache;
    boolean isMovable = true;
    boolean isModal;
    final Vector2 dragOffset = new Vector2();
    boolean dragging;
    private int titleAlignment = 1;

    public Window(String title, Skin skin) {
        this(title, skin.get(WindowStyle.class));
        this.setSkin(skin);
    }

    public Window(String title, Skin skin, String styleName) {
        this(title, skin.get(styleName, WindowStyle.class));
        this.setSkin(skin);
    }

    public Window(String title, WindowStyle style) {
        if (title == null) {
            throw new IllegalArgumentException("title cannot be null.");
        }
        this.title = title;
        this.setTouchable(Touchable.enabled);
        this.setClip(true);
        this.setStyle(style);
        this.setWidth(150.0f);
        this.setHeight(150.0f);
        this.setTitle(title);
        this.addCaptureListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                Window.this.toFront();
                return false;
            }
        });
        this.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                if (button == 0) {
                    Window.this.dragging = Window.this.isMovable && Window.this.getHeight() - y <= Window.this.getPadTop() && y < Window.this.getHeight() && x > 0.0f && x < Window.this.getWidth();
                    Window.this.dragOffset.set(x, y);
                }
                return Window.this.dragging || Window.this.isModal;
            }

            @Override
            public void touchDragged(InputEvent event, float x, float y, int pointer) {
                if (!Window.this.dragging) {
                    return;
                }
                Window.this.translate(x - Window.this.dragOffset.x, y - Window.this.dragOffset.y);
            }

            @Override
            public boolean mouseMoved(InputEvent event, float x, float y) {
                return Window.this.isModal;
            }

            @Override
            public boolean scrolled(InputEvent event, float x, float y, int amount) {
                return Window.this.isModal;
            }

            @Override
            public boolean keyDown(InputEvent event, int keycode) {
                return Window.this.isModal;
            }

            @Override
            public boolean keyUp(InputEvent event, int keycode) {
                return Window.this.isModal;
            }

            @Override
            public boolean keyTyped(InputEvent event, char character) {
                return Window.this.isModal;
            }
        });
    }

    public void setStyle(WindowStyle style) {
        if (style == null) {
            throw new IllegalArgumentException("style cannot be null.");
        }
        this.style = style;
        this.setBackground(style.background);
        this.titleCache = new BitmapFontCache(style.titleFont);
        this.titleCache.setColor(style.titleFontColor);
        if (this.title != null) {
            this.setTitle(this.title);
        }
        this.invalidateHierarchy();
    }

    public WindowStyle getStyle() {
        return this.style;
    }

    @Override
    protected void drawBackground(SpriteBatch batch, float parentAlpha) {
        if (this.style.stageBackground != null) {
            Color color = this.getColor();
            batch.setColor(color.r, color.g, color.b, color.a * parentAlpha);
            Stage stage = this.getStage();
            Vector2 position = this.stageToLocalCoordinates(Vector2.tmp.set(0.0f, 0.0f));
            Vector2 size = this.stageToLocalCoordinates(Vector2.tmp2.set(stage.getWidth(), stage.getHeight()));
            this.style.stageBackground.draw(batch, this.getX() + position.x, this.getY() + position.y, this.getX() + size.x, this.getY() + size.y);
        }
        super.drawBackground(batch, parentAlpha);
        float x = this.getX();
        float y = this.getY() + this.getHeight();
        BitmapFont.TextBounds bounds = this.titleCache.getBounds();
        x = (this.titleAlignment & 8) != 0 ? (x += this.getPadLeft()) : ((this.titleAlignment & 0x10) != 0 ? (x += this.getWidth() - bounds.width - this.getPadRight()) : (x += (this.getWidth() - bounds.width) / 2.0f));
        if ((this.titleAlignment & 2) == 0) {
            y = (this.titleAlignment & 4) != 0 ? (y -= this.getPadTop() - bounds.height) : (y -= (this.getPadTop() - bounds.height) / 2.0f);
        }
        this.titleCache.setColor(Color.tmp.set(this.getColor()).mul(this.style.titleFontColor));
        this.titleCache.setPosition((int)x, (int)y);
        this.titleCache.draw(batch, parentAlpha);
    }

    @Override
    public Actor hit(float x, float y, boolean touchable) {
        Actor hit = super.hit(x, y, touchable);
        if (hit == null && this.isModal && (!touchable || this.getTouchable() == Touchable.enabled)) {
            return this;
        }
        return hit;
    }

    public void setTitle(String title) {
        this.title = title;
        this.titleCache.setMultiLineText(title, 0.0f, 0.0f);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitleAlignment(int titleAlignment) {
        this.titleAlignment = titleAlignment;
    }

    public void setMovable(boolean isMovable) {
        this.isMovable = isMovable;
    }

    public void setModal(boolean isModal) {
        this.isModal = isModal;
    }

    public boolean isDragging() {
        return this.dragging;
    }

    @Override
    public float getPrefWidth() {
        return Math.max(super.getPrefWidth(), this.titleCache.getBounds().width + this.getPadLeft() + this.getPadRight());
    }

    public static class WindowStyle {
        public Drawable background;
        public BitmapFont titleFont;
        public Color titleFontColor = new Color(1.0f, 1.0f, 1.0f, 1.0f);
        public Drawable stageBackground;

        public WindowStyle() {
        }

        public WindowStyle(BitmapFont titleFont, Color titleFontColor, Drawable background) {
            this.background = background;
            this.titleFont = titleFont;
            this.titleFontColor.set(titleFontColor);
        }

        public WindowStyle(WindowStyle style) {
            this.background = style.background;
            this.titleFont = style.titleFont;
            this.titleFontColor = new Color(style.titleFontColor);
        }
    }
}

