/*
 * Decompiled with CFR 0.152.
 */
package darwin.jopenctm.compression;

import darwin.jopenctm.compression.RawDecoder;
import darwin.jopenctm.data.Mesh;
import darwin.jopenctm.errorhandling.BadFormatException;
import darwin.jopenctm.errorhandling.InvalidDataException;
import darwin.jopenctm.io.CtmFileReader;
import darwin.jopenctm.io.CtmInputStream;
import darwin.jopenctm.io.MeshInfo;
import java.io.IOException;

public class MG1Decoder
extends RawDecoder {
    public static final int MG1_TAG = CtmFileReader.getTagInt("MG1\u0000");

    @Override
    public Mesh decode(MeshInfo minfo, CtmInputStream in) throws IOException, BadFormatException, InvalidDataException {
        Mesh m = super.decode(minfo, in);
        this.restoreIndices(minfo.getTriangleCount(), m.indices);
        return m;
    }

    @Override
    public boolean isFormatSupported(int tag, int version) {
        return tag == MG1_TAG && version == 5;
    }

    @Override
    protected float[] readFloatArray(CtmInputStream in, int count, int size) throws IOException {
        return in.readPackedFloats(count, size);
    }

    @Override
    protected int[] readIntArray(CtmInputStream in, int count, int size, boolean signed) throws IOException {
        return in.readPackedInts(count, size, signed);
    }

    public void restoreIndices(int triangleCount, int[] indices) {
        for (int i = 0; i < triangleCount; ++i) {
            if (i >= 1) {
                int n = i * 3;
                indices[n] = indices[n] + indices[(i - 1) * 3];
            }
            int n = i * 3 + 2;
            indices[n] = indices[n] + indices[i * 3];
            if (i >= 1 && indices[i * 3] == indices[(i - 1) * 3]) {
                int n2 = i * 3 + 1;
                indices[n2] = indices[n2] + indices[(i - 1) * 3 + 1];
                continue;
            }
            int n3 = i * 3 + 1;
            indices[n3] = indices[n3] + indices[i * 3];
        }
    }
}

