/*
 * Decompiled with CFR 0.152.
 */
package darwin.jopenctm.compression;

import darwin.jopenctm.compression.MeshDecoder;
import darwin.jopenctm.compression.MeshEncoder;
import darwin.jopenctm.compression.RawDecoder;
import darwin.jopenctm.data.AttributeData;
import darwin.jopenctm.data.Mesh;
import darwin.jopenctm.io.CtmOutputStream;
import java.io.IOException;

public class RawEncoder
implements MeshEncoder {
    @Override
    public void encode(Mesh m, CtmOutputStream out) throws IOException {
        int vc = m.getVertexCount();
        out.writeLittleInt(MeshDecoder.INDX);
        this.writeIndicies(m.indices, out);
        out.writeLittleInt(MeshDecoder.VERT);
        this.writeFloatArray(m.vertices, out, vc * 3, 1);
        if (m.normals != null) {
            out.writeLittleInt(MeshDecoder.NORM);
            this.writeFloatArray(m.normals, out, vc, 3);
        }
        for (AttributeData ad : m.texcoordinates) {
            out.writeLittleInt(MeshDecoder.TEXC);
            out.writeString(ad.name);
            out.writeString(ad.materialName);
            this.writeFloatArray(ad.values, out, vc, 2);
        }
        for (AttributeData ad : m.attributs) {
            out.writeLittleInt(MeshDecoder.ATTR);
            out.writeString(ad.name);
            this.writeFloatArray(ad.values, out, vc, 4);
        }
    }

    protected void writeIndicies(int[] indices, CtmOutputStream out) throws IOException {
        out.writeLittleIntArray(indices);
    }

    protected void writeFloatArray(float[] array, CtmOutputStream out, int count, int size) throws IOException {
        out.writeLittleFloatArray(array);
    }

    @Override
    public int getTag() {
        return RawDecoder.RAW_TAG;
    }

    @Override
    public int getFormatVersion() {
        return 5;
    }
}

