/*
 * Decompiled with CFR 0.152.
 */
package darwin.jopenctm.data;

import java.util.Arrays;
import java.util.Objects;

public class AttributeData {
    public static final float STANDARD_UV_PRECISION = 2.4414062E-4f;
    public static final float STANDARD_PRECISION = 0.00390625f;
    public final String name;
    public final String materialName;
    public final float precision;
    public final float[] values;

    public AttributeData(String name, String materialName, float precision, float[] values) {
        this.name = name;
        this.materialName = materialName;
        this.precision = precision;
        this.values = values;
    }

    public boolean checkIntegrity() {
        return this.precision > 0.0f;
    }

    public int hashCode() {
        int hash = 3;
        hash = 67 * hash + Objects.hashCode(this.name);
        hash = 67 * hash + Objects.hashCode(this.materialName);
        hash = 67 * hash + Float.floatToIntBits(this.precision);
        hash = 67 * hash + Arrays.hashCode(this.values);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AttributeData other = (AttributeData)obj;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!Objects.equals(this.materialName, other.materialName)) {
            return false;
        }
        if (Float.floatToIntBits(this.precision) != Float.floatToIntBits(other.precision)) {
            return false;
        }
        return Arrays.equals(this.values, other.values);
    }
}

