/*
 * Decompiled with CFR 0.152.
 */
package darwin.jopenctm.data;

import darwin.jopenctm.io.CtmInputStream;
import darwin.jopenctm.io.CtmOutputStream;
import java.io.IOException;

public class Grid {
    private final float[] min;
    private final float[] max;
    private final int[] division;

    public static Grid fromStream(CtmInputStream in) throws IOException {
        return new Grid(in.readLittleFloatArray(3), in.readLittleFloatArray(3), in.readLittleIntArray(3));
    }

    public Grid(float[] min, float[] max, int[] division) {
        this.min = min;
        this.max = max;
        this.division = division;
    }

    public void writeToStream(CtmOutputStream out) throws IOException {
        out.writeLittleFloatArray(this.min);
        out.writeLittleFloatArray(this.max);
        out.writeLittleIntArray(this.division);
    }

    public void readFromStream(CtmInputStream in) throws IOException {
    }

    public boolean checkIntegrity() {
        if (this.min.length != 3) {
            return false;
        }
        if (this.max.length != 3) {
            return false;
        }
        if (this.division.length != 3) {
            return false;
        }
        for (int d : this.division) {
            if (d >= 1) continue;
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            if (!(this.max[i] < this.min[i])) continue;
            return false;
        }
        return true;
    }

    public float[] getMin() {
        return this.min;
    }

    public float[] getMax() {
        return this.max;
    }

    public int[] getDivision() {
        return this.division;
    }

    public float[] getSize() {
        float[] size = new float[3];
        for (int i = 0; i < 3; ++i) {
            size[i] = (this.max[i] - this.min[i]) / (float)this.division[i];
        }
        return size;
    }
}

