/*
 * Decompiled with CFR 0.152.
 */
package darwin.jopenctm.data;

import darwin.jopenctm.data.AttributeData;
import darwin.jopenctm.errorhandling.InvalidDataException;
import java.util.Arrays;

public class Mesh {
    public static final int CTM_ATTR_ELEMENT_COUNT = 4;
    public static final int CTM_NORMAL_ELEMENT_COUNT = 3;
    public static final int CTM_POSITION_ELEMENT_COUNT = 3;
    public static final int CTM_UV_ELEMENT_COUNT = 2;
    public final float[] vertices;
    public final float[] normals;
    public final int[] indices;
    public final AttributeData[] texcoordinates;
    public final AttributeData[] attributs;

    public Mesh(float[] vertices, float[] normals, int[] indices, AttributeData[] texcoordinates, AttributeData[] attributs) {
        this.vertices = vertices;
        this.normals = normals;
        this.indices = indices;
        this.texcoordinates = texcoordinates;
        this.attributs = attributs;
    }

    public int getVertexCount() {
        return this.vertices.length / 3;
    }

    public int getUVCount() {
        return this.texcoordinates.length;
    }

    public int getAttrCount() {
        return this.attributs.length;
    }

    public int getTriangleCount() {
        return this.indices.length / 3;
    }

    public boolean hasNormals() {
        return this.normals != null;
    }

    public float getAverageEdgeLength() {
        float totalLength = 0.0f;
        int edgeCount = 0;
        Object m = null;
        for (int i = 0; i < this.getTriangleCount(); ++i) {
            int p1 = this.indices[i * 3 + 2] * 3;
            for (int j = 0; j < 3; ++j) {
                int p2 = this.indices[i * 3 + j] * 3;
                float length = (this.vertices[p2] - this.vertices[p1]) * (this.vertices[p2] - this.vertices[p1]);
                length += (this.vertices[p2 + 1] - this.vertices[p1 + 1]) * (this.vertices[p2 + 1] - this.vertices[p1 + 1]);
                totalLength = (float)((double)totalLength + Math.sqrt(length += (this.vertices[p2 + 2] - this.vertices[p1 + 2]) * (this.vertices[p2 + 2] - this.vertices[p1 + 2])));
                p1 = p2;
                ++edgeCount;
            }
        }
        return totalLength / (float)edgeCount;
    }

    public void checkIntegrity() throws InvalidDataException {
        if (this.vertices == null || this.indices == null || this.vertices.length < 1 || this.getTriangleCount() < 1) {
            throw new InvalidDataException("The vertice or indice array is NULL or empty!");
        }
        if (this.indices.length % 3 != 0) {
            throw new InvalidDataException("The indice array size is not a multible of three!");
        }
        for (int ind : this.indices) {
            if (ind < this.vertices.length) continue;
            throw new InvalidDataException("One element of the indice array points to a none existing vertex(id: " + ind + ")");
        }
        for (float v : this.vertices) {
            if (!this.isNotFinit(v)) continue;
            throw new InvalidDataException("One of the vertice values is not finit!");
        }
        if (this.normals != null) {
            for (float n : this.normals) {
                if (!this.isNotFinit(n)) continue;
                throw new InvalidDataException("One of the normal values is not finit!");
            }
        }
        for (AttributeData map : this.texcoordinates) {
            for (float v : map.values) {
                if (!this.isNotFinit(v)) continue;
                throw new InvalidDataException("One of the texcoord values is not finit!");
            }
        }
        for (AttributeData map : this.attributs) {
            for (float v : map.values) {
                if (!this.isNotFinit(v)) continue;
                throw new InvalidDataException("One of the attribute values is not finit!");
            }
        }
    }

    private boolean isNotFinit(float value) {
        Float v = Float.valueOf(value);
        return v.isInfinite() || v.isNaN();
    }

    public int hashCode() {
        int hash = 3;
        hash = 67 * hash + Arrays.hashCode(this.vertices);
        hash = 67 * hash + Arrays.hashCode(this.normals);
        hash = 67 * hash + Arrays.hashCode(this.indices);
        hash = 67 * hash + Arrays.deepHashCode(this.texcoordinates);
        hash = 67 * hash + Arrays.deepHashCode(this.attributs);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Mesh other = (Mesh)obj;
        if (!Arrays.equals(this.vertices, other.vertices)) {
            return false;
        }
        if (!Arrays.equals(this.normals, other.normals)) {
            return false;
        }
        if (!Arrays.equals(this.indices, other.indices)) {
            return false;
        }
        if (!Arrays.deepEquals(this.texcoordinates, other.texcoordinates)) {
            return false;
        }
        return Arrays.deepEquals(this.attributs, other.attributs);
    }
}

