/*
 * Decompiled with CFR 0.152.
 */
package manakeri.Zombicalypse;

import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.g3d.decals.CameraGroupStrategy;
import com.badlogic.gdx.graphics.g3d.decals.Decal;
import com.badlogic.gdx.graphics.g3d.decals.DecalBatch;
import com.badlogic.gdx.math.Vector3;
import manakeri.Zombicalypse.City;
import manakeri.Zombicalypse.TGame;

public class Zombies {
    private static final short ROWS = 8;
    private static final short COLS = 8;
    private static final short SIZE = 128;
    private final Zombie[] zombies;
    private DecalBatch batch;
    private final int _amount;
    private final City _city;
    private final TextureRegion[] walk = new TextureRegion[64];

    public Zombies(City city, int amount) {
        this._amount = amount;
        this._city = city;
        this.zombies = new Zombie[amount];
        int i = 0;
        while (i < this.zombies.length) {
            this.zombies[i] = new Zombie(city);
            ++i;
        }
        Texture tex = new Texture("data/img/zombie_walk.png");
        int y = 0;
        while (y < 8) {
            int x = 0;
            while (x < 8) {
                this.walk[y * 8 + x] = new TextureRegion(tex, x * 128, y * 128, 128, 128);
                ++x;
            }
            ++y;
        }
    }

    public int amount() {
        int _amount = 0;
        Zombie[] zombieArray = this.zombies;
        int n = this.zombies.length;
        int n2 = 0;
        while (n2 < n) {
            Zombie zomb = zombieArray[n2];
            if (zomb.state != 255) {
                ++_amount;
            }
            ++n2;
        }
        return _amount;
    }

    public void checkHit(City city, int x, int z) {
        Zombie[] zombieArray = this.zombies;
        int n = this.zombies.length;
        int n2 = 0;
        while (n2 < n) {
            Zombie zomb = zombieArray[n2];
            if (zomb.state != 255) {
                int zx = (int)(((Zombie)zomb).position.x * (float)city.getWidth());
                int zz = (int)(((Zombie)zomb).position.z * (float)city.getHeight());
                if (zx == x && zz == z) {
                    zomb.state = (short)255;
                }
            }
            ++n2;
        }
    }

    public void draw(Camera cam, float delta) {
        Zombie[] zombieArray = this.zombies;
        int n = this.zombies.length;
        int n2 = 0;
        while (n2 < n) {
            Zombie zomb = zombieArray[n2];
            if (zomb.state != 255) {
                this.updatePos(zomb, delta);
                int dir = 0;
                float zdiff = cam.direction.z - ((Zombie)zomb).direction.z;
                float xdiff = cam.direction.x - ((Zombie)zomb).direction.x;
                dir = Math.abs(xdiff) > Math.abs(zdiff) ? (xdiff > 0.0f ? 4 : 0) : (zdiff > 0.0f ? 6 : 2);
                zomb.frame = Decal.newDecal(1.0f, 1.0f, this.walk[dir * 8 + zomb.state], true);
                zomb.frame.setPosition(((Zombie)zomb).position.x * (float)this._city.getWidth(), ((Zombie)zomb).position.y, ((Zombie)zomb).position.z * (float)this._city.getHeight());
                zomb.frame.lookAt(cam.position, cam.up.nor());
                this.batch.add(zomb.frame);
                Zombie zombie = zomb;
                zombie.timePassed = zombie.timePassed + delta;
                if (zomb.timePassed > 0.3f * Math.max(Math.abs(((Zombie)zomb).direction.x), Math.abs(((Zombie)zomb).direction.z))) {
                    zomb.timePassed = 0.0f;
                    if (zomb.state < 8) {
                        Zombie zombie2 = zomb;
                        zombie2.state = (short)(zombie2.state + 1);
                    } else {
                        zomb.state = (short)1;
                    }
                }
            }
            ++n2;
        }
        this.batch.flush();
    }

    public void init(Camera cam) {
        this.batch = new DecalBatch(this._amount, new CameraGroupStrategy(cam));
    }

    private void updatePos(Zombie zomb, float delta) {
        zomb.position.add(new Vector3(zomb.direction).mul(delta * 0.01f));
        if (!this._city.isRoad(((Zombie)zomb).position.x, ((Zombie)zomb).position.z)) {
            zomb.direction.set(-((Zombie)zomb).direction.x, 0.0f, -((Zombie)zomb).direction.z);
        }
    }

    class DIRECTION {
        static final short LEFT = 0;
        static final short BACK = 2;
        static final short RIGHT = 4;
        static final short FRONT = 6;
        static final short DEAD = 255;

        DIRECTION() {
        }
    }

    class Zombie {
        private final Vector3 position = new Vector3();
        private final Vector3 direction = new Vector3();
        private float timePassed;
        private short state;
        private Decal frame;

        public Zombie(City _city) {
            this.direction.set(TGame.rand.nextFloat(), 0.0f, TGame.rand.nextFloat());
            do {
                this.position.set(TGame.rand.nextFloat(), 0.0f, TGame.rand.nextFloat());
            } while (!_city.isRoad(this.position.x, this.position.z));
            this.state = 0;
        }
    }
}

