var minitel =
{ canvas            : null
, pid               : null
, firstTime         : null
, currentTime       : null
, audio             : null
, audioBuffer       : null
, channels          : null
, rate              : null
, frameBufferLength : null
, COLORS            : ["black","red","blue","yellow","green","purple","orange","white"]
, PERCENTCOLORS     : new Array(100)
, X0                : 0
, Y0                : 0
, WIDTH             : null
, HEIGHT            : null
, ZOOM              : 10
, BLUR              : 2
, init          : function() {
        var canvas  = document.getElementsByTagName("canvas")[0];
        var tmp     = document.defaultView.getComputedStyle(canvas);
        this.WIDTH  = Math.round(parseInt(tmp.getPropertyValue("width"))/2);
        this.HEIGHT = Math.round(parseInt(tmp.getPropertyValue("height"))/2);
        this.X0     = this.WIDTH /2;
        this.Y0     = this.HEIGHT /2;
        canvas.width    = this.WIDTH;
        canvas.height   = this.HEIGHT;
        this.canvas = canvas.getContext('2d');
        this.firstTime = this.getTime();
        for (var i=0; i<=100; i++) {
            var r = Math.round( 240* Math.min ((100-i)/50,1) );
            var g = Math.round( 240* Math.min (i/50,1) );
            var b = Math.round( 160* Math.max (0,((Math.abs(50-i)/100)-10)) );
            var a = 240* Math.max (.3,Math.min (i/50,1));
            this.PERCENTCOLORS[i] = "rgba("+r+","+g+","+b+","+a+")";
        }
    }
, getTime       : function() {
        return (new Date).getTime();
    }
, start         : function() {
        this.pid = window.setInterval("minitel.draw()", 1000/60);
    }
, stop          : function() {
        window.clearInterval(this.pid);
        this.pid = null;
    }
, toggle        : function() {
        if (this.pid) {
            this.stop();
        } else {
            this.init();
            this.start();
        }
    }
, animLoop      : function(){
        window.requestAnimFrame(this.animLoop);
        this.draw();
    }
, draw          : function() {
        this.currentTime = this.getTime();
        this.drawBackground();
        this.drawSpectrum();
    }
, drawSpectrum  : function() {
        this.canvas.strokeStyle = this.COLORS[this.currentTime%this.COLORS.length];
        this.canvas.lineHeight = 4;
        this.canvas.beginPath();
        var height = this.HEIGHT/2;
        var width = this.WIDTH/2;
        var w = 0, inc;
        this.canvas.moveTo(0,height);
        while (w<this.WIDTH) {
            inc = Math.round(Math.abs(w-width)/this.ZOOM)+this.ZOOM;
            this.canvas.lineTo(w,height+Math.sin(w+this.currentTime)*height/inc);
            w+= inc;
        }
        this.canvas.lineTo(this.WIDTH,height+Math.sin(w+this.currentTime)*height/inc);
        this.canvas.stroke();
    }
, drawBackground: function() {
        stackBlurCanvasRGBA("scene", 0, 0, this.WIDTH, this.HEIGHT, this.BLUR);
        this.canvas.fillStyle = "rgba(0,0,0,.1)";
        this.canvas.fillRect(0,0,this.WIDTH,this.HEIGHT);
    }
}