/**
 * La classe AjaxHandler sert  effectuer les appels asynchrones (Ajax) vers le serveur.
 * Les appels suivants sont grs :
 *  - rcupration d'un circuit
 *  - soumission d'un rsultat de course (temps + tlmtrie)
 */
 
/**
 * Cre un AjaxHandler et initialise l'objet XMLHTTPRequest qui
 * sera utilis pour les appels
 */
function AjaxHandler() 
{
	this.xhr = null;
	if(window.XMLHttpRequest) {
		this.xhr = new XMLHttpRequest();
	}
	else if(window.ActiveXOject)
	{
		try {
			this.xhr = new ActiveXObject("Msxml2.XMLHTTP");
		}    
		catch(e) {
			try {
				this.xhr = new ActiveXObject("Microsoft.XMLHTTP");
			}
			catch (e1) {
			}
		}
	}
	if (this.xhr) {
		this.xhr.handler = this;
		
		this.xhr.onreadystatechange = function() 
		{
			this.handler.updateProgress(this.readyState);
			if (this.readyState == 4) {
				this.handler.success = (this.status == 200 || this.status == 0);
				this.handler.failure = (this.status != 200 && this.status != 0);
				this.handler.errorMessage = this.statusText;
				this.handler.response = this.responseText;
				
				this.handler.context.ajaxCallCompleted();
			}
		}
	}
}

AjaxHandler.prototype = {

	/**
	 * Remet  zro les variables d'tat et dfinit la callback
	 * Pralablement  la prparation et  l'envoi d'une requte
	 * L'objet context doit prsenter les mthodes suivantes :
	 *  - updateAjaxProgress(val : [0,100]) -> mise  jour sur changement d'tat Ajax
	 *  - ajaxCallCompleted() -> appel termin sur russite ou chec
	 */
	initialize : function(context)
	{
		this.success = false;
		this.failure = false;
		this.context = context;
		this.context.updateAjaxProgress(0);
	},
	

	/**
	 * Envoie une requte Ajax pour demander la description d'un circuit
	 */
	retrieveRoad : function(mode, level, car, ghostId, context) {
		this.initialize(context);
		var params = "level="+level+"&mode="+mode+"&car="+car;
		if (ghostId != '') {
			params += "&ghost="+ghostId;
		}
		this.xhr.open('POST', 'http://renaissanceracer.com/demojs/ajax/circuit.php', true);
		this.xhr.setRequestHeader('Content-type', 'application/x-www-form-urlencoded');
		this.xhr.setRequestHeader('Content-length', params.length);
		this.xhr.setRequestHeader('Connection', 'close');
		this.xhr.send(params);
	},

	/**
	 * Envoie une requte Ajax pour soumettre un temps de course
	 */	
	submitRaceTime : function(mode, level, car, time, recording, context) {
		this.initialize(context);
		var params = "mode="+mode+"&level="+level+"&time="+time+"&car="+car+"&record="+recording;
		this.xhr.open('POST', 'http://renaissanceracer.com/demojs/ajax/damier.php', true);
		this.xhr.setRequestHeader('Content-type', 'application/x-www-form-urlencoded');
		this.xhr.setRequestHeader('Content-length', params.length);
		this.xhr.setRequestHeader('Connection', 'close');
		this.xhr.send(params);
	},
	
	/**
	 * Callback sur la progression de l'appel Ajax
	 *  - value : progression, entre 0 et 4
	 */
	updateProgress : function(progress) {
		this.context.updateAjaxProgress(25*progress);
	}

}

