/**
 * La classe Dictionary sert  l'internationalisation (i18n)
 * des messages utilisateurs rdigs dans le code javascript.
 */

 function Dictionary()
 {
	this.language = "en";
	this.messageList = {};
 
	this.addTranslation("fr", "EN001", "DEMO");
	this.addTranslation("fr", "EN002", "Cliquez pour lancer la partie");
 	this.addTranslation("fr", "EN003", "A vos marques");
 	this.addTranslation("fr", "EN004", "Prts");
 	this.addTranslation("fr", "EN005", "Partez");
 	this.addTranslation("fr", "EN006", "PAUSE");
	this.addTranslation("fr", "RE001", "FELICITATIONS ! VOUS AVEZ BATTU LE RECORD DU CIRCUIT !");
	this.addTranslation("fr", "RE002", "Bravo ! vous rentrez dans le top 5 du circuit !");
	this.addTranslation("fr", "RE003", "Bravo ! C'est votre meilleur temps sur ce circuit.");
	this.addTranslation("fr", "RE004", "Bravo ! Vous accdez au circuit suivant");
	this.addTranslation("fr", "RE005", "Vous obtenez une nouvelle voiture");
	this.addTranslation("fr", "RE006", "Bravo ! vous avez dsormais accs au mode /{0}/");
	this.addTranslation("fr", "GA001", "Toujours disponible");
	this.addTranslation("fr", "GA002", "Toujours disponible");
	this.addTranslation("fr", "GA003", "Obissez aux panneaux de signalisation.");
	this.addTranslation("fr", "GA004", "Sous la minute, dans la seconde.");
	this.addTranslation("fr", "GA005", "A gauche du rouge,  droite du bleu.");
	this.addTranslation("fr", "GA006", "A dfinir");
	this.addTranslation("fr", "GA007", "A dfinir");
	this.addTranslation("fr", "GA008", "A dfinir");
	this.addTranslation("fr", "GA009", "A dfinir");
	this.addTranslation("fr", "GA010", "A dfinir");
	this.addTranslation("fr", "GA011", "720");
	this.addTranslation("fr", "GA012", "A dfinir");
	this.addTranslation("fr", "GA013", "A dfinir");
	this.addTranslation("fr", "GA014", "A dfinir");
	this.addTranslation("fr", "GA015", "A dfinir");
	this.addTranslation("fr", "GA016", "A dfinir");
	this.addTranslation("fr", "LO001", "COURSE ");
	this.addTranslation("fr", "LO002", "Erreur de chargement");
	this.addTranslation("fr", "LO003", "Circuit introuvable");
	this.addTranslation("fr", "LO004", "Record : /{0}/");
	this.addTranslation("fr", "LO005", ", perso : /{0}/");
	this.addTranslation("fr", "LO006", "qualif. : /{0}/");
	this.addTranslation("fr", "LO007", "Chargement termin, appuyez sur une touche.");
	this.addTranslation("fr", "CS001", "Vitesse<br>Acclration<br>Maniabilit");
	this.addTranslation("fr", "TW001", "Circuit suivant");
	this.addTranslation("fr", "TW002", "Recommencer");
	this.addTranslation("fr", "TW003", "Menu principal");
	this.addTranslation("fr", "TW004", "Continuer");
	this.addTranslation("fr", "TW005", "Reprendre le dpart");

	this.addTranslation("en", "EN001", "DEMO");
	this.addTranslation("en", "EN002", "Click to race");
 	this.addTranslation("en", "EN003", "Marks");
 	this.addTranslation("en", "EN004", "Set");
 	this.addTranslation("en", "EN005", "Go");
 	this.addTranslation("en", "EN006", "GAME PAUSED");
	this.addTranslation("en", "RE001", "CONGRATULATIONS ! YOU DROVE THE FASTEST LAP EVER ON THIS TRACK !");
	this.addTranslation("en", "RE002", "Cheers ! You entered the track top 5 !");
	this.addTranslation("en", "RE003", "Cheers ! This is your new fastest lap on this track.");
	this.addTranslation("en", "RE004", "Great ! You qualified for the next race");
	this.addTranslation("en", "RE005", "You can now drive this brand new car");
	this.addTranslation("en", "RE006", "Great ! You unlocked /{0}/ mode");
	this.addTranslation("en", "GA001", "Toujours disponible");
	this.addTranslation("en", "GA002", "Toujours disponible");
	this.addTranslation("en", "GA003", "Obey traffic signs.");
	this.addTranslation("en", "GA004", "Round out the second before the minute ends.");
	this.addTranslation("en", "GA005", "A dfinir");
	this.addTranslation("en", "GA006", "Left side of the red, right side of the blue.");
	this.addTranslation("en", "GA007", "A dfinir");
	this.addTranslation("en", "GA008", "A dfinir");
	this.addTranslation("en", "GA009", "A dfinir");
	this.addTranslation("en", "GA010", "A dfinir");
	this.addTranslation("en", "GA011", "720");
	this.addTranslation("en", "GA012", "A dfinir");
	this.addTranslation("en", "GA013", "A dfinir");
	this.addTranslation("en", "GA014", "A dfinir");
	this.addTranslation("en", "GA015", "A dfinir");
	this.addTranslation("en", "GA016", "A dfinir");
	this.addTranslation("en", "LO001", "TRACK ");
	this.addTranslation("en", "LO002", "Load failed");
	this.addTranslation("en", "LO003", "Unknown track");
	this.addTranslation("en", "LO004", "Track best : /{0}/");
	this.addTranslation("en", "LO005", ", own : /{0}/");
	this.addTranslation("en", "LO006", "/{0}/ to qualify");
	this.addTranslation("en", "LO007", "Load complete, press any key to start.");
	this.addTranslation("en", "CS001", "Top speed<br>Acceleration<br>Handling");
	this.addTranslation("en", "TW001", "Next race");
	this.addTranslation("en", "TW002", "Race again");
	this.addTranslation("en", "TW003", "Main menu");
	this.addTranslation("en", "TW004", "Resume");
	this.addTranslation("en", "TW005", "Restart race");
}
 
 
  Dictionary.prototype = {
  
	/**
	 * Dfinit la langue  utiliser pour les traductions, aprs avoir valid
	 * qu'elle est connue. Sinon ne fait rien.
	 */
	setLanguage : function(language) 
	{
		if (undefined != this.messageList[language]) {
			this.language = language;
		}
	},
	
	/**
	 * Complte la liste des messages traduits
	 */
	addTranslation : function(language, index, text)
	{
		if (undefined == this.messageList[language])
		{
			this.messageList[language] = {};
		}
		this.messageList[language][index] = text;
	},
	
	/**
	 * Recherche la traduction d'un message dans la langue courante
	 * avec un paramtre qui va remplacer /{0}/ dans la chane
	 * Si ce paramtre est undefined, le message est fixe (cas le plus courant)
	 */
	translate : function(index, parameter)
	{
		var translated = this.messageList[this.language][index];
		var re = new RegExp ("\\\/\\\{0\\\}\\\/", "g");
		if (undefined != parameter) {
			translated = translated.replace(re, parameter);
		}
		return translated;
	}
}
  
var i18n = new Dictionary();
  
  
/**
 * Fonction d'internationalisation avec paramtre
 * Celui-ci peut tre undefined
 */
function _(message, parameter)
{
	return i18n.translate(message, parameter);
}