/**
 * ImageFx est un namespace destin  effectuer des oprations graphiques 
 * communes. Les oprations dfinies  l'origine dans un cadre particulier
 * sont regroupes ici afin d'tre rutilises.
 * Les effets disponibles sont :
 *  - criture d'un texte avec dtourage, et manipulation des couleurs du texte
 */
 
 
/**
 * Cre une instance d'un ImageFx 
 */
function ImageFx ()
{
}

ImageFx.prototype = {

	/** 
	 * Cre un panneau <div> contenant un texte dtour, l'ajoute  un container
	 * fourni, et le retourne.
	 * Le texte est par dfaut vide et pourra tre modifi autant que souhait
	 * via un appel  outlinedWrite()
	 * Paramtres :
	 *  - container : l'instance du container accueillant le panneau
	 *  - panelClass : la ou les classes (spares par un espace) du panneau
	 *  - outlineClass : la classe du texte (pour dfinir sa taille)
	 *  - mainColor : la couleur du texte central (pas celle du dtourage) au format CSS
	 *
	 * La mthode renvoie le nouveau panneau ainsi cr.
	 * Il n'y a pas de mthode de suppression, il suffit de disposer du panneau.
	 *
	 * Le dtourage se fait en crant 5 copies du texte, une centre de la couleur d'criture,
	 * et quatre dcales chacune de un pixel dans les quatre diagonales, de la couleur d'ombrage.
	 * (note : mthode importe de RacingGame)
	 */
	createOutlinedTextPanel : function(container, panelClass, outlineClass, mainColor)
	{
		var containingPanel = document.createElement('div');
		containingPanel.setAttribute("class", panelClass);
		container.appendChild(containingPanel);
		
		var mainText = document.createElement('div');
		mainText.setAttribute("class", outlineClass+" imagefx_outline_fg");
		mainText.style.color=mainColor;
		mainText.appendChild(document.createTextNode(""));
		containingPanel.appendChild(mainText);
		   
		var outlineTopLeft = document.createElement('div');
		outlineTopLeft.setAttribute("class", outlineClass+" imagefx_outline_bg_topleft");
		outlineTopLeft.appendChild(document.createTextNode(""));
		containingPanel.appendChild(outlineTopLeft);
	
		var outlineTopRight = document.createElement('div');
		outlineTopRight.setAttribute("class", outlineClass+" imagefx_outline_bg_topright");
		outlineTopRight.appendChild(document.createTextNode(""));
		containingPanel.appendChild(outlineTopRight);
		
		var outlineBottomLeft = document.createElement('div');
		outlineBottomLeft.setAttribute("class", outlineClass+" imagefx_outline_bg_bottomleft");
		outlineBottomLeft.appendChild(document.createTextNode(""));
		containingPanel.appendChild(outlineBottomLeft);
		
		var outlineBottomRight = document.createElement('div');
		outlineBottomRight.setAttribute("class", outlineClass+" imagefx_outline_bg_bottomright");
		outlineBottomRight.appendChild(document.createTextNode(""));
		containingPanel.appendChild(outlineBottomRight);
		
		return containingPanel;
	},
	
 	 /**
	  * Affiche un texte dtour.
	  * Ncessite que le panneau ait t cr avec la mthode createOutlinedTextPanel()
	  * (attention, pour une question de performance, aucune vrification n'est faite)
	  * Paramtres :
	  *  - panel : instance du panneau
	  *  - text : chane de caractres  afficher
	  */
	outlinedWrite : function(panel, text)
	{
		for (var i=0; i<5; ++i) {
			panel.childNodes[i].firstChild.data = text;
		}
	},

	/**
	 * Modifie la couleur d'affichage du texte principal (pas le dtourage) d'un 
	 * texte cr par createOutlinedTextPanel()
	 *  - newColor : une chane reprsentant la couleur sous une forme CSS reconnue
	 */
	setHighlightColor : function(panel, newColor)
	{
		panel.firstChild.style.color = newColor;
	},
	
	/**
	 * Modifie la couleur de dtourage d'un texte cr par createOutlinedTextPanel()
	 * sans toucher  la couleur principale
	 *  - newColor : une chane reprsentant la couleur sous une forme CSS reconnue
	 */
	setOutlineColor : function(panel, newColor)
	{
		for (var i=0; i<5; ++i) {
			panel.childNodes[i].style.color = newColor;
		}
	}
	
}
 