<?php
/**
 * La classe LayoutBase prend en charge la sortie HTML de l'ensemble
 * des lments communs de l'affichage. 
 * 
 * Il suffit aux diffrentes pages d'appeler la LayoutBase pour tous les lments
 * styls et de dcoration, et d'crire (via echo ou print) leur propre code dans
 * la div rr_main, et ventuellement dans les lments optionnels.
 *
 * Contenu d'une page
 *  
 * * outputHead()
 * * includes javascript (optionnel)
 * * outputUpperHalf()
 * * contenu du panel principal
 * * outputLowerHalf()
 */


class LayoutBase {

	/**
	 * Ecrit le code HTML du dbut jusqu' l'appel au style CSS,
	 * ainsi que l'include javascript pour le dplacement des dialogues
	 * si la variable $featureLoginForm est  TRUE.
	 */
	public function outputHead($featureLoginForm) {
		echo '<!DOCTYPE HTML PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN">
<html><head>
	<title>Renaissance Racer</title>
    <link rel="stylesheet" type="text/css" media="screen" href="tron.css" />
';
	if ($featureLoginForm) {
		echo '	<script language="Javascript" src="dialogs.js"></script>
';
		}
	}
	
	/**
	 * Ecrit le code HTML de la premire moiti de la page, de la fin du head
	 * jusqu'au div de navigation, l'ouverture du div rr_main et le message li  l'action en cours
	 * Paramtres : 
	 *  - $featureLoginForm : true pour afficher le panneau de login
	 *  - $synchroToken : le jeton de synchronisation dfini par le Bouncer, retest  chaque action
	 *  - $selectedTab : index de l'onglet de la barre de navigation  dessiner comme slectionn
	 *  - $message : contenu du message  afficher dans la div rr_main
	 */
	public function outputUpperHalf($featureLoginForm, $synchroToken, $selectedTab, $message) {
		echo '</head>
<body>
	<div id="screenOverlay" class="rr_overlay"></div>
    <div class="rr_global">
		<div class="rr_logo"><img src="common/rr_logo.png" alt="Logo" /></div>
		<a class="rr_flag_fr" href="'.$_SERVER['PHP_SELF'].'?lang=fr"></a>
		<a class="rr_flag_en" href="'.$_SERVER['PHP_SELF'].'?lang=en"></a>
';
		if ($featureLoginForm) {
			echo '		<div class="rr_login">
				<form method="post" action="index.php">
					'.t_('FORM_NAME').' : <input type="text" name="username" length="30" /><br>
					'.t_('FORM_PASSWORD').' : <input type="password" name="password" /><br>
					<input class="rr_button" type="submit" value="'.t_('FORM_LOGIN').'" />
				</form>
				<a href="#" onclick="showForm(\'signupForm\')">'.t_('FORM_SIGNUP').'</a>
				<a href="#" onclick="showForm(\'regenerationForm\')">'.t_('FORM_LOST_PASSWORD').'</a>
			</div>
			<div id="signupForm" class="rr_signup">
				<p>'.t_('FORM_SIGNUP_INTRO').'</p>
				<form method="post" id="signupContents" action="inscription.php">
					<input type="hidden" name="synchroToken" value="';
			echo $synchroToken;
			echo '" />
					'.t_('FORM_NAME').' : <input type="text" class="rr_signup_input" id="signupName" name="username" length="30" onkeyup="checkLoginInProgress()" onblur="checkLoginComplete()"/><span class="rr_warn" id="message1"></span><br>
					'.t_('FORM_ADDRESS').' : <input type="text" class="rr_signup_input" id="signupAddress" name="address" onchange="checkAddress()"/><span class="rr_warn" id="message2"></span><br>
					'.t_('FORM_PASSWORD').' : <input type="password" class="rr_signup_input" id="signupPass1" name="pass1" onchange="checkPasswordMatch(false)"/><span class="rr_warn" id="message3"></span><br>
					'.t_('FORM_PASSWORD').' : <input type="password" class="rr_signup_input" id="signupPass2" name="pass2" onchange="checkPasswordMatch(false)"/><span class="rr_warn" id="message4"></span><br>
					<b id="message5"></b><br>
					<input class="rr_button_off" type="button" value="'.t_('FORM_SIGNUP').'" id="signupSubmit" onclick="finalCheck()"/>
					<input class="rr_button" type="button" value="'.t_('FORM_CANCEL').'" onclick="hideForm()" />
				</form>
			</div>
			<div id="regenerationForm" class="rr_signup">
				<p>'.t_('FORM_LOST_PW_INTRO').'</p>
				<form method="post" action="inscription.php">
					<input type="hidden" name="synchroToken" value="';
			echo $synchroToken;
			echo '" />
					'.t_('FORM_NAME').' : <input type="text" id="userName" name="username" length="30" /><br>
					'.t_('FORM_ADDRESS').' : <input type="text" id="userAddress" name="address" /><br>
					<input class="rr_button" type="submit" value="'.t_('FORM_SEND').'" />
					<input class="rr_button" type="button" value="'.t_('FORM_CANCEL').'" onclick="hideForm()" />
				</form>
			</div>
';
		} else { // if ($featureLoginForm)
			echo '<div class="rr_login">
					<p>';
			echo $_SESSION['userName'];
			echo '</p>
					<p><a href="logout.php">'.t_('FORM_LOGOUT').'</a></p>
</div>';
		} // if ($featureLoginForm) else
		
		echo '
		<div class="rr_cars_image"></div>
		<div class="rr_navig">
		    <ul>
			  <li><a href="index.php">'.t_('MENU_HOME').'</a></li>
			  <li><a href="jeu.php">'.t_('MENU_RACE').'</a></li>
			  <li><a href="records.php">'.t_('MENU_HOF').'</a></li>
			  <li><a href="options.php">'.t_('MENU_OPTIONS').'</a></li>
			</ul>
		</div>
		<div class="rr_main">
';
		echo '<div class="rr_message">';
		echo $message;
		echo '</div>';
	}
		
	
 
	/**
	 * Ecrit le code HTML, de la fermeture de la div rr_main jusqu' 
	 * la fin de la page
	 */
	public function outputLowerHalf() {
		echo '		</div>
		<div class="rr_footer">
			<hr>
			Copyright 2010 - 
			<a href="cgu.php">'.t_('MENU_TOS').'</a> - 
			<a href="credits.php">'.t_('MENU_CREDITS').'</a> - 
			<a href="licence.php">'.t_('MENU_LICENSE').'</a>
		</div>
	</div>
</body></html>';
	}

};

?>