/**
 * La classe RaceResult reprsente un rsultat de course et ses consquences :
 *  - qualification pour le circuit suivant
 *  - dverrouillage de voiture ou de mode de jeu
 *
 * Il est prvu pour tre unique sur une instance de jeu et donc rutilis de partie en partie
 * via des appels successifs  initialize()
 */
 
 
 /**
  * Cration d'un rsultat de course
  */
 function RaceResult(season, garage)
 {
	this.raceTime = 0;
	this.formerTop5Entry = 0;
	this.formerPlayerBest = 0;
	this.playerBest = Number.MAX_VALUE;

	this.unlockedTrack = 0;	// on ne peut en ouvrir qu'un  la fois
	this.unlockedCars = new Array(); // on peut en dverrouiller plusieurs d'un coup
	this.unlockedModes = new Array();
	
	this.messages = new Array();	// messages de flicitations, il peut y en avoir plusieurs
	
	this.road = null;
	this.season = season;
	this.garage = garage;
 
 }
 
 
RaceResult.prototype = {

	/**
	 * Initialise le rsultat de la course,  partir du temps ralis et de la description du circuit :
	 *  - stocke le temps ralis
	 *  - rcupre le 5e temps du top 5
	 * Cet mthode doit tre excute avant l'appel Ajax pour soumettre le temps ralis
	 * (avant la mise  jour de l'objet Road)
	 */
	initialize : function(raceTime, road)
	{
		this.raceTime = raceTime;
		this.road = road;
		if (road.lapRecords[road.lapRecordCount-1].time == 0) {
			this.formerTop5Entry = Number.MAX_VALUE;
		} else {
			this.formerTop5Entry = road.lapRecords[road.lapRecordCount-1].time;
		}
		this.formerPlayerBest = road.playerLapRecord.time;
		this.playerBest = Number.MAX_VALUE;
		this.unlockedTrack = 0;
		this.unlockedCars = []; 
		this.unlockedModes = [];
		
		this.messages = [];
	},

	/**
	 * Met  jour le tableau des voitures/circuit/modes dverrouills
	 * en fonction de la description XML reue du serveur lors de la soumission du circuit
	 */
	updateFromServerResponse : function(serverResponse)
	{
		var unlockDesc = serverResponse.match(/<unlocked>(.*?)<\/unlocked>/g); // regExp  <unlocked>...</unlocked> 
		if (null != unlockDesc) {
			var trackDesc = unlockDesc[0].match(/<track>(\d*)<\/track>/);
			if (null != trackDesc) {
				this.unlockedTrack = parseInt(trackDesc[1]);
			}
			var allCarsDesc = unlockDesc[0].match(/<car>(\d*)<\/car>/g);
			if (null != allCarsDesc) {
				for (var carIndex=0; carIndex<allCarsDesc.length; ++carIndex) {
					var carDesc = allCarsDesc[carIndex].match(/<car>(\d*)<\/car>/);
					this.unlockedCars[carIndex] = parseInt(carDesc[1]);
				}
			}
			var allModesDesc = unlockDesc[0].match(/<mode>(\d*)<\/mode>/g);
			if (null != allModesDesc) {
				for (var modeIndex=0; modeIndex<allModesDesc.length; ++modeIndex) {
					var modeDesc = allModesDesc[modeIndex].match(/<mode>(\d*)<\/mode>/);
					this.unlockedModes[modeIndex] = parseInt(modeDesc[1]);
				}
			}
		}
		
		var playerLapTimesDesc = serverResponse.match(/<playerTime><name>([^<]+)<\/name><car>(\d*)<\/car><time>(\d*)<\/time><\/playerTime>/); 
		if (playerLapTimesDesc != null) {
			this.playerBest = parseInt(playerLapTimesDesc[3]); // regExp <time>...</time>
		}
		this.prepareMessages();
	},
	
	/**
	 * Prpare les messages  destination de l'utilisateur, en fonction du temps ralis.
	 * L'instance de Road doit avoir t mise  jour avec les derniers records
	 */
	prepareMessages : function()
	{
		// en premier lieu, on vrifie si un record du circuit a t battu. On teste par
		// ordre de priorit, en ne gardant que le meilleur :
		// - meilleur temps du circuit
		// - entre dans le top 5
		// - record personnel battu
		if (this.road.lapRecords[0].time == this.raceTime) {
			this.messages.push({text:_("RE001"), image:"", legend:""});
		} else if (this.playerBest == this.raceTime && this.raceTime < this.formerTop5Entry && this.formerPlayerBest > this.formerTop5Entry) {
			this.messages.push({text:_("RE002"), image:"", legend:""});
		} else if (this.playerBest == this.raceTime && this.raceTime < this.formerPlayerBest) {
			this.messages.push({text:_("RE003"), image:"", legend:""});
		}
		
		if (this.unlockedTrack > 0) {
			var trackName = this.season.getTrack(this.unlockedTrack).name;
			this.messages.push({text:_("RE004"), image:this.season.getTrackFolder(this.unlockedTrack)+"splash240.png", legend:trackName});
		}
		for (var carIndex = 0; carIndex<this.unlockedCars.length; ++carIndex) {
			var carNumber = parseInt(this.unlockedCars[carIndex]);
			var carName = this.garage.getCar(carNumber).name;
			this.messages.push({text:_("RE005"), image:this.garage.getCar(carNumber).selectionImage, legend:carName});
			this.garage.unlockCar(carNumber);
		}
		var modeName = ["", "simulation", "arcade", "drift"];
		for (var modeIndex = 0; modeIndex<this.unlockedModes.length; ++modeIndex) {
			this.messages.push({text:_("RE006", modeName[parseInt(this.unlockedModes[modeIndex])]), image:"", legend:""});
		}
	}
}