/**
 * La classe Season dfinit une saison de course automobile .. autrement dit un ensemble de circuits.
 * C'est pour les circuits l'quivalent du Garage pour les voitures.
 *
 * Il sera ainsi possible de dfinir diffrents environnements de jeu avec des ensembles de circuits distincts.
 */
 
 
 
 function Season()
 {
	this.trackCount = 16;
	this.tracks = new Array(this.trackCount+1);
 }
 
 Season.prototype = {
 
	/**
	 * Dfinit les circuits composant la saison standard.
	 * Un circuit est compos de :
	 *   - son nom
	 *   - la mto
	 *   - la nature du sol
	 *
	 * Le trac du circuit est charg depuis le serveur et non renseign ici
	 */
	defineStandardTracks : function() {
		this.tracks[0] = {
			name : "Kit de construction",
			weather : 0,
			surface : 0 
		};
		this.tracks[1] = {
			name : "GRANDS CAUSSES",
			weather : 0,
			surface : 0 
		};
		this.tracks[2] = {
			name : "TERRITOIRE DU NORD",
			weather : 0,
			surface : 0 
		};
		this.tracks[3] = {
			name : "ALPES SUISSES",
			weather : 0,
			surface : 0 
		};
		this.tracks[4] = {
			name : "CONNEMARA",
			weather : 0,
			surface : 0 
		};
		this.tracks[5] = {
			name : "Test 100m",
			weather : 0,
			surface : 0 
		};
		this.tracks[6] = {
			name : "Test ligne droite",
			weather : 0,
			surface : 0 
		};
		this.tracks[7] = {
			name : "Track Name 7",
			weather : 0,
			surface : 0 
		};
		this.tracks[8] = {
			name : "Track Name 8",
			weather : 0,
			surface : 0 
		};
		this.tracks[9] = {
			name : "Track Name 9",
			weather : 0,
			surface : 0 
		};
		this.tracks[10] = {
			name : "Track Name 10",
			weather : 0,
			surface : 0 
		};
		this.tracks[11] = {
			name : "Track Name 11",
			weather : 0,
			surface : 0 
		};
		this.tracks[12] = {
			name : "Track Name 12",
			weather : 0,
			surface : 0 
		};
		this.tracks[13] = {
			name : "Track Name 13",
			weather : 0,
			surface : 0 
		};
		this.tracks[14] = {
			name : "Track Name 14",
			weather : 0,
			surface : 0 
		};
		this.tracks[15] = {
			name : "Track Name 15",
			weather : 0,
			surface : 0 
		};
		this.tracks[16] = {
			name : "Track Name 16",
			weather : 0,
			surface : 0 
		};
	},
 
	/**
	 * Dfinit ou modifie les informations d'un circuit
	 * (pour centraliser ces donnes, incluant les traductions des noms des circuits,
	 * au niveau serveur).
	 * La fonction sert surtout  transmettre les infos du serveur vers le client,
	 * via le code javascript gnr.
	 *
	 * Paramtres :
	 *  - index : numro du circuit (commence  1, 0 est le circuit dmo)
	 */
	setTrackDetails : function(index, name, weather, surface) {
		this.tracks[index] = {
			name : name,
			weather : weather,
			surface : surface 
		};
	},	 
 
	/**
	 * Renvoie le dtail de la piste
	 */
	getTrack : function(index) {
		if (index<0 || index > this.trackCount) {
			return null;
		}
		return this.tracks[index];
	 },
 
	/**
	 * Renvoie le rpertoire du niveau correspondant
	 * Le rpertoire est "levelNNN" avec NNN le numro, complt si ncessaire avec des 0  gauche.
	 * Pour 1, renvoie par exemple "level001"
	 */
	getTrackFolder : function(value) {
		var level = parseInt(value);
		var folder = "level" + (level<100 ? "0" : "") + (level<10 ? "0" : "") + level + "/";
		return folder;
	}
	
 }