#version 330

layout( location = 0 ) in vec2 InVertex;

uniform mat4 ProjectionMatrix;
uniform float Progress;

void main()
{
	vec2 FinalVert = InVertex;
	if( FinalVert.x > 0.0 && Progress >= 0.0 )
	{
		FinalVert.x = ( ( FinalVert.x / 100.0 ) * ( 2.0 * Progress ) ) - FinalVert.x;
	}
	gl_Position = ProjectionMatrix * vec4( vec3( FinalVert, -1.0 ), 1.0 );
}