//VERTEX
#version 330

uniform mat4 u_ViewMatrix;
uniform mat4 u_ProjectionMatrix;
uniform mat4 u_ObjectLocalMatrix;

uniform mat4 u_JointMatrix[40];
uniform mat4 u_BindPoseMatrix[40];

in layout(location = 0) vec3 Vertex;
in layout(location = 1) vec3 Normal;
in layout(location = 2) vec2 UV;


out vec3 vcolor;

void main()
{
	gl_Position = u_ProjectionMatrix * u_ViewMatrix * u_ObjectLocalMatrix * vec4(Vertex,1.0);

	vcolor.x = gl_Position.z/600.0f;
	vcolor.y = gl_Position.z/400.0f;
	vcolor.z = gl_Position.z/200.0f;

}



//FRAGMENT
#version 330

out vec4 color;
in vec3 vcolor;

void main() {
	color = vec4(vcolor,1.0);
}

//END
