/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl;

import com.jogamp.common.nio.CachedBufferFactory;
import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.opencl.CLBuffer;
import com.jogamp.opencl.CLContext;
import com.jogamp.opencl.CLDevice;
import com.jogamp.opencl.CLEventList;
import com.jogamp.opencl.CLException;
import com.jogamp.opencl.CLImage;
import com.jogamp.opencl.CLImage2d;
import com.jogamp.opencl.CLImage3d;
import com.jogamp.opencl.CLKernel;
import com.jogamp.opencl.CLMemory;
import com.jogamp.opencl.CLObjectResource;
import com.jogamp.opencl.gl.CLGLObject;
import com.jogamp.opencl.llb.CLCommandQueueBinding;
import com.jogamp.opencl.llb.gl.CLGL;
import com.jogamp.opencl.util.CLUtil;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CLCommandQueue
extends CLObjectResource {
    private final CLCommandQueueBinding cl;
    private final CLDevice device;
    private long properties;
    private final IntBuffer pbA;
    private final PointerBuffer ibA;
    private final PointerBuffer ibB;
    private final PointerBuffer ibC;

    private CLCommandQueue(CLContext context, long id, CLDevice device, long properties) {
        super(context, id);
        this.device = device;
        this.properties = properties;
        this.cl = context.getPlatform().getCommandQueueBinding();
        int pbsize = PointerBuffer.ELEMENT_SIZE;
        CachedBufferFactory factory = CachedBufferFactory.create(9 * pbsize + 4, true);
        this.ibA = PointerBuffer.wrap(factory.newDirectByteBuffer(3 * pbsize));
        this.ibB = PointerBuffer.wrap(factory.newDirectByteBuffer(3 * pbsize));
        this.ibC = PointerBuffer.wrap(factory.newDirectByteBuffer(3 * pbsize));
        this.pbA = factory.newDirectIntBuffer(1);
    }

    static CLCommandQueue create(CLContext context, CLDevice device, long properties) {
        int[] status = new int[1];
        CLCommandQueueBinding binding = context.getPlatform().getCommandQueueBinding();
        long id = binding.clCreateCommandQueue(context.ID, device.ID, properties, status, 0);
        if (status[0] != 0) {
            throw CLException.newException(status[0], "can not create command queue on " + device + " with properties: " + Mode.valuesOf(properties));
        }
        return new CLCommandQueue(context, id, device, properties);
    }

    public CLCommandQueue putWriteBuffer(CLBuffer<?> writeBuffer, boolean blockingRead) {
        return this.putWriteBuffer(writeBuffer, blockingRead, null, null);
    }

    public CLCommandQueue putWriteBuffer(CLBuffer<?> writeBuffer, boolean blockingRead, CLEventList events) {
        return this.putWriteBuffer(writeBuffer, blockingRead, null, events);
    }

    public CLCommandQueue putWriteBuffer(CLBuffer<?> writeBuffer, boolean blockingWrite, CLEventList condition, CLEventList events) {
        int ret;
        PointerBuffer conditionIDs = null;
        int conditions = 0;
        if (condition != null) {
            conditionIDs = condition.IDsView;
            conditions = condition.size;
        }
        if ((ret = this.cl.clEnqueueWriteBuffer(this.ID, writeBuffer.ID, CLUtil.clBoolean(blockingWrite), 0L, writeBuffer.getNIOSize(), writeBuffer.buffer, conditions, conditionIDs, events == null ? null : events.IDs)) != 0) {
            throw CLException.newException(ret, "can not enqueue write-buffer: " + writeBuffer + " with " + CLCommandQueue.toStr(condition, events));
        }
        if (events != null) {
            events.createEvent(this.context);
        }
        return this;
    }

    public CLCommandQueue putReadBuffer(CLBuffer<?> readBuffer, boolean blockingRead) {
        this.putReadBuffer(readBuffer, blockingRead, null, null);
        return this;
    }

    public CLCommandQueue putReadBuffer(CLBuffer<?> readBuffer, boolean blockingRead, CLEventList events) {
        this.putReadBuffer(readBuffer, blockingRead, null, events);
        return this;
    }

    public CLCommandQueue putReadBuffer(CLBuffer<?> readBuffer, boolean blockingRead, CLEventList condition, CLEventList events) {
        int ret;
        PointerBuffer conditionIDs = null;
        int conditions = 0;
        if (condition != null) {
            conditionIDs = condition.IDsView;
            conditions = condition.size;
        }
        if ((ret = this.cl.clEnqueueReadBuffer(this.ID, readBuffer.ID, CLUtil.clBoolean(blockingRead), 0L, readBuffer.getNIOSize(), readBuffer.buffer, conditions, conditionIDs, events == null ? null : events.IDs)) != 0) {
            throw CLException.newException(ret, "can not enqueue read-buffer: " + readBuffer + " with " + CLCommandQueue.toStr(condition, events));
        }
        if (events != null) {
            events.createEvent(this.context);
        }
        return this;
    }

    public CLCommandQueue putCopyBuffer(CLBuffer<?> src, CLBuffer<?> dest) {
        return this.putCopyBuffer(src, dest, 0, 0, src.getCLSize(), null, null);
    }

    public CLCommandQueue putCopyBuffer(CLBuffer<?> src, CLBuffer<?> dest, long bytesToCopy) {
        return this.putCopyBuffer(src, dest, 0, 0, bytesToCopy, null, null);
    }

    public CLCommandQueue putCopyBuffer(CLBuffer<?> src, CLBuffer<?> dest, int srcOffset, int destOffset, long bytesToCopy, CLEventList events) {
        return this.putCopyBuffer(src, dest, 0, 0, bytesToCopy, null, events);
    }

    public CLCommandQueue putCopyBuffer(CLBuffer<?> src, CLBuffer<?> dest, int srcOffset, int destOffset, long bytesToCopy, CLEventList condition, CLEventList events) {
        int ret;
        PointerBuffer conditionIDs = null;
        int conditions = 0;
        if (condition != null) {
            conditionIDs = condition.IDsView;
            conditions = condition.size;
        }
        if ((ret = this.cl.clEnqueueCopyBuffer(this.ID, src.ID, dest.ID, srcOffset, destOffset, bytesToCopy, conditions, conditionIDs, events == null ? null : events.IDs)) != 0) {
            throw CLException.newException(ret, "can not enqueue copy-buffer from " + src + " to " + dest + " with srcOffset: " + srcOffset + " dstOffset: " + destOffset + " bytesToCopy: " + bytesToCopy + CLCommandQueue.toStr(condition, events));
        }
        if (events != null) {
            events.createEvent(this.context);
        }
        return this;
    }

    public CLCommandQueue putWriteBufferRect(CLBuffer<?> writeBuffer, int originX, int originY, int hostX, int hostY, int rangeX, int rangeY, boolean blockingWrite, CLEventList condition, CLEventList events) {
        this.putWriteBufferRect(writeBuffer, originX, originY, hostX, hostY, rangeX, rangeY, 0L, 0L, 0L, 0L, blockingWrite, condition, events);
        return this;
    }

    public CLCommandQueue putWriteBufferRect(CLBuffer<?> writeBuffer, int originX, int originY, int hostX, int hostY, int rangeX, int rangeY, long rowPitch, long slicePitch, long hostRowPitch, long hostSlicePitch, boolean blockingWrite, CLEventList condition, CLEventList events) {
        this.putWriteBufferRect(writeBuffer, originX, originY, 0, hostX, hostY, 0, rangeX, rangeY, 1, 0L, 0L, 0L, 0L, blockingWrite, condition, events);
        return this;
    }

    public CLCommandQueue putWriteBufferRect(CLBuffer<?> writeBuffer, int originX, int originY, int originZ, int hostX, int hostY, int hostZ, int rangeX, int rangeY, int rangeZ, boolean blockingWrite, CLEventList condition, CLEventList events) {
        this.putWriteBufferRect(writeBuffer, originX, originY, originZ, hostX, hostY, hostZ, rangeX, rangeY, rangeZ, 0L, 0L, 0L, 0L, blockingWrite, condition, events);
        return this;
    }

    public CLCommandQueue putWriteBufferRect(CLBuffer<?> writeBuffer, int originX, int originY, int originZ, int hostX, int hostY, int hostZ, int rangeX, int rangeY, int rangeZ, long rowPitch, long slicePitch, long hostRowPitch, long hostSlicePitch, boolean blockingWrite, CLEventList condition, CLEventList events) {
        PointerBuffer conditionIDs = null;
        int conditions = 0;
        if (condition != null) {
            conditionIDs = condition.IDsView;
            conditions = condition.size;
        }
        CLCommandQueue.copy2NIO(this.ibA, originX, originY, originZ);
        CLCommandQueue.copy2NIO(this.ibB, hostX, hostY, hostZ);
        CLCommandQueue.copy2NIO(this.ibC, rangeX, rangeY, rangeZ);
        int ret = this.cl.clEnqueueWriteBufferRect(this.ID, writeBuffer.ID, CLUtil.clBoolean(blockingWrite), this.ibA, this.ibB, this.ibC, rowPitch, slicePitch, hostRowPitch, hostSlicePitch, (Buffer)writeBuffer.getBuffer(), conditions, conditionIDs, events == null ? null : events.IDs);
        if (ret != 0) {
            throw CLException.newException(ret, this.bufferRectToString("write", writeBuffer, rowPitch, slicePitch, hostRowPitch, hostSlicePitch, originX, originY, originZ, hostX, hostY, hostZ, rangeX, rangeY, rangeZ, condition, events));
        }
        if (events != null) {
            events.createEvent(this.context);
        }
        return this;
    }

    public CLCommandQueue putReadBufferRect(CLBuffer<?> readBuffer, int originX, int originY, int hostX, int hostY, int rangeX, int rangeY, boolean blockingRead, CLEventList condition, CLEventList events) {
        this.putReadBufferRect(readBuffer, originX, originY, hostX, hostY, rangeX, rangeY, 0L, 0L, 0L, 0L, blockingRead, condition, events);
        return this;
    }

    public CLCommandQueue putReadBufferRect(CLBuffer<?> readBuffer, int originX, int originY, int hostX, int hostY, int rangeX, int rangeY, long rowPitch, long slicePitch, long hostRowPitch, long hostSlicePitch, boolean blockingRead, CLEventList condition, CLEventList events) {
        this.putReadBufferRect(readBuffer, originX, originY, 0, hostX, hostY, 0, rangeX, rangeY, 1, 0L, 0L, 0L, 0L, blockingRead, condition, events);
        return this;
    }

    public CLCommandQueue putReadBufferRect(CLBuffer<?> readBuffer, int originX, int originY, int originZ, int hostX, int hostY, int hostZ, int rangeX, int rangeY, int rangeZ, boolean blockingRead, CLEventList condition, CLEventList events) {
        this.putReadBufferRect(readBuffer, originX, originY, originZ, hostX, hostY, hostZ, rangeX, rangeY, rangeZ, 0L, 0L, 0L, 0L, blockingRead, condition, events);
        return this;
    }

    public CLCommandQueue putReadBufferRect(CLBuffer<?> readBuffer, int originX, int originY, int originZ, int hostX, int hostY, int hostZ, int rangeX, int rangeY, int rangeZ, long rowPitch, long slicePitch, long hostRowPitch, long hostSlicePitch, boolean blockingRead, CLEventList condition, CLEventList events) {
        PointerBuffer conditionIDs = null;
        int conditions = 0;
        if (condition != null) {
            conditionIDs = condition.IDsView;
            conditions = condition.size;
        }
        CLCommandQueue.copy2NIO(this.ibA, originX, originY, originZ);
        CLCommandQueue.copy2NIO(this.ibB, hostX, hostY, hostZ);
        CLCommandQueue.copy2NIO(this.ibC, rangeX, rangeY, rangeZ);
        int ret = this.cl.clEnqueueReadBufferRect(this.ID, readBuffer.ID, CLUtil.clBoolean(blockingRead), this.ibA, this.ibB, this.ibC, rowPitch, slicePitch, hostRowPitch, hostSlicePitch, (Buffer)readBuffer.getBuffer(), conditions, conditionIDs, events == null ? null : events.IDs);
        if (ret != 0) {
            throw CLException.newException(ret, this.bufferRectToString("read", readBuffer, rowPitch, slicePitch, hostRowPitch, hostSlicePitch, originX, originY, originZ, hostX, hostY, hostZ, rangeX, rangeY, rangeZ, condition, events));
        }
        if (events != null) {
            events.createEvent(this.context);
        }
        return this;
    }

    public CLCommandQueue putCopyBufferRect(CLBuffer<?> src, CLBuffer<?> dest, int srcOriginX, int srcOriginY, int destOriginX, int destOriginY, int rangeX, int rangeY, CLEventList condition, CLEventList events) {
        this.putCopyBufferRect(src, dest, srcOriginX, srcOriginY, 0, destOriginX, destOriginY, 0, rangeX, rangeY, 1, 0L, 0L, 0L, 0L, condition, events);
        return this;
    }

    public CLCommandQueue putCopyBufferRect(CLBuffer<?> src, CLBuffer<?> dest, int srcOriginX, int srcOriginY, int destOriginX, int destOriginY, int rangeX, int rangeY, long srcRowPitch, long srcSlicePitch, long destRowPitch, long destSlicePitch, CLEventList condition, CLEventList events) {
        this.putCopyBufferRect(src, dest, srcOriginX, srcOriginY, 0, destOriginX, destOriginY, 0, rangeX, rangeY, 1, srcRowPitch, srcSlicePitch, destSlicePitch, destRowPitch, condition, events);
        return this;
    }

    public CLCommandQueue putCopyBufferRect(CLBuffer<?> src, CLBuffer<?> dest, int srcOriginX, int srcOriginY, int srcOriginZ, int destOriginX, int destOriginY, int destOriginZ, int rangeX, int rangeY, int rangeZ, CLEventList condition, CLEventList events) {
        this.putCopyBufferRect(src, dest, srcOriginX, srcOriginY, srcOriginZ, destOriginX, destOriginY, destOriginZ, rangeX, rangeY, rangeZ, 0L, 0L, 0L, 0L, condition, events);
        return this;
    }

    public CLCommandQueue putCopyBufferRect(CLBuffer<?> src, CLBuffer<?> dest, int srcOriginX, int srcOriginY, int srcOriginZ, int destOriginX, int destOriginY, int destOriginZ, int rangeX, int rangeY, int rangeZ, long srcRowPitch, long srcSlicePitch, long destRowPitch, long destSlicePitch, CLEventList condition, CLEventList events) {
        PointerBuffer conditionIDs = null;
        int conditions = 0;
        if (condition != null) {
            conditionIDs = condition.IDsView;
            conditions = condition.size;
        }
        CLCommandQueue.copy2NIO(this.ibA, srcOriginX, srcOriginY, srcOriginZ);
        CLCommandQueue.copy2NIO(this.ibB, destOriginX, destOriginY, destOriginZ);
        CLCommandQueue.copy2NIO(this.ibC, rangeX, rangeY, rangeZ);
        int ret = this.cl.clEnqueueCopyBufferRect(this.ID, src.ID, dest.ID, this.ibA, this.ibB, this.ibC, srcRowPitch, srcSlicePitch, destRowPitch, destSlicePitch, conditions, conditionIDs, events == null ? null : events.IDs);
        if (ret != 0) {
            throw CLException.newException(ret, "can not enqueue copy-buffer-rect from " + src + " to " + dest + "\n" + " with srcRowPitch: " + srcRowPitch + " srcSlicePitch: " + srcSlicePitch + " destRowPitch: " + destRowPitch + " destSlicePitch: " + destSlicePitch + "\n" + " srcOrigin: " + this.toStr(srcOriginX, srcOriginY, srcOriginZ) + " destOrigin: " + this.toStr(destOriginX, destOriginY, destOriginZ) + " range: " + this.toStr(rangeX, rangeY, rangeZ) + CLCommandQueue.toStr(condition, events));
        }
        if (events != null) {
            events.createEvent(this.context);
        }
        return this;
    }

    public CLCommandQueue putWriteImage(CLImage2d<?> writeImage, boolean blockingWrite) {
        return this.putWriteImage(writeImage, 0, 0, 0, writeImage.width, writeImage.height, blockingWrite, null, null);
    }

    public CLCommandQueue putWriteImage(CLImage2d<?> writeImage, boolean blockingWrite, CLEventList events) {
        return this.putWriteImage(writeImage, 0, 0, 0, writeImage.width, writeImage.height, blockingWrite, null, events);
    }

    public CLCommandQueue putWriteImage(CLImage2d<?> writeImage, boolean blockingWrite, CLEventList condition, CLEventList events) {
        return this.putWriteImage(writeImage, 0, 0, 0, writeImage.width, writeImage.height, blockingWrite, condition, events);
    }

    public CLCommandQueue putWriteImage(CLImage2d<?> writeImage, int inputRowPitch, int originX, int originY, int rangeX, int rangeY, boolean blockingWrite) {
        return this.putWriteImage(writeImage, inputRowPitch, originX, originY, rangeX, rangeY, blockingWrite, null, null);
    }

    public CLCommandQueue putWriteImage(CLImage2d<?> writeImage, int inputRowPitch, int originX, int originY, int rangeX, int rangeY, boolean blockingWrite, CLEventList condition, CLEventList events) {
        PointerBuffer conditionIDs = null;
        int conditions = 0;
        if (condition != null) {
            conditionIDs = condition.IDsView;
            conditions = condition.size;
        }
        CLCommandQueue.copy2NIO(this.ibA, originX, originY, 0L);
        CLCommandQueue.copy2NIO(this.ibB, rangeX, rangeY, 1L);
        int ret = this.cl.clEnqueueWriteImage(this.ID, writeImage.ID, CLUtil.clBoolean(blockingWrite), this.ibA, this.ibB, inputRowPitch, 0L, writeImage.buffer, conditions, conditionIDs, events == null ? null : events.IDs);
        if (ret != 0) {
            throw CLException.newException(ret, "can not enqueue write-image " + writeImage + " with inputRowPitch: " + inputRowPitch + " origin: " + this.toStr(originX, originY) + " range: " + this.toStr(rangeX, rangeY) + CLCommandQueue.toStr(condition, events));
        }
        if (events != null) {
            events.createEvent(this.context);
        }
        return this;
    }

    public CLCommandQueue putWriteImage(CLImage3d<?> writeImage, boolean blockingWrite) {
        return this.putWriteImage(writeImage, 0, 0, 0, 0, 0, writeImage.width, writeImage.height, writeImage.depth, blockingWrite, null, null);
    }

    public CLCommandQueue putWriteImage(CLImage3d<?> writeImage, boolean blockingWrite, CLEventList events) {
        return this.putWriteImage(writeImage, 0, 0, 0, 0, 0, writeImage.width, writeImage.height, writeImage.depth, blockingWrite, null, events);
    }

    public CLCommandQueue putWriteImage(CLImage3d<?> writeImage, boolean blockingWrite, CLEventList condition, CLEventList events) {
        return this.putWriteImage(writeImage, 0, 0, 0, 0, 0, writeImage.width, writeImage.height, writeImage.depth, blockingWrite, condition, events);
    }

    public CLCommandQueue putWriteImage(CLImage3d<?> writeImage, int inputRowPitch, int inputSlicePitch, int originX, int originY, int originZ, int rangeX, int rangeY, int rangeZ, boolean blockingWrite) {
        return this.putWriteImage(writeImage, inputRowPitch, inputSlicePitch, originX, originY, originZ, rangeX, rangeY, rangeZ, blockingWrite, null, null);
    }

    public CLCommandQueue putWriteImage(CLImage3d<?> writeImage, int inputRowPitch, int inputSlicePitch, int originX, int originY, int originZ, int rangeX, int rangeY, int rangeZ, boolean blockingWrite, CLEventList condition, CLEventList events) {
        PointerBuffer conditionIDs = null;
        int conditions = 0;
        if (condition != null) {
            conditionIDs = condition.IDsView;
            conditions = condition.size;
        }
        CLCommandQueue.copy2NIO(this.ibA, originX, originY, originZ);
        CLCommandQueue.copy2NIO(this.ibB, rangeX, rangeY, rangeZ);
        int ret = this.cl.clEnqueueWriteImage(this.ID, writeImage.ID, CLUtil.clBoolean(blockingWrite), this.ibA, this.ibB, inputRowPitch, inputSlicePitch, writeImage.buffer, conditions, conditionIDs, events == null ? null : events.IDs);
        if (ret != 0) {
            throw CLException.newException(ret, "can not enqueue write-image " + writeImage + " with inputRowPitch: " + inputRowPitch + " inputSlicePitch: " + inputSlicePitch + " origin: " + this.toStr(originX, originY, originZ) + " range: " + this.toStr(rangeX, rangeY, rangeZ) + CLCommandQueue.toStr(condition, events));
        }
        if (events != null) {
            events.createEvent(this.context);
        }
        return this;
    }

    public CLCommandQueue putReadImage(CLImage2d<?> readImage, boolean blockingRead) {
        return this.putReadImage(readImage, 0, 0, 0, readImage.width, readImage.height, blockingRead, null, null);
    }

    public CLCommandQueue putReadImage(CLImage2d<?> readImage, boolean blockingRead, CLEventList events) {
        return this.putReadImage(readImage, 0, 0, 0, readImage.width, readImage.height, blockingRead, null, events);
    }

    public CLCommandQueue putReadImage(CLImage2d<?> readImage, boolean blockingRead, CLEventList condition, CLEventList events) {
        return this.putReadImage(readImage, 0, 0, 0, readImage.width, readImage.height, blockingRead, condition, events);
    }

    public CLCommandQueue putReadImage(CLImage2d<?> readImage, int inputRowPitch, int originX, int originY, int rangeX, int rangeY, boolean blockingRead) {
        return this.putReadImage(readImage, inputRowPitch, originX, originY, rangeX, rangeY, blockingRead, null, null);
    }

    public CLCommandQueue putReadImage(CLImage2d<?> readImage, int inputRowPitch, int originX, int originY, int rangeX, int rangeY, boolean blockingRead, CLEventList condition, CLEventList events) {
        PointerBuffer conditionIDs = null;
        int conditions = 0;
        if (condition != null) {
            conditionIDs = condition.IDsView;
            conditions = condition.size;
        }
        CLCommandQueue.copy2NIO(this.ibA, originX, originY, 0L);
        CLCommandQueue.copy2NIO(this.ibB, rangeX, rangeY, 1L);
        int ret = this.cl.clEnqueueReadImage(this.ID, readImage.ID, CLUtil.clBoolean(blockingRead), this.ibA, this.ibB, inputRowPitch, 0L, readImage.buffer, conditions, conditionIDs, events == null ? null : events.IDs);
        if (ret != 0) {
            throw CLException.newException(ret, "can not enqueue read-image " + readImage + " with inputRowPitch: " + inputRowPitch + " origin: " + this.toStr(originX, originY) + " range: " + this.toStr(rangeX, rangeY) + CLCommandQueue.toStr(condition, events));
        }
        if (events != null) {
            events.createEvent(this.context);
        }
        return this;
    }

    public CLCommandQueue putReadImage(CLImage3d<?> readImage, boolean blockingRead) {
        return this.putReadImage(readImage, 0, 0, 0, 0, 0, readImage.width, readImage.height, readImage.depth, blockingRead, null, null);
    }

    public CLCommandQueue putReadImage(CLImage3d<?> readImage, boolean blockingRead, CLEventList events) {
        return this.putReadImage(readImage, 0, 0, 0, 0, 0, readImage.width, readImage.height, readImage.depth, blockingRead, null, events);
    }

    public CLCommandQueue putReadImage(CLImage3d<?> readImage, boolean blockingRead, CLEventList condition, CLEventList events) {
        return this.putReadImage(readImage, 0, 0, 0, 0, 0, readImage.width, readImage.height, readImage.depth, blockingRead, condition, events);
    }

    public CLCommandQueue putReadImage(CLImage3d<?> readImage, int inputRowPitch, int inputSlicePitch, int originX, int originY, int originZ, int rangeX, int rangeY, int rangeZ, boolean blockingRead) {
        return this.putReadImage(readImage, inputRowPitch, inputSlicePitch, originX, originY, originZ, rangeX, rangeY, rangeZ, blockingRead, null, null);
    }

    public CLCommandQueue putReadImage(CLImage3d<?> readImage, int inputRowPitch, int inputSlicePitch, int originX, int originY, int originZ, int rangeX, int rangeY, int rangeZ, boolean blockingRead, CLEventList condition, CLEventList events) {
        PointerBuffer conditionIDs = null;
        int conditions = 0;
        if (condition != null) {
            conditionIDs = condition.IDsView;
            conditions = condition.size;
        }
        CLCommandQueue.copy2NIO(this.ibA, originX, originY, originZ);
        CLCommandQueue.copy2NIO(this.ibB, rangeX, rangeY, rangeZ);
        int ret = this.cl.clEnqueueReadImage(this.ID, readImage.ID, CLUtil.clBoolean(blockingRead), this.ibA, this.ibB, inputRowPitch, inputSlicePitch, readImage.buffer, conditions, conditionIDs, events == null ? null : events.IDs);
        if (ret != 0) {
            throw CLException.newException(ret, "can not enqueue read-image " + readImage + " with inputRowPitch: " + inputRowPitch + " inputSlicePitch: " + inputSlicePitch + " origin: " + this.toStr(originX, originY, originZ) + " range: " + this.toStr(rangeX, rangeY, rangeZ) + CLCommandQueue.toStr(condition, events));
        }
        if (events != null) {
            events.createEvent(this.context);
        }
        return this;
    }

    public CLCommandQueue putCopyImage(CLImage2d<?> srcImage, CLImage2d<?> dstImage) {
        return this.putCopyImage(srcImage, dstImage, null);
    }

    public CLCommandQueue putCopyImage(CLImage2d<?> srcImage, CLImage2d<?> dstImage, CLEventList events) {
        return this.putCopyImage(srcImage, dstImage, 0, 0, 0, 0, srcImage.width, srcImage.height, null, events);
    }

    public CLCommandQueue putCopyImage(CLImage2d<?> srcImage, CLImage2d<?> dstImage, CLEventList condition, CLEventList events) {
        return this.putCopyImage(srcImage, dstImage, 0, 0, 0, 0, srcImage.width, srcImage.height, condition, events);
    }

    public CLCommandQueue putCopyImage(CLImage2d<?> srcImage, CLImage2d<?> dstImage, int srcOriginX, int srcOriginY, int dstOriginX, int dstOriginY, int rangeX, int rangeY) {
        return this.putCopyImage(srcImage, dstImage, srcOriginX, srcOriginY, dstOriginX, dstOriginY, rangeX, rangeY, null, null);
    }

    public CLCommandQueue putCopyImage(CLImage2d<?> srcImage, CLImage2d<?> dstImage, int srcOriginX, int srcOriginY, int dstOriginX, int dstOriginY, int rangeX, int rangeY, CLEventList condition, CLEventList events) {
        PointerBuffer conditionIDs = null;
        int conditions = 0;
        if (condition != null) {
            conditionIDs = condition.IDsView;
            conditions = condition.size;
        }
        CLCommandQueue.copy2NIO(this.ibA, srcOriginX, srcOriginY, 0L);
        CLCommandQueue.copy2NIO(this.ibB, dstOriginX, dstOriginY, 0L);
        CLCommandQueue.copy2NIO(this.ibC, rangeX, rangeY, 1L);
        int ret = this.cl.clEnqueueCopyImage(this.ID, srcImage.ID, dstImage.ID, this.ibA, this.ibB, this.ibC, conditions, conditionIDs, events == null ? null : events.IDs);
        if (ret != 0) {
            throw CLException.newException(ret, "can not enqueue copy-image " + srcImage + " to " + dstImage + " with srcOrigin: " + this.toStr(srcOriginX, srcOriginY) + " dstOrigin: " + this.toStr(dstOriginX, dstOriginY) + " range:  " + this.toStr(rangeX, rangeY) + CLCommandQueue.toStr(condition, events));
        }
        if (events != null) {
            events.createEvent(this.context);
        }
        return this;
    }

    public CLCommandQueue putCopyImage(CLImage3d<?> srcImage, CLImage3d<?> dstImage) {
        return this.putCopyImage(srcImage, dstImage, null);
    }

    public CLCommandQueue putCopyImage(CLImage3d<?> srcImage, CLImage3d<?> dstImage, CLEventList events) {
        return this.putCopyImage(srcImage, dstImage, 0, 0, 0, 0, 0, 0, srcImage.width, srcImage.height, srcImage.depth, null, events);
    }

    public CLCommandQueue putCopyImage(CLImage3d<?> srcImage, CLImage3d<?> dstImage, CLEventList condition, CLEventList events) {
        return this.putCopyImage(srcImage, dstImage, 0, 0, 0, 0, 0, 0, srcImage.width, srcImage.height, srcImage.depth, condition, events);
    }

    public CLCommandQueue putCopyImage(CLImage3d<?> srcImage, CLImage3d<?> dstImage, int srcOriginX, int srcOriginY, int srcOriginZ, int dstOriginX, int dstOriginY, int dstOriginZ, int rangeX, int rangeY, int rangeZ) {
        return this.putCopyImage(srcImage, dstImage, srcOriginX, srcOriginY, srcOriginZ, dstOriginX, dstOriginY, dstOriginZ, rangeX, rangeY, rangeZ, null, null);
    }

    public CLCommandQueue putCopyImage(CLImage<?> srcImage, CLImage<?> dstImage, int srcOriginX, int srcOriginY, int srcOriginZ, int dstOriginX, int dstOriginY, int dstOriginZ, int rangeX, int rangeY, int rangeZ, CLEventList condition, CLEventList events) {
        PointerBuffer conditionIDs = null;
        int conditions = 0;
        if (condition != null) {
            conditionIDs = condition.IDsView;
            conditions = condition.size;
        }
        CLCommandQueue.copy2NIO(this.ibA, srcOriginX, srcOriginY, srcOriginZ);
        CLCommandQueue.copy2NIO(this.ibB, dstOriginX, dstOriginY, dstOriginZ);
        CLCommandQueue.copy2NIO(this.ibC, rangeX, rangeY, rangeZ);
        int ret = this.cl.clEnqueueCopyImage(this.ID, srcImage.ID, dstImage.ID, this.ibA, this.ibB, this.ibC, conditions, conditionIDs, events == null ? null : events.IDs);
        if (ret != 0) {
            throw CLException.newException(ret, "can not enqueue copy-image " + srcImage + " to " + dstImage + " with srcOrigin: " + this.toStr(srcOriginX, srcOriginY, srcOriginZ) + " dstOrigin: " + this.toStr(dstOriginX, dstOriginY, dstOriginZ) + " range:  " + this.toStr(rangeX, rangeY, rangeZ) + CLCommandQueue.toStr(condition, events));
        }
        if (events != null) {
            events.createEvent(this.context);
        }
        return this;
    }

    public CLCommandQueue putCopyBufferToImage(CLBuffer<?> srcBuffer, CLImage2d<?> dstImage) {
        return this.putCopyBufferToImage(srcBuffer, dstImage, null);
    }

    public CLCommandQueue putCopyBufferToImage(CLBuffer<?> srcBuffer, CLImage2d<?> dstImage, CLEventList events) {
        return this.putCopyBufferToImage(srcBuffer, dstImage, 0L, 0, 0, dstImage.width, dstImage.height, null, events);
    }

    public CLCommandQueue putCopyBufferToImage(CLBuffer<?> srcBuffer, CLImage2d<?> dstImage, CLEventList condition, CLEventList events) {
        return this.putCopyBufferToImage(srcBuffer, dstImage, 0L, 0, 0, dstImage.width, dstImage.height, condition, events);
    }

    public CLCommandQueue putCopyBufferToImage(CLBuffer<?> srcBuffer, CLImage2d<?> dstImage, long srcOffset, int dstOriginX, int dstOriginY, int rangeX, int rangeY) {
        return this.putCopyBufferToImage(srcBuffer, dstImage, srcOffset, dstOriginX, dstOriginY, rangeX, rangeY, null, null);
    }

    public CLCommandQueue putCopyBufferToImage(CLBuffer<?> srcBuffer, CLImage2d<?> dstImage, long srcOffset, int dstOriginX, int dstOriginY, int rangeX, int rangeY, CLEventList condition, CLEventList events) {
        PointerBuffer conditionIDs = null;
        int conditions = 0;
        if (condition != null) {
            conditionIDs = condition.IDsView;
            conditions = condition.size;
        }
        CLCommandQueue.copy2NIO(this.ibA, dstOriginX, dstOriginY, 0L);
        CLCommandQueue.copy2NIO(this.ibB, rangeX, rangeY, 1L);
        int ret = this.cl.clEnqueueCopyBufferToImage(this.ID, srcBuffer.ID, dstImage.ID, srcOffset, this.ibA, this.ibB, conditions, conditionIDs, events == null ? null : events.IDs);
        if (ret != 0) {
            throw CLException.newException(ret, "can not enqueue a copy from " + srcBuffer + " to " + dstImage + " with srcOffset: " + srcOffset + " dstOrigin: " + this.toStr(dstOriginX, dstOriginY) + " range:  " + this.toStr(rangeX, rangeY) + CLCommandQueue.toStr(condition, events));
        }
        if (events != null) {
            events.createEvent(this.context);
        }
        return this;
    }

    public CLCommandQueue putCopyBufferToImage(CLBuffer<?> srcBuffer, CLImage3d<?> dstImage) {
        return this.putCopyBufferToImage(srcBuffer, dstImage, null);
    }

    public CLCommandQueue putCopyBufferToImage(CLBuffer<?> srcBuffer, CLImage3d<?> dstImage, CLEventList events) {
        return this.putCopyBufferToImage(srcBuffer, dstImage, 0L, 0, 0, 0, dstImage.width, dstImage.height, dstImage.depth, null, events);
    }

    public CLCommandQueue putCopyBufferToImage(CLBuffer<?> srcBuffer, CLImage3d<?> dstImage, CLEventList condition, CLEventList events) {
        return this.putCopyBufferToImage(srcBuffer, dstImage, 0L, 0, 0, 0, dstImage.width, dstImage.height, dstImage.depth, condition, events);
    }

    public CLCommandQueue putCopyBufferToImage(CLBuffer<?> srcBuffer, CLImage3d<?> dstImage, long srcOffset, int dstOriginX, int dstOriginY, int dstOriginZ, int rangeX, int rangeY, int rangeZ) {
        return this.putCopyBufferToImage(srcBuffer, dstImage, srcOffset, dstOriginX, dstOriginY, dstOriginZ, rangeX, rangeY, rangeZ, null, null);
    }

    public CLCommandQueue putCopyBufferToImage(CLBuffer<?> srcBuffer, CLImage3d<?> dstImage, long srcOffset, int dstOriginX, int dstOriginY, int dstOriginZ, int rangeX, int rangeY, int rangeZ, CLEventList condition, CLEventList events) {
        PointerBuffer conditionIDs = null;
        int conditions = 0;
        if (condition != null) {
            conditionIDs = condition.IDsView;
            conditions = condition.size;
        }
        CLCommandQueue.copy2NIO(this.ibA, dstOriginX, dstOriginY, dstOriginZ);
        CLCommandQueue.copy2NIO(this.ibB, rangeX, rangeY, rangeZ);
        int ret = this.cl.clEnqueueCopyBufferToImage(this.ID, srcBuffer.ID, dstImage.ID, srcOffset, this.ibA, this.ibB, conditions, conditionIDs, events == null ? null : events.IDs);
        if (ret != 0) {
            throw CLException.newException(ret, "can not enqueue a copy from " + srcBuffer + " to " + dstImage + " with srcOffset: " + srcOffset + " dstOrigin: " + this.toStr(dstOriginX, dstOriginY, dstOriginZ) + " range:  " + this.toStr(rangeX, rangeY, dstOriginZ) + CLCommandQueue.toStr(condition, events));
        }
        if (events != null) {
            events.createEvent(this.context);
        }
        return this;
    }

    public CLCommandQueue putCopyImageToBuffer(CLImage2d<?> srcImage, CLBuffer<?> dstBuffer) {
        return this.putCopyImageToBuffer(srcImage, dstBuffer, null);
    }

    public CLCommandQueue putCopyImageToBuffer(CLImage2d<?> srcImage, CLBuffer<?> dstBuffer, CLEventList events) {
        return this.putCopyImageToBuffer(srcImage, dstBuffer, 0, 0, srcImage.width, srcImage.height, 0L, null, events);
    }

    public CLCommandQueue putCopyImageToBuffer(CLImage2d<?> srcImage, CLBuffer<?> dstBuffer, CLEventList condition, CLEventList events) {
        return this.putCopyImageToBuffer(srcImage, dstBuffer, 0, 0, srcImage.width, srcImage.height, 0L, condition, events);
    }

    public CLCommandQueue putCopyImageToBuffer(CLImage2d<?> srcImage, CLBuffer<?> dstBuffer, int srcOriginX, int srcOriginY, int rangeX, int rangeY, long dstOffset) {
        return this.putCopyImageToBuffer(srcImage, dstBuffer, srcOriginX, srcOriginY, rangeX, rangeY, dstOffset, null, null);
    }

    public CLCommandQueue putCopyImageToBuffer(CLImage2d<?> srcImage, CLBuffer<?> dstBuffer, int srcOriginX, int srcOriginY, int rangeX, int rangeY, long dstOffset, CLEventList condition, CLEventList events) {
        PointerBuffer conditionIDs = null;
        int conditions = 0;
        if (condition != null) {
            conditionIDs = condition.IDsView;
            conditions = condition.size;
        }
        CLCommandQueue.copy2NIO(this.ibA, srcOriginX, srcOriginY, 0L);
        CLCommandQueue.copy2NIO(this.ibB, rangeX, rangeY, 1L);
        int ret = this.cl.clEnqueueCopyImageToBuffer(this.ID, dstBuffer.ID, srcImage.ID, this.ibA, this.ibB, dstOffset, conditions, conditionIDs, events == null ? null : events.IDs);
        if (ret != 0) {
            throw CLException.newException(ret, "can not enqueue a copy from " + srcImage + " to " + dstBuffer + " with srcOrigin: " + this.toStr(srcOriginX, srcOriginY) + " range: " + this.toStr(rangeX, rangeY) + " dstOffset: " + dstOffset + CLCommandQueue.toStr(condition, events));
        }
        if (events != null) {
            events.createEvent(this.context);
        }
        return this;
    }

    public CLCommandQueue putCopyImageToBuffer(CLImage3d<?> srcImage, CLBuffer<?> dstBuffer) {
        return this.putCopyImageToBuffer(srcImage, dstBuffer, 0, 0, 0, srcImage.width, srcImage.height, srcImage.depth, 0L, null, null);
    }

    public CLCommandQueue putCopyImageToBuffer(CLImage3d<?> srcImage, CLBuffer<?> dstBuffer, CLEventList events) {
        return this.putCopyImageToBuffer(srcImage, dstBuffer, 0, 0, 0, srcImage.width, srcImage.height, srcImage.depth, 0L, null, events);
    }

    public CLCommandQueue putCopyImageToBuffer(CLImage3d<?> srcImage, CLBuffer<?> dstBuffer, CLEventList condition, CLEventList events) {
        return this.putCopyImageToBuffer(srcImage, dstBuffer, 0, 0, 0, srcImage.width, srcImage.height, srcImage.depth, 0L, condition, events);
    }

    public CLCommandQueue putCopyImageToBuffer(CLImage3d<?> srcImage, CLBuffer<?> dstBuffer, int srcOriginX, int srcOriginY, int srcOriginZ, int rangeX, int rangeY, int rangeZ, long dstOffset) {
        return this.putCopyImageToBuffer(srcImage, dstBuffer, srcOriginX, srcOriginY, srcOriginZ, rangeX, rangeY, rangeZ, dstOffset, null, null);
    }

    public CLCommandQueue putCopyImageToBuffer(CLImage3d<?> srcImage, CLBuffer<?> dstBuffer, int srcOriginX, int srcOriginY, int srcOriginZ, int rangeX, int rangeY, int rangeZ, long dstOffset, CLEventList condition, CLEventList events) {
        PointerBuffer conditionIDs = null;
        int conditions = 0;
        if (condition != null) {
            conditionIDs = condition.IDsView;
            conditions = condition.size;
        }
        CLCommandQueue.copy2NIO(this.ibA, srcOriginX, srcOriginY, srcOriginZ);
        CLCommandQueue.copy2NIO(this.ibB, rangeX, rangeY, rangeZ);
        int ret = this.cl.clEnqueueCopyImageToBuffer(this.ID, dstBuffer.ID, srcImage.ID, this.ibA, this.ibB, dstOffset, conditions, conditionIDs, events == null ? null : events.IDs);
        if (ret != 0) {
            throw CLException.newException(ret, "can not enqueue a copy from " + srcImage + " to " + dstBuffer + " with srcOrigin: " + this.toStr(srcOriginX, srcOriginY, srcOriginZ) + " range: " + this.toStr(rangeX, rangeY, rangeZ) + " dstOffset: " + dstOffset + CLCommandQueue.toStr(condition, events));
        }
        if (events != null) {
            events.createEvent(this.context);
        }
        return this;
    }

    public ByteBuffer putMapBuffer(CLBuffer<?> buffer, CLMemory.Map flag, boolean blockingMap) {
        return this.putMapBuffer(buffer, flag, blockingMap, null);
    }

    public ByteBuffer putMapBuffer(CLBuffer<?> buffer, CLMemory.Map flag, boolean blockingMap, CLEventList events) {
        return this.putMapBuffer(buffer, flag, 0L, buffer.getCLSize(), blockingMap, null, events);
    }

    public ByteBuffer putMapBuffer(CLBuffer<?> buffer, CLMemory.Map flag, boolean blockingMap, CLEventList condition, CLEventList events) {
        return this.putMapBuffer(buffer, flag, 0L, buffer.getCLSize(), blockingMap, condition, events);
    }

    public ByteBuffer putMapBuffer(CLBuffer<?> buffer, CLMemory.Map flag, long offset, long length, boolean blockingMap) {
        return this.putMapBuffer(buffer, flag, offset, length, blockingMap, null, null);
    }

    public ByteBuffer putMapBuffer(CLBuffer<?> buffer, CLMemory.Map flag, long offset, long length, boolean blockingMap, CLEventList condition, CLEventList events) {
        PointerBuffer conditionIDs = null;
        int conditions = 0;
        if (condition != null) {
            conditionIDs = condition.IDsView;
            conditions = condition.size;
        }
        IntBuffer error = this.pbA;
        ByteBuffer mappedBuffer = this.cl.clEnqueueMapBuffer(this.ID, buffer.ID, CLUtil.clBoolean(blockingMap), flag.FLAGS, offset, length, conditions, conditionIDs, events == null ? null : events.IDs, error);
        if (error.get(0) != 0) {
            throw CLException.newException(error.get(0), "can not map " + buffer + " with: " + (Object)((Object)flag) + " offset: " + offset + " lenght: " + length + CLCommandQueue.toStr(condition, events));
        }
        if (events != null) {
            events.createEvent(this.context);
        }
        return mappedBuffer;
    }

    public ByteBuffer putMapImage(CLImage2d<?> image, CLMemory.Map flag, boolean blockingMap) {
        return this.putMapImage(image, flag, blockingMap, null);
    }

    public ByteBuffer putMapImage(CLImage2d<?> image, CLMemory.Map flag, boolean blockingMap, CLEventList events) {
        return this.putMapImage(image, flag, 0, 0, image.width, image.height, blockingMap, null, events);
    }

    public ByteBuffer putMapImage(CLImage2d<?> image, CLMemory.Map flag, boolean blockingMap, CLEventList condition, CLEventList events) {
        return this.putMapImage(image, flag, 0, 0, image.width, image.height, blockingMap, condition, events);
    }

    public ByteBuffer putMapImage(CLImage2d<?> buffer, CLMemory.Map flag, int offsetX, int offsetY, int rangeX, int rangeY, boolean blockingMap) {
        return this.putMapImage(buffer, flag, offsetX, offsetY, rangeX, rangeY, blockingMap, null, null);
    }

    public ByteBuffer putMapImage(CLImage2d<?> image, CLMemory.Map flag, int offsetX, int offsetY, int rangeX, int rangeY, boolean blockingMap, CLEventList condition, CLEventList events) {
        PointerBuffer conditionIDs = null;
        int conditions = 0;
        if (condition != null) {
            conditionIDs = condition.IDsView;
            conditions = condition.size;
        }
        IntBuffer error = this.pbA;
        CLCommandQueue.copy2NIO(this.ibB, offsetX, offsetY, 0L);
        CLCommandQueue.copy2NIO(this.ibC, rangeX, rangeY, 1L);
        ByteBuffer mappedImage = this.cl.clEnqueueMapImage(this.ID, image.ID, CLUtil.clBoolean(blockingMap), flag.FLAGS, this.ibB, this.ibC, null, null, conditions, conditionIDs, events == null ? null : events.IDs, error);
        if (error.get(0) != 0) {
            throw CLException.newException(error.get(0), "can not map " + image + " with: " + (Object)((Object)flag) + " offset: " + this.toStr(offsetX, offsetY) + " range: " + this.toStr(rangeX, rangeY) + CLCommandQueue.toStr(condition, events));
        }
        if (events != null) {
            events.createEvent(this.context);
        }
        return mappedImage;
    }

    public ByteBuffer putMapImage(CLImage3d<?> image, CLMemory.Map flag, boolean blockingMap) {
        return this.putMapImage(image, flag, blockingMap, null);
    }

    public ByteBuffer putMapImage(CLImage3d<?> image, CLMemory.Map flag, boolean blockingMap, CLEventList events) {
        return this.putMapImage(image, flag, 0, 0, 0, image.width, image.height, image.depth, blockingMap, null, events);
    }

    public ByteBuffer putMapImage(CLImage3d<?> image, CLMemory.Map flag, boolean blockingMap, CLEventList condition, CLEventList events) {
        return this.putMapImage(image, flag, 0, 0, 0, image.width, image.height, image.depth, blockingMap, condition, events);
    }

    public ByteBuffer putMapImage(CLImage3d<?> image, CLMemory.Map flag, int offsetX, int offsetY, int offsetZ, int rangeX, int rangeY, int rangeZ, boolean blockingMap) {
        return this.putMapImage(image, flag, offsetX, offsetY, offsetZ, rangeX, rangeY, rangeZ, blockingMap, null, null);
    }

    public ByteBuffer putMapImage(CLImage3d<?> image, CLMemory.Map flag, int offsetX, int offsetY, int offsetZ, int rangeX, int rangeY, int rangeZ, boolean blockingMap, CLEventList condition, CLEventList events) {
        PointerBuffer conditionIDs = null;
        int conditions = 0;
        if (condition != null) {
            conditionIDs = condition.IDsView;
            conditions = condition.size;
        }
        IntBuffer error = this.pbA;
        CLCommandQueue.copy2NIO(this.ibB, offsetX, offsetY, offsetZ);
        CLCommandQueue.copy2NIO(this.ibC, rangeX, rangeY, rangeZ);
        ByteBuffer mappedImage = this.cl.clEnqueueMapImage(this.ID, image.ID, CLUtil.clBoolean(blockingMap), flag.FLAGS, this.ibB, this.ibC, null, null, conditions, conditionIDs, events == null ? null : events.IDs, error);
        if (error.get(0) != 0) {
            throw CLException.newException(error.get(0), "can not map " + image + " with: " + (Object)((Object)flag) + " offset: " + this.toStr(offsetX, offsetY, offsetZ) + " range: " + this.toStr(rangeX, rangeY, rangeZ) + CLCommandQueue.toStr(condition, events));
        }
        if (events != null) {
            events.createEvent(this.context);
        }
        return mappedImage;
    }

    public CLCommandQueue putUnmapMemory(CLMemory<?> memory, Buffer mapped) {
        return this.putUnmapMemory(memory, mapped, null, null);
    }

    public CLCommandQueue putUnmapMemory(CLMemory<?> memory, Buffer mapped, CLEventList events) {
        return this.putUnmapMemory(memory, mapped, null, events);
    }

    public CLCommandQueue putUnmapMemory(CLMemory<?> memory, Buffer mapped, CLEventList condition, CLEventList events) {
        int ret;
        PointerBuffer conditionIDs = null;
        int conditions = 0;
        if (condition != null) {
            conditionIDs = condition.IDsView;
            conditions = condition.size;
        }
        if ((ret = this.cl.clEnqueueUnmapMemObject(this.ID, memory.ID, mapped, conditions, conditionIDs, events == null ? null : events.IDs)) != 0) {
            throw CLException.newException(ret, "can not unmap " + memory + CLCommandQueue.toStr(condition, events));
        }
        if (events != null) {
            events.createEvent(this.context);
        }
        return this;
    }

    public CLCommandQueue putMarker(CLEventList events) {
        int ret = this.cl.clEnqueueMarker(this.ID, events.IDs);
        if (ret != 0) {
            throw CLException.newException(ret, "can not enqueue marker " + events);
        }
        events.createEvent(this.context);
        return this;
    }

    public CLCommandQueue putWaitForEvent(CLEventList list, int index, boolean blockingWait) {
        if (blockingWait) {
            list.waitForEvent(index);
        } else {
            PointerBuffer ids = list.getEventBuffer(index);
            int ret = this.cl.clEnqueueWaitForEvents(this.ID, 1, ids);
            if (ret != 0) {
                throw CLException.newException(ret, "can not " + (blockingWait ? "blocking" : "") + " wait for event #" + index + " in " + list);
            }
        }
        return this;
    }

    public CLCommandQueue putWaitForEvents(CLEventList list, boolean blockingWait) {
        if (blockingWait) {
            list.waitForEvents();
        } else {
            int ret = this.cl.clEnqueueWaitForEvents(this.ID, list.size, list.IDsView);
            if (ret != 0) {
                throw CLException.newException(ret, "can not " + (blockingWait ? "blocking" : "") + " wait for events " + list);
            }
        }
        return this;
    }

    public CLCommandQueue putBarrier() {
        int ret = this.cl.clEnqueueBarrier(this.ID);
        CLException.checkForError(ret, "can not enqueue Barrier");
        return this;
    }

    public CLCommandQueue putTask(CLKernel kernel) {
        this.putTask(kernel, null, null);
        return this;
    }

    public CLCommandQueue putTask(CLKernel kernel, CLEventList events) {
        this.putTask(kernel, null, events);
        return this;
    }

    public CLCommandQueue putTask(CLKernel kernel, CLEventList condition, CLEventList events) {
        int ret;
        PointerBuffer conditionIDs = null;
        int conditions = 0;
        if (condition != null) {
            conditionIDs = condition.IDsView;
            conditions = condition.size;
        }
        if ((ret = this.cl.clEnqueueTask(this.ID, kernel.ID, conditions, conditionIDs, events == null ? null : events.IDs)) != 0) {
            CLException.checkForError(ret, "can not enqueue Task: " + kernel + CLCommandQueue.toStr(condition, events));
        }
        if (events != null) {
            events.createEvent(this.context);
        }
        return this;
    }

    public CLCommandQueue put1DRangeKernel(CLKernel kernel, long globalWorkOffset, long globalWorkSize, long localWorkSize) {
        this.put1DRangeKernel(kernel, globalWorkOffset, globalWorkSize, localWorkSize, null, null);
        return this;
    }

    public CLCommandQueue put1DRangeKernel(CLKernel kernel, long globalWorkOffset, long globalWorkSize, long localWorkSize, CLEventList events) {
        this.put1DRangeKernel(kernel, globalWorkOffset, globalWorkSize, localWorkSize, null, events);
        return this;
    }

    public CLCommandQueue put1DRangeKernel(CLKernel kernel, long globalWorkOffset, long globalWorkSize, long localWorkSize, CLEventList condition, CLEventList events) {
        PointerBuffer globWO = null;
        PointerBuffer globWS = null;
        PointerBuffer locWS = null;
        if (globalWorkOffset != 0L) {
            globWO = CLCommandQueue.copy2NIO(this.ibA, globalWorkOffset);
        }
        if (globalWorkSize != 0L) {
            globWS = CLCommandQueue.copy2NIO(this.ibB, globalWorkSize);
        }
        if (localWorkSize != 0L) {
            locWS = CLCommandQueue.copy2NIO(this.ibC, localWorkSize);
        }
        this.putNDRangeKernel(kernel, 1, globWO, globWS, locWS, condition, events);
        return this;
    }

    public CLCommandQueue put2DRangeKernel(CLKernel kernel, long globalWorkOffsetX, long globalWorkOffsetY, long globalWorkSizeX, long globalWorkSizeY, long localWorkSizeX, long localWorkSizeY) {
        this.put2DRangeKernel(kernel, globalWorkOffsetX, globalWorkOffsetY, globalWorkSizeX, globalWorkSizeY, localWorkSizeX, localWorkSizeY, null, null);
        return this;
    }

    public CLCommandQueue put2DRangeKernel(CLKernel kernel, long globalWorkOffsetX, long globalWorkOffsetY, long globalWorkSizeX, long globalWorkSizeY, long localWorkSizeX, long localWorkSizeY, CLEventList events) {
        this.put2DRangeKernel(kernel, globalWorkOffsetX, globalWorkOffsetY, globalWorkSizeX, globalWorkSizeY, localWorkSizeX, localWorkSizeY, null, events);
        return this;
    }

    public CLCommandQueue put2DRangeKernel(CLKernel kernel, long globalWorkOffsetX, long globalWorkOffsetY, long globalWorkSizeX, long globalWorkSizeY, long localWorkSizeX, long localWorkSizeY, CLEventList condition, CLEventList events) {
        PointerBuffer globalWorkOffset = null;
        PointerBuffer globalWorkSize = null;
        PointerBuffer localWorkSize = null;
        if (globalWorkOffsetX != 0L || globalWorkOffsetY != 0L) {
            globalWorkOffset = CLCommandQueue.copy2NIO(this.ibA, globalWorkOffsetX, globalWorkOffsetY);
        }
        if (globalWorkSizeX != 0L || globalWorkSizeY != 0L) {
            globalWorkSize = CLCommandQueue.copy2NIO(this.ibB, globalWorkSizeX, globalWorkSizeY);
        }
        if (localWorkSizeX != 0L || localWorkSizeY != 0L) {
            localWorkSize = CLCommandQueue.copy2NIO(this.ibC, localWorkSizeX, localWorkSizeY);
        }
        this.putNDRangeKernel(kernel, 2, globalWorkOffset, globalWorkSize, localWorkSize, condition, events);
        return this;
    }

    public CLCommandQueue put3DRangeKernel(CLKernel kernel, long globalWorkOffsetX, long globalWorkOffsetY, long globalWorkOffsetZ, long globalWorkSizeX, long globalWorkSizeY, long globalWorkSizeZ, long localWorkSizeX, long localWorkSizeY, long localWorkSizeZ) {
        this.put3DRangeKernel(kernel, globalWorkOffsetX, globalWorkOffsetY, globalWorkOffsetZ, globalWorkSizeX, globalWorkSizeY, globalWorkSizeZ, localWorkSizeX, localWorkSizeY, localWorkSizeZ, null, null);
        return this;
    }

    public CLCommandQueue put3DRangeKernel(CLKernel kernel, long globalWorkOffsetX, long globalWorkOffsetY, long globalWorkOffsetZ, long globalWorkSizeX, long globalWorkSizeY, long globalWorkSizeZ, long localWorkSizeX, long localWorkSizeY, long localWorkSizeZ, CLEventList events) {
        this.put3DRangeKernel(kernel, globalWorkOffsetX, globalWorkOffsetY, globalWorkOffsetZ, globalWorkSizeX, globalWorkSizeY, globalWorkSizeZ, localWorkSizeX, localWorkSizeY, localWorkSizeZ, null, events);
        return this;
    }

    public CLCommandQueue put3DRangeKernel(CLKernel kernel, long globalWorkOffsetX, long globalWorkOffsetY, long globalWorkOffsetZ, long globalWorkSizeX, long globalWorkSizeY, long globalWorkSizeZ, long localWorkSizeX, long localWorkSizeY, long localWorkSizeZ, CLEventList condition, CLEventList events) {
        PointerBuffer globalWorkOffset = null;
        PointerBuffer globalWorkSize = null;
        PointerBuffer localWorkSize = null;
        if (globalWorkOffsetX != 0L || globalWorkOffsetY != 0L || globalWorkOffsetZ != 0L) {
            globalWorkOffset = CLCommandQueue.copy2NIO(this.ibA, globalWorkOffsetX, globalWorkOffsetY, globalWorkOffsetZ);
        }
        if (globalWorkSizeX != 0L || globalWorkSizeY != 0L || globalWorkSizeZ != 0L) {
            globalWorkSize = CLCommandQueue.copy2NIO(this.ibB, globalWorkSizeX, globalWorkSizeY, globalWorkSizeZ);
        }
        if (localWorkSizeX != 0L || localWorkSizeY != 0L || localWorkSizeZ != 0L) {
            localWorkSize = CLCommandQueue.copy2NIO(this.ibC, localWorkSizeX, localWorkSizeY, localWorkSizeZ);
        }
        this.putNDRangeKernel(kernel, 3, globalWorkOffset, globalWorkSize, localWorkSize, condition, events);
        return this;
    }

    public CLCommandQueue putNDRangeKernel(CLKernel kernel, int workDimension, PointerBuffer globalWorkOffset, PointerBuffer globalWorkSize, PointerBuffer localWorkSize) {
        this.putNDRangeKernel(kernel, workDimension, globalWorkOffset, globalWorkSize, localWorkSize, null, null);
        return this;
    }

    public CLCommandQueue putNDRangeKernel(CLKernel kernel, int workDimension, PointerBuffer globalWorkOffset, PointerBuffer globalWorkSize, PointerBuffer localWorkSize, CLEventList events) {
        this.putNDRangeKernel(kernel, workDimension, globalWorkOffset, globalWorkSize, localWorkSize, null, events);
        return this;
    }

    public CLCommandQueue putNDRangeKernel(CLKernel kernel, int workDimension, PointerBuffer globalWorkOffset, PointerBuffer globalWorkSize, PointerBuffer localWorkSize, CLEventList condition, CLEventList events) {
        int ret;
        PointerBuffer conditionIDs = null;
        int conditions = 0;
        if (condition != null) {
            conditionIDs = condition.IDsView;
            conditions = condition.size;
        }
        if ((ret = this.cl.clEnqueueNDRangeKernel(this.ID, kernel.ID, workDimension, globalWorkOffset, globalWorkSize, localWorkSize, conditions, conditionIDs, events == null ? null : events.IDs)) != 0) {
            throw CLException.newException(ret, "can not enqueue " + workDimension + "DRange " + kernel + "\n" + " with gwo: " + CLCommandQueue.toStr(globalWorkOffset) + " gws: " + CLCommandQueue.toStr(globalWorkSize) + " lws: " + CLCommandQueue.toStr(localWorkSize) + " " + CLCommandQueue.toStr(condition, events));
        }
        if (events != null) {
            events.createEvent(this.context);
        }
        return this;
    }

    public CLCommandQueue putAcquireGLObject(CLGLObject glObject) {
        this.putAcquireGLObject(glObject, null, null);
        return this;
    }

    public CLCommandQueue putAcquireGLObject(CLGLObject glObject, CLEventList events) {
        this.putAcquireGLObject(glObject, null, events);
        return this;
    }

    public CLCommandQueue putAcquireGLObject(CLGLObject glObject, CLEventList condition, CLEventList events) {
        this.putAcquireGLObjects(CLCommandQueue.copy2NIO(this.ibA, glObject.getID()), condition, events);
        return this;
    }

    public CLCommandQueue putAcquireGLObjects(CLGLObject glObject1, CLGLObject glObject2, CLEventList condition, CLEventList events) {
        this.putAcquireGLObjects(CLCommandQueue.copy2NIO(this.ibA, glObject1.getID(), glObject2.getID()), condition, events);
        return this;
    }

    public CLCommandQueue putAcquireGLObjects(CLGLObject glObject1, CLGLObject glObject2, CLGLObject glObject3, CLEventList condition, CLEventList events) {
        this.putAcquireGLObjects(CLCommandQueue.copy2NIO(this.ibA, glObject1.getID(), glObject2.getID(), glObject3.getID()), condition, events);
        return this;
    }

    public CLCommandQueue putAcquireGLObjects(PointerBuffer glObjectIDs, CLEventList condition, CLEventList events) {
        CLGL xl;
        int ret;
        PointerBuffer conditionIDs = null;
        int conditions = 0;
        if (condition != null) {
            conditionIDs = condition.IDsView;
            conditions = condition.size;
        }
        if ((ret = (xl = (CLGL)this.cl).clEnqueueAcquireGLObjects(this.ID, glObjectIDs.remaining(), glObjectIDs, conditions, conditionIDs, events == null ? null : events.IDs)) != 0) {
            throw CLException.newException(ret, "can not aquire " + glObjectIDs + " with " + CLCommandQueue.toStr(condition, events));
        }
        if (events != null) {
            events.createEvent(this.context);
        }
        return this;
    }

    public CLCommandQueue putReleaseGLObject(CLGLObject glObject) {
        this.putReleaseGLObject(glObject, null);
        return this;
    }

    public CLCommandQueue putReleaseGLObject(CLGLObject glObject, CLEventList events) {
        this.putReleaseGLObject(glObject, null, events);
        return this;
    }

    public CLCommandQueue putReleaseGLObject(CLGLObject glObject, CLEventList condition, CLEventList events) {
        this.putReleaseGLObjects(CLCommandQueue.copy2NIO(this.ibA, glObject.getID()), condition, events);
        return this;
    }

    public CLCommandQueue putReleaseGLObjects(CLGLObject glObject1, CLGLObject glObject2, CLEventList condition, CLEventList events) {
        this.putReleaseGLObjects(CLCommandQueue.copy2NIO(this.ibA, glObject1.getID(), glObject2.getID()), condition, events);
        return this;
    }

    public CLCommandQueue putReleaseGLObjects(CLGLObject glObject1, CLGLObject glObject2, CLGLObject glObject3, CLEventList condition, CLEventList events) {
        this.putReleaseGLObjects(CLCommandQueue.copy2NIO(this.ibA, glObject1.getID(), glObject2.getID(), glObject3.getID()), condition, events);
        return this;
    }

    public CLCommandQueue putReleaseGLObjects(PointerBuffer glObjectIDs, CLEventList condition, CLEventList events) {
        CLGL xl;
        int ret;
        PointerBuffer conditionIDs = null;
        int conditions = 0;
        if (condition != null) {
            conditionIDs = condition.IDsView;
            conditions = condition.size;
        }
        if ((ret = (xl = (CLGL)this.cl).clEnqueueReleaseGLObjects(this.ID, glObjectIDs.remaining(), glObjectIDs, conditions, conditionIDs, events == null ? null : events.IDs)) != 0) {
            throw CLException.newException(ret, "can not release " + glObjectIDs + "with " + CLCommandQueue.toStr(condition, events));
        }
        if (events != null) {
            events.createEvent(this.context);
        }
        return this;
    }

    public CLCommandQueue finish() {
        int ret = this.cl.clFinish(this.ID);
        CLException.checkForError(ret, "can not finish command queue");
        return this;
    }

    public CLCommandQueue flush() {
        int ret = this.cl.clFlush(this.ID);
        CLException.checkForError(ret, "can not flush command queue");
        return this;
    }

    public boolean isProfilingEnabled() {
        return ((long)Mode.PROFILING_MODE.QUEUE_MODE & this.properties) != 0L;
    }

    public boolean isOutOfOrderModeEnabled() {
        return ((long)Mode.OUT_OF_ORDER_MODE.QUEUE_MODE & this.properties) != 0L;
    }

    @Override
    public void release() {
        super.release();
        int ret = this.cl.clReleaseCommandQueue(this.ID);
        this.context.onCommandQueueReleased(this.device, this);
        if (ret != 0) {
            throw CLException.newException(ret, "can not release " + this);
        }
    }

    private static PointerBuffer copy2NIO(PointerBuffer buffer, long a) {
        return (PointerBuffer)buffer.put(2, a).position(2);
    }

    private static PointerBuffer copy2NIO(PointerBuffer buffer, long a, long b) {
        return (PointerBuffer)((PointerBuffer)buffer.position(1)).put(a).put(b).position(1);
    }

    private static PointerBuffer copy2NIO(PointerBuffer buffer, long a, long b, long c) {
        return (PointerBuffer)((PointerBuffer)buffer.rewind()).put(a).put(b).put(c).rewind();
    }

    private static String toStr(PointerBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        for (int i = buffer.position(); i < buffer.capacity(); ++i) {
            sb.append(buffer.get(i));
            if (i == buffer.capacity() - 1) continue;
            sb.append(", ");
        }
        return sb.append('}').toString();
    }

    private static String toStr(CLEventList condition, CLEventList events) {
        return "\ncond.: " + condition + " events: " + events;
    }

    private String toStr(Integer ... values) {
        return Arrays.asList(values).toString();
    }

    private String bufferRectToString(String action, CLBuffer<?> buffer, long rowPitch, long slicePitch, long hostRowPitch, long hostSlicePitch, int originX, int originY, int originZ, int hostX, int hostY, int hostZ, int rangeX, int rangeY, int rangeZ, CLEventList condition, CLEventList events) {
        return "can not enqueue " + action + "-buffer-rect: " + buffer + "\n" + " with rowPitch: " + rowPitch + " slicePitch: " + slicePitch + " hostRowPitch: " + hostRowPitch + " hostSlicePitch: " + hostSlicePitch + "\n" + " origin: " + this.toStr(originX, originY, originZ) + " hostPos: " + this.toStr(hostX, hostY, hostZ) + " range: " + this.toStr(rangeX, rangeY, rangeZ) + CLCommandQueue.toStr(condition, events);
    }

    public CLDevice getDevice() {
        return this.device;
    }

    public EnumSet<Mode> getProperties() {
        return Mode.valuesOf(this.properties);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " " + this.getProperties() + " on " + this.getDevice();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CLCommandQueue other = (CLCommandQueue)obj;
        if (this.ID != other.ID) {
            return false;
        }
        if (!(this.context == other.context || this.context != null && this.context.equals(other.context))) {
            return false;
        }
        return this.device == other.device || this.device != null && this.device.equals(other.device);
    }

    public int hashCode() {
        int hash = 3;
        hash = 89 * hash + (int)(this.ID ^ this.ID >>> 32);
        hash = 89 * hash + (this.context != null ? this.context.hashCode() : 0);
        hash = 89 * hash + (this.device != null ? this.device.hashCode() : 0);
        return hash;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        OUT_OF_ORDER_MODE(1),
        PROFILING_MODE(2);

        public final int QUEUE_MODE;

        private Mode(int value) {
            this.QUEUE_MODE = value;
        }

        public static Mode valueOf(int queueMode) {
            switch (queueMode) {
                case 1: {
                    return OUT_OF_ORDER_MODE;
                }
                case 2: {
                    return PROFILING_MODE;
                }
            }
            return null;
        }

        public static EnumSet<Mode> valuesOf(long bitfield) {
            Mode[] values;
            ArrayList<Mode> matching = new ArrayList<Mode>();
            for (Mode value : values = Mode.values()) {
                if (((long)value.QUEUE_MODE & bitfield) == 0L) continue;
                matching.add(value);
            }
            if (matching.isEmpty()) {
                return EnumSet.noneOf(Mode.class);
            }
            return EnumSet.copyOf(matching);
        }
    }
}

