/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl.impl;

import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.opencl.CLException;
import com.jogamp.opencl.impl.CLTLInfoAccessor;
import com.jogamp.opencl.llb.CL;
import com.jogamp.opencl.llb.CLDeviceBinding;
import com.jogamp.opencl.spi.CLAccessorFactory;
import com.jogamp.opencl.spi.CLInfoAccessor;
import com.jogamp.opencl.spi.CLPlatformInfoAccessor;
import java.nio.Buffer;
import java.nio.IntBuffer;

public class CLTLAccessorFactory
implements CLAccessorFactory {
    public CLInfoAccessor createDeviceInfoAccessor(CLDeviceBinding cl, long id) {
        return new CLDeviceInfoAccessor(cl, id);
    }

    public CLPlatformInfoAccessor createPlatformInfoAccessor(CL cl, long id) {
        return new CLTLPlatformInfoAccessor(cl, id);
    }

    private static final class CLTLPlatformInfoAccessor
    extends CLTLInfoAccessor
    implements CLPlatformInfoAccessor {
        private final long ID;
        private final CL cl;

        private CLTLPlatformInfoAccessor(CL cl, long id) {
            this.ID = id;
            this.cl = cl;
        }

        public int getInfo(int name, long valueSize, Buffer value, PointerBuffer valueSizeRet) {
            return this.cl.clGetPlatformInfo(this.ID, name, valueSize, value, valueSizeRet);
        }

        public long[] getDeviceIDs(long type) {
            IntBuffer buffer = this.getBB(4).asIntBuffer();
            int ret = this.cl.clGetDeviceIDs(this.ID, type, 0, null, buffer);
            int count = buffer.get(0);
            if (ret == -1 || count == 0) {
                return new long[0];
            }
            CLException.checkForError(ret, "error while enumerating devices");
            PointerBuffer deviceIDs = PointerBuffer.wrap(this.getBB(count * PointerBuffer.ELEMENT_SIZE));
            ret = this.cl.clGetDeviceIDs(this.ID, type, count, deviceIDs, null);
            CLException.checkForError(ret, "error while enumerating devices");
            long[] ids = new long[count];
            for (int i = 0; i < ids.length; ++i) {
                ids[i] = deviceIDs.get(i);
            }
            return ids;
        }
    }

    private static final class CLDeviceInfoAccessor
    extends CLTLInfoAccessor {
        private final CLDeviceBinding cl;
        private final long ID;

        private CLDeviceInfoAccessor(CLDeviceBinding cl, long id) {
            this.cl = cl;
            this.ID = id;
        }

        public int getInfo(int name, long valueSize, Buffer value, PointerBuffer valueSizeRet) {
            return this.cl.clGetDeviceInfo(this.ID, name, valueSize, value, valueSizeRet);
        }
    }
}

