/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl.util.concurrent;

import com.jogamp.opencl.CLCommandQueue;
import com.jogamp.opencl.CLDevice;
import com.jogamp.opencl.CLResource;
import com.jogamp.opencl.util.CLMultiContext;
import com.jogamp.opencl.util.concurrent.CLQueueContext;
import com.jogamp.opencl.util.concurrent.CLQueueContextFactory;
import com.jogamp.opencl.util.concurrent.CLTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CLCommandQueuePool<C extends CLQueueContext>
implements CLResource {
    private List<CLQueueContext> contexts;
    private ExecutorService excecutor;
    private FinishAction finishAction = FinishAction.DO_NOTHING;
    private boolean released;

    private CLCommandQueuePool(CLQueueContextFactory factory, Collection<CLCommandQueue> queues) {
        this.contexts = this.initContexts(queues, factory);
        this.initExecutor();
    }

    private List<CLQueueContext> initContexts(Collection<CLCommandQueue> queues, CLQueueContextFactory factory) {
        ArrayList<CLQueueContext> newContexts = new ArrayList<CLQueueContext>(queues.size());
        int index = 0;
        for (CLCommandQueue queue : queues) {
            CLQueueContext old = null;
            if (this.contexts != null && !this.contexts.isEmpty()) {
                old = this.contexts.get(index++);
                old.release();
            }
            newContexts.add((CLQueueContext)factory.setup(queue, old));
        }
        return newContexts;
    }

    private void initExecutor() {
        this.excecutor = Executors.newFixedThreadPool(this.contexts.size(), new QueueThreadFactory(this.contexts));
    }

    public static <C extends CLQueueContext> CLCommandQueuePool<C> create(CLQueueContextFactory<C> factory, CLMultiContext mc, CLCommandQueue.Mode ... modes) {
        return CLCommandQueuePool.create(factory, mc.getDevices(), modes);
    }

    public static <C extends CLQueueContext> CLCommandQueuePool<C> create(CLQueueContextFactory<C> factory, Collection<CLDevice> devices, CLCommandQueue.Mode ... modes) {
        ArrayList<CLCommandQueue> queues = new ArrayList<CLCommandQueue>(devices.size());
        for (CLDevice device : devices) {
            queues.add(device.createCommandQueue(modes));
        }
        return CLCommandQueuePool.create(factory, queues);
    }

    public static <C extends CLQueueContext> CLCommandQueuePool create(CLQueueContextFactory<C> factory, Collection<CLCommandQueue> queues) {
        return new CLCommandQueuePool<C>(factory, queues);
    }

    public <R> Future<R> submit(CLTask<? super C, R> task) {
        return this.excecutor.submit(new TaskWrapper<C, R>(task, this.finishAction));
    }

    public <R> List<Future<R>> submitAll(Collection<? extends CLTask<? super C, R>> tasks) {
        ArrayList<Future<R>> futures = new ArrayList<Future<R>>(tasks.size());
        for (CLTask<C, R> cLTask : tasks) {
            futures.add(this.submit(cLTask));
        }
        return futures;
    }

    public <R> List<Future<R>> invokeAll(Collection<? extends CLTask<? super C, R>> tasks) throws InterruptedException {
        List<TaskWrapper<C, R>> wrapper = this.wrapTasks(tasks);
        return this.excecutor.invokeAll(wrapper);
    }

    public <R> List<Future<R>> invokeAll(Collection<? extends CLTask<? super C, R>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        List<TaskWrapper<C, R>> wrapper = this.wrapTasks(tasks);
        return this.excecutor.invokeAll(wrapper, timeout, unit);
    }

    private <R> List<TaskWrapper<C, R>> wrapTasks(Collection<? extends CLTask<? super C, R>> tasks) {
        ArrayList<TaskWrapper<C, R>> wrapper = new ArrayList<TaskWrapper<C, R>>(tasks.size());
        for (CLTask<C, R> cLTask : tasks) {
            if (cLTask == null) {
                throw new NullPointerException("at least one task was null");
            }
            wrapper.add(new TaskWrapper<C, R>(cLTask, this.finishAction));
        }
        return wrapper;
    }

    public <C extends CLQueueContext> CLCommandQueuePool switchContext(CLQueueContextFactory<C> factory) {
        this.excecutor.shutdown();
        this.finishQueues();
        this.contexts = this.initContexts(this.getQueues(), factory);
        this.initExecutor();
        return this;
    }

    public void flushQueues() {
        for (CLQueueContext context : this.contexts) {
            context.queue.flush();
        }
    }

    public void finishQueues() {
        for (CLQueueContext context : this.contexts) {
            context.queue.finish();
        }
    }

    @Override
    public void release() {
        if (this.released) {
            throw new RuntimeException(this.getClass().getSimpleName() + " already released");
        }
        this.released = true;
        this.excecutor.shutdown();
        for (CLQueueContext context : this.contexts) {
            context.queue.finish().release();
            context.release();
        }
    }

    public List<CLCommandQueue> getQueues() {
        ArrayList<CLCommandQueue> queues = new ArrayList<CLCommandQueue>(this.contexts.size());
        for (CLQueueContext context : this.contexts) {
            queues.add(context.queue);
        }
        return queues;
    }

    public int getSize() {
        return this.contexts.size();
    }

    public FinishAction getFinishAction() {
        return this.finishAction;
    }

    @Override
    public boolean isReleased() {
        return this.released;
    }

    public void setFinishAction(FinishAction action) {
        this.finishAction = action;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [queues: " + this.contexts.size() + " on finish: " + (Object)((Object)this.finishAction) + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FinishAction {
        DO_NOTHING,
        FLUSH,
        FINISH;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TaskWrapper<C extends CLQueueContext, R>
    implements Callable<R> {
        private final CLTask<? super C, R> task;
        private final FinishAction mode;

        public TaskWrapper(CLTask<? super C, R> task, FinishAction mode) {
            this.task = task;
            this.mode = mode;
        }

        @Override
        public R call() throws Exception {
            CLQueueContext context = ((QueueThread)Thread.currentThread()).context;
            R result = this.task.execute(context);
            if (this.mode.equals((Object)FinishAction.FLUSH)) {
                context.queue.flush();
            } else if (this.mode.equals((Object)FinishAction.FINISH)) {
                context.queue.finish();
            }
            return result;
        }
    }

    private static class QueueThread
    extends Thread {
        private final CLQueueContext context;

        public QueueThread(ThreadGroup group, Runnable runnable, CLQueueContext context, int index) {
            super(group, runnable, "queue-worker-thread-" + index + "[" + context + "]");
            this.context = context;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class QueueThreadFactory
    implements ThreadFactory {
        private final List<CLQueueContext> context;
        private int index;

        private QueueThreadFactory(List<CLQueueContext> queues) {
            this.context = queues;
            this.index = 0;
        }

        @Override
        public synchronized Thread newThread(Runnable runnable) {
            SecurityManager sm = System.getSecurityManager();
            ThreadGroup group = sm != null ? sm.getThreadGroup() : Thread.currentThread().getThreadGroup();
            CLQueueContext queue = this.context.get(this.index);
            QueueThread thread = new QueueThread(group, runnable, queue, this.index++);
            thread.setDaemon(true);
            return thread;
        }
    }
}

