/*
 * Decompiled with CFR 0.152.
 */
package com.js.test.engine.material;

import com.js.test.engine.material.Material;
import com.js.test.engine.material.RGBA;
import java.util.HashMap;
import java.util.Map;
import javax.media.opengl.GL2;

public class MaterialHandler {
    private static MaterialHandler myInstance;
    private Map<String, Material> myMaterials = new HashMap<String, Material>();

    private MaterialHandler() {
        this.myMaterials.put("sun", new Material(new RGBA(3.0f, 3.0f, 3.0f, 1.0f), new RGBA(1.0f, 1.0f, 1.0f, 1.0f), 5.0f));
        this.myMaterials.put("planet", new Material(new RGBA(0.3f, 0.3f, 0.3f, 1.0f), new RGBA(1.0f, 1.0f, 1.0f, 1.0f), 8.0f));
    }

    public static synchronized MaterialHandler getInstance() {
        if (myInstance == null) {
            myInstance = new MaterialHandler();
            return myInstance;
        }
        return myInstance;
    }

    public Material getMaterial(String theMaterial) {
        return this.myMaterials.get(theMaterial);
    }

    public void activateMaterial(String theMaterial, GL2 theGl) {
        Material aMaterial = this.myMaterials.get(theMaterial);
        theGl.glMaterialfv(1032, 4608, aMaterial.getMyAmbient().getRGBA(), 0);
        theGl.glMaterialfv(1032, 4610, aMaterial.getMySpecular().getRGBA(), 0);
        theGl.glMaterialf(1032, 5633, aMaterial.getMyShininess());
    }
}

