/*
 * Decompiled with CFR 0.152.
 */
package com.js.test.engine.player;

import com.js.test.engine.camera.Camera;
import com.js.test.engine.player.Inventory;
import com.js.test.terra.area.animatedgenerator.AnimatedGeneratorHandler;
import com.js.test.terra.area.animatedgenerator.BlockRemovalGenerator;
import com.js.test.terra.area.animatedgenerator.CoralAnimatedGenerator;
import com.js.test.terra.area.blocks.Block;
import com.js.test.terra.area.blocks.BlockLoader;
import com.js.test.terra.area.chunks.BigChunkDataGrid;
import com.js.test.terra.area.item.BaseItem;
import com.js.test.terra.area.item.BaseItemLoader;
import com.js.test.terra.area.item.ItemStack;
import com.js.test.terra.area.item.ItemWrapper;
import com.js.test.terra.area.movables.CloudMovable;
import com.js.test.terra.area.movables.ElevatorMovable;
import com.js.test.terra.area.movables.LaserMovable;
import com.js.test.terra.area.movables.MegaGunMovable;
import com.js.test.terra.area.movables.MovableHandler;
import com.js.test.terra.area.movables.PlasmaMovable;
import com.js.test.terra.area.movables.TreeMovable;
import com.js.test.terra.math.Vector3;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;

public class Player {
    private Camera myCamera;
    private Vector3 myDirection;
    private float myJumpHeight;
    private boolean isGravityAffected;
    private boolean allowYMove;
    private long myLastLeftUsageTime;
    private long myLastRightUsageTime;
    private boolean isPlaying;
    private transient GL2 myGl;
    private transient GLU myGlu;
    private BaseItem myActiveItem;
    private boolean isInInventory;
    private boolean isInInventoryStateChange;
    private boolean isInMenu;
    private boolean isInMenuStateChange;
    private Inventory myInventory;

    public Player(Camera theCamera, boolean theAllowYMove, int theSize, GL2 theGl, GLU theGlu) {
        this.myCamera = theCamera;
        this.allowYMove = theAllowYMove;
        this.isGravityAffected = false;
        this.isInInventory = false;
        this.isInInventoryStateChange = false;
        this.myDirection = new Vector3(0.0, 0.0, 0.0);
        this.myGl = theGl;
        this.myGlu = theGlu;
        this.myJumpHeight = 0.0f;
        this.isPlaying = false;
        this.myLastRightUsageTime = this.myLastLeftUsageTime = System.currentTimeMillis();
        this.myActiveItem = BaseItemLoader.getInstance().getMyNameToItemMap().get("lazor");
        this.myInventory = new Inventory(15, 7);
        ItemWrapper anItem1 = new ItemWrapper(false, true, 0, 34, true);
        ItemWrapper anItem2 = new ItemWrapper(false, true, 0, 35, true);
        ItemWrapper anItem5 = new ItemWrapper(false, true, 0, 36, true);
        ItemWrapper anItem6 = new ItemWrapper(false, true, 0, 38, true);
        ItemWrapper anItem3 = new ItemWrapper(true, false, 1, 0, false);
        ItemWrapper anItem4 = new ItemWrapper(true, false, 2, 0, false);
        ItemWrapper anItem7 = new ItemWrapper(true, false, 10, 0, false);
        ItemWrapper anItem8 = new ItemWrapper(true, false, 11, 0, false);
        ItemStack anItemStack1 = new ItemStack(anItem1, 1, true);
        ItemStack anItemStack2 = new ItemStack(anItem2, 1, true);
        ItemStack anItemStack5 = new ItemStack(anItem5, 1, true);
        ItemStack anItemStack6 = new ItemStack(anItem6, 1, true);
        ItemStack anItemStack3 = new ItemStack(anItem3, 0, false);
        ItemStack anItemStack4 = new ItemStack(anItem4, 0, false);
        ItemStack anItemStack7 = new ItemStack(anItem7, 0, false);
        ItemStack anItemStack8 = new ItemStack(anItem8, 0, false);
        this.myInventory.addStack(anItemStack1);
        this.myInventory.addStack(anItemStack2);
        this.myInventory.addStack(anItemStack5);
        this.myInventory.addStack(anItemStack6);
        int i = 3;
        while (i < BlockLoader.getInstance().getMyBlocksAsArray().length) {
            ItemWrapper anItemToAdd = new ItemWrapper(false, true, 0, i, true);
            ItemStack aStackToAdd = new ItemStack(anItemToAdd, 500, true);
            this.myInventory.addStack(aStackToAdd);
            ++i;
        }
        for (BaseItem anItem : BaseItemLoader.getInstance().getMyItems()) {
            if (!anItem.isStackable()) continue;
            ItemWrapper anItemToAdd = new ItemWrapper(true, false, anItem.getMyId(), 0, true);
            ItemStack aStackToAdd = new ItemStack(anItemToAdd, 100, true);
            this.myInventory.addStack(aStackToAdd);
        }
        this.myInventory.getMyHotbar().getItems()[0] = anItemStack4;
        this.myInventory.getMyHotbar().getItems()[1] = anItemStack3;
        this.myInventory.getMyHotbar().getItems()[2] = anItemStack7;
        this.myInventory.getMyHotbar().getItems()[3] = anItemStack8;
    }

    public void setDirectionToCameraDirection() {
        this.getMyDirection().x = this.myCamera.getVx();
        this.getMyDirection().z = this.myCamera.getVz();
        if (this.isAllowYMove()) {
            this.getMyDirection().y = this.myCamera.getVy();
        }
    }

    public void unsetDirection() {
        this.getMyDirection().x = 0.0;
        this.getMyDirection().z = 0.0;
        if (this.isAllowYMove()) {
            this.getMyDirection().y = 0.0;
        }
    }

    public void doActivateLeft(BigChunkDataGrid theGrid) {
        ItemStack aLeftHand = this.myInventory.getMyHotbar().getActiveLeft();
        boolean removeItem = this.doActivateItem(aLeftHand, theGrid);
        if (removeItem) {
            this.myInventory.getMyHotbar().removeActiveLeftHand();
        }
        this.myLastLeftUsageTime = System.currentTimeMillis();
    }

    public void doActivateRight(BigChunkDataGrid theGrid) {
        ItemStack aRightHand = this.myInventory.getMyHotbar().getActiveRight();
        boolean removeItem = this.doActivateItem(aRightHand, theGrid);
        if (removeItem) {
            this.myInventory.getMyHotbar().removeActiveRightHand();
        }
        this.myLastRightUsageTime = System.currentTimeMillis();
    }

    public boolean doActivateItem(ItemStack theItemStack, BigChunkDataGrid theGrid) {
        if (theItemStack != null) {
            if (theItemStack.getMyItem().isBlock) {
                if (this.placeBlock(theGrid, theItemStack.getMyItem().blockId)) {
                    theItemStack.setMyAmount(theItemStack.getMyAmount() - 1);
                    if (theItemStack.getMyAmount() == 0) {
                        return true;
                    }
                }
            } else {
                boolean wasActivated = false;
                BaseItem anItemToActivate = BaseItemLoader.getInstance().getMyItems().get(theItemStack.getMyItem().itemId);
                if (anItemToActivate.getMyName().equals("lazor")) {
                    this.activateLaser(theGrid);
                    wasActivated = true;
                }
                if (anItemToActivate.getMyName().equals("megagun")) {
                    this.activateMegaGun();
                    wasActivated = true;
                } else if (anItemToActivate.getMyName().equals("prt")) {
                    int removedBlock = this.removeBlock(theGrid);
                    if (removedBlock > 2) {
                        boolean success = this.myInventory.addBlock(removedBlock, 1);
                        wasActivated = true;
                    }
                } else if (anItemToActivate.getMyName().equals("edc")) {
                    this.activateElevatorDownGun();
                    wasActivated = true;
                } else if (anItemToActivate.getMyName().equals("euc")) {
                    this.activateElevatorUpGun();
                    wasActivated = true;
                } else if (anItemToActivate.getMyName().equals("jetpack")) {
                    this.getMyDirection().y = 2.0;
                    wasActivated = true;
                }
                if (wasActivated && !anItemToActivate.isStackable() && anItemToActivate.getMyUsages() != 9999) {
                    theItemStack.setMyAmount(theItemStack.getMyAmount() + 1);
                    if (theItemStack.getMyAmount() >= anItemToActivate.getMyUsages()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public void activateLaser(BigChunkDataGrid theGrid) {
        Vector3 aHit = theGrid.intersectRay((float)this.myCamera.getX(), (float)this.myCamera.getY() - 0.5f, (float)this.myCamera.getZ(), (float)this.myCamera.getVx(), (float)this.myCamera.getVy(), (float)this.myCamera.getVz(), 64.0f);
        float aLength = 64.0f;
        if (aHit != null) {
            aHit.x -= this.myCamera.getVx() / 2.0;
            aHit.y -= this.myCamera.getVy() / 2.0;
            aHit.z -= this.myCamera.getVz() / 2.0;
            aLength = aHit.distanceTo(this.myCamera.getX(), this.myCamera.getY(), this.myCamera.getZ());
            CloudMovable aExplosion = new CloudMovable(aHit, new Vector3(0.0, 0.7f, 0.0), 0.0f, 0.5f, false, 0);
            MovableHandler.getInstance().addMovable(aExplosion);
        }
        Vector3 posOffs = new Vector3(this.myCamera.getVx(), this.myCamera.getVy(), this.myCamera.getVz());
        posOffs.scale(aLength / 2.0f);
        LaserMovable myMovable = new LaserMovable(new Vector3(this.myCamera.getLookX() + posOffs.x, this.myCamera.getLookY() - 0.5 + posOffs.y, this.myCamera.getLookZ() + posOffs.z), aLength, new Vector3(this.myCamera.getRotX(), this.myCamera.getRotY(), 0.0), 0.0f, 0.2f, false, 0);
        MovableHandler.getInstance().addMovable(myMovable);
    }

    public void activatePlasma() {
        PlasmaMovable myMovable = new PlasmaMovable(new Vector3(this.myCamera.getLookX(), this.myCamera.getLookY(), this.myCamera.getLookZ()), new Vector3(this.myCamera.getVx() * 25.0, this.myCamera.getVy() * 25.0, this.myCamera.getVz() * 25.0), 0.0f, 6.0f, true, 0);
        MovableHandler.getInstance().addMovable(myMovable);
    }

    public void activateMegaGun() {
        MegaGunMovable myMovable = new MegaGunMovable(new Vector3(this.myCamera.getLookX(), this.myCamera.getLookY(), this.myCamera.getLookZ()), new Vector3(this.myCamera.getVx() * 25.0, this.myCamera.getVy() * 25.0, this.myCamera.getVz() * 25.0), 0.0f, 6.0f, true, 0);
        MovableHandler.getInstance().addMovable(myMovable);
    }

    public void activateTreeGun() {
        TreeMovable myMovable = new TreeMovable(new Vector3(this.myCamera.getLookX(), this.myCamera.getLookY(), this.myCamera.getLookZ()), new Vector3(this.myCamera.getVx() * 25.0, this.myCamera.getVy() * 25.0, this.myCamera.getVz() * 25.0), 0.0f, 6.0f, true, 0);
        MovableHandler.getInstance().addMovable(myMovable);
    }

    public void activateElevatorUpGun() {
        ElevatorMovable myMovable = new ElevatorMovable(new Vector3(this.myCamera.getLookX(), this.myCamera.getLookY(), this.myCamera.getLookZ()), new Vector3(this.myCamera.getVx() * 25.0, this.myCamera.getVy() * 25.0, this.myCamera.getVz() * 25.0), 0.0f, 6.0f, true, 0, 1);
        MovableHandler.getInstance().addMovable(myMovable);
    }

    public void activateElevatorDownGun() {
        ElevatorMovable myMovable = new ElevatorMovable(new Vector3(this.myCamera.getLookX(), this.myCamera.getLookY(), this.myCamera.getLookZ()), new Vector3(this.myCamera.getVx() * 25.0, this.myCamera.getVy() * 25.0, this.myCamera.getVz() * 25.0), 0.0f, 6.0f, true, 0, 2);
        MovableHandler.getInstance().addMovable(myMovable);
    }

    public int removeBlock(BigChunkDataGrid theGrid) {
        double myTransCamZ;
        double myTransCamY;
        double myTransCamX = this.myCamera.getX();
        Vector3 hit = theGrid.intersectRay((float)myTransCamX, (float)(myTransCamY = this.myCamera.getY()), (float)(myTransCamZ = this.myCamera.getZ()), (float)this.myCamera.getVx(), (float)this.myCamera.getVy(), (float)this.myCamera.getVz(), 4.0f);
        if (hit != null) {
            int aXToDo = Math.round((float)hit.x);
            int aYToDo = Math.round((float)hit.y);
            int aZToDo = Math.round((float)hit.z);
            return theGrid.removeBlockWithUpdates(aXToDo, aYToDo, aZToDo, this.myGl, this.myGlu);
        }
        return -1;
    }

    public void doActivateAction(BigChunkDataGrid theGrid) {
        double myTransCamZ;
        double myTransCamY;
        double myTransCamX = this.myCamera.getX();
        Vector3 hit = theGrid.intersectRay((float)myTransCamX, (float)(myTransCamY = this.myCamera.getY()), (float)(myTransCamZ = this.myCamera.getZ()), (float)this.myCamera.getVx(), (float)this.myCamera.getVy(), (float)this.myCamera.getVz(), 4.0f);
        if (hit != null && !this.checkIfSameBlock(myTransCamX, myTransCamY, myTransCamZ, hit.x, hit.y, hit.z)) {
            int aXToDo = Math.round((float)hit.x);
            int aYToDo = Math.round((float)hit.y);
            int aZToDo = Math.round((float)hit.z);
            int aBlockId = theGrid.getBlockAt(aXToDo, aYToDo, aZToDo);
            Block aBlockToActivate = BlockLoader.getInstance().getMyBlocksAsArray()[aBlockId];
            if (aBlockToActivate.isActivatable() && aBlockToActivate.isManuallyActivatable()) {
                theGrid.toggleActiveWithUpdates(aXToDo, aYToDo, aZToDo, this.myGl, this.myGlu, true, this, false);
            }
        }
    }

    public void doTunableAction(BigChunkDataGrid theGrid) {
        double myTransCamZ;
        double myTransCamY;
        double myTransCamX = this.myCamera.getX();
        Vector3 hit = theGrid.intersectRay((float)myTransCamX, (float)(myTransCamY = this.myCamera.getY()), (float)(myTransCamZ = this.myCamera.getZ()), (float)this.myCamera.getVx(), (float)this.myCamera.getVy(), (float)this.myCamera.getVz(), 4.0f);
        if (hit != null && !this.checkIfSameBlock(myTransCamX, myTransCamY, myTransCamZ, hit.x, hit.y, hit.z)) {
            int aXToDo = Math.round((float)hit.x);
            int aYToDo = Math.round((float)hit.y);
            int aZToDo = Math.round((float)hit.z);
            int aBlockId = theGrid.getBlockAt(aXToDo, aYToDo, aZToDo);
            Block aBlockToActivate = BlockLoader.getInstance().getMyBlocksAsArray()[aBlockId];
            if (aBlockToActivate.isTunable()) {
                theGrid.triggerTunable(aXToDo, aYToDo, aZToDo, this.myGl, this.myGlu, true, this, false);
            }
        }
    }

    public boolean placeBlock(BigChunkDataGrid theGrid, int theIdToPlace) {
        double myTransCamZ;
        double myTransCamY;
        double myTransCamX = this.myCamera.getX();
        Vector3 hit = theGrid.intersectRayGetInfront((float)myTransCamX, (float)(myTransCamY = this.myCamera.getY()), (float)(myTransCamZ = this.myCamera.getZ()), (float)this.myCamera.getVx(), (float)this.myCamera.getVy(), (float)this.myCamera.getVz(), 4.0f);
        if (hit != null && !this.checkIfSameBlock(myTransCamX, myTransCamY, myTransCamZ, hit.x, hit.y, hit.z)) {
            double absX;
            double absZ;
            Block aBlockToPlace = BlockLoader.getInstance().getMyBlocksAsArray()[theIdToPlace];
            int aXToDo = Math.round((float)hit.x);
            int aYToDo = Math.round((float)hit.y);
            int aZToDo = Math.round((float)hit.z);
            int direction = 0;
            if (aBlockToPlace.isMultisided() && (absZ = Math.abs(this.myCamera.getVz())) > (absX = Math.abs(this.myCamera.getVx()))) {
                direction = 1;
            }
            theGrid.addBlockWithUpdates(aXToDo, aYToDo, aZToDo, aBlockToPlace, this.myGl, this.myGlu, direction);
            return true;
        }
        return false;
    }

    public boolean checkIfSameBlock(double cx, double cy, double cz, double bx, double by, double bz) {
        return Math.round(cx) == Math.round(bx) && Math.round(cy) == Math.round(by) && Math.round(cz) == Math.round(bz);
    }

    public void placeGenerator(BigChunkDataGrid theGrid, int theIdToBe) {
        CoralAnimatedGenerator aNewBlock;
        double myTransCamZ;
        double myTransCamY;
        double myTransCamX = this.myCamera.getX();
        Vector3 hit = theGrid.intersectRay((float)myTransCamX, (float)(myTransCamY = this.myCamera.getY()), (float)(myTransCamZ = this.myCamera.getZ()), (float)this.myCamera.getVx(), (float)this.myCamera.getVy(), (float)this.myCamera.getVz(), 10.0f);
        if (hit != null && !this.checkIfSameBlock(myTransCamX, myTransCamY, myTransCamZ, hit.x, hit.y, hit.z) && !(aNewBlock = new CoralAnimatedGenerator(6, 6, 6, Math.round((float)hit.x), Math.round((float)hit.y), Math.round((float)hit.z), theIdToBe, theGrid, this.myGl)).isInvalid()) {
            AnimatedGeneratorHandler.getInstance().getAnimatedGenerators().add(aNewBlock);
        }
    }

    public void placeRemovalGenerator(BigChunkDataGrid theGrid, int theIdToBe) {
        BlockRemovalGenerator aNewBlock;
        double myTransCamZ;
        double myTransCamY;
        double myTransCamX = this.myCamera.getX();
        Vector3 hit = theGrid.intersectRayGetInfront((float)myTransCamX, (float)(myTransCamY = this.myCamera.getY()), (float)(myTransCamZ = this.myCamera.getZ()), (float)this.myCamera.getVx(), (float)this.myCamera.getVy(), (float)this.myCamera.getVz(), 10.0f);
        if (hit != null && !this.checkIfSameBlock(myTransCamX, myTransCamY, myTransCamZ, hit.x, hit.y, hit.z) && !(aNewBlock = new BlockRemovalGenerator(6, 6, 6, Math.round((float)hit.x), Math.round((float)hit.y), Math.round((float)hit.z), theIdToBe, theGrid, this.myGl)).isInvalid()) {
            AnimatedGeneratorHandler.getInstance().getAnimatedGenerators().add(aNewBlock);
        }
    }

    public void move(double amount, double strafeAmount, BigChunkDataGrid theGrid, float gravityAmount, double gravityScaleAmount) {
        int atBlock;
        Vector3 rotatedX = Vector3.rotateVector(new Vector3(1.0, 0.0, 0.0), new Vector3(0.0, 1.0, 0.0), -this.myCamera.getRotX());
        double myCamX = this.myCamera.getX();
        double myCamY = this.myCamera.getY();
        double myCamZ = this.myCamera.getZ();
        double myTransCamX = this.myCamera.getX();
        double myTransCamY = this.myCamera.getY();
        double myTransCamZ = this.myCamera.getZ();
        boolean front = this.checkOkMove(myTransCamX, myTransCamY, myTransCamZ - 1.0, theGrid);
        boolean frontDown = this.checkOkMove(myTransCamX, myTransCamY - 1.0, myTransCamZ - 1.0, theGrid);
        boolean back = this.checkOkMove(myTransCamX, myTransCamY, myTransCamZ + 1.0, theGrid);
        boolean backDown = this.checkOkMove(myTransCamX, myTransCamY - 1.0, myTransCamZ + 1.0, theGrid);
        boolean left = this.checkOkMove(myTransCamX - 1.0, myTransCamY, myTransCamZ, theGrid);
        boolean leftDown = this.checkOkMove(myTransCamX - 1.0, myTransCamY - 1.0, myTransCamZ, theGrid);
        boolean right = this.checkOkMove(myTransCamX + 1.0, myTransCamY, myTransCamZ, theGrid);
        boolean rightDown = this.checkOkMove(myTransCamX + 1.0, myTransCamY - 1.0, myTransCamZ, theGrid);
        boolean top = this.checkOkMove(myTransCamX, myTransCamY + 1.0, myTransCamZ, theGrid);
        boolean bottom2 = this.checkOkMove(myTransCamX, myTransCamY - 2.0, myTransCamZ, theGrid);
        double myPosXToSet = this.myCamera.getX() + this.myDirection.x * amount + rotatedX.x * strafeAmount;
        double myPosYToSet = this.myCamera.getY();
        myPosYToSet = this.isAllowYMove() ? this.myCamera.getY() + this.myDirection.y * amount : this.myCamera.getY() + this.myDirection.y * Math.abs(gravityScaleAmount);
        double myPosZToSet = this.myCamera.getZ() + this.myDirection.z * amount + rotatedX.z * strafeAmount;
        if (myPosXToSet > myCamX) {
            if (right && rightDown) {
                this.myCamera.setX(myPosXToSet);
            }
        } else if (myPosXToSet < myCamX && left && leftDown) {
            this.myCamera.setX(myPosXToSet);
        }
        if (myPosYToSet > myCamY) {
            if (top) {
                this.myCamera.setY(myPosYToSet);
            }
        } else if (myPosYToSet < myCamY && bottom2) {
            this.myCamera.setY(myPosYToSet);
        }
        if (myPosZToSet > myCamZ) {
            if (back && backDown) {
                this.myCamera.setZ(myPosZToSet);
            }
        } else if (myPosZToSet < myCamZ && front && frontDown) {
            this.myCamera.setZ(myPosZToSet);
        }
        if ((atBlock = theGrid.getBlockAt(Math.round((float)myTransCamX), Math.round((float)myTransCamY), Math.round((float)myTransCamZ))) == 0) {
            if (!this.isAllowYMove()) {
                if (!bottom2 && this.myDirection.y < (double)gravityAmount) {
                    this.myCamera.setY((double)Math.round(this.myCamera.getY()) + this.myDirection.y * Math.abs(amount));
                    this.myDirection.y = 0.0;
                } else {
                    this.myDirection.y = !top && this.myDirection.y > (double)gravityAmount ? 0.0 : (this.myDirection.y -= (double)gravityAmount);
                }
            }
        } else if (!this.isAllowYMove()) {
            this.myDirection.y = atBlock == 1 ? 1.0 : -1.0;
        }
    }

    public void strafe(double amount, BigChunkDataGrid theGrid) {
    }

    public boolean checkOkMove(double x, double y, double z, BigChunkDataGrid theGrid) {
        return theGrid.getBlockAt(Math.round((float)x), Math.round((float)y), Math.round((float)z)) < 3;
    }

    public Vector3 getMyDirection() {
        return this.myDirection;
    }

    public void setMyDirection(Vector3 myDirection) {
        this.myDirection = myDirection;
    }

    public boolean isGravityAffected() {
        return this.isGravityAffected;
    }

    public void setGravityAffected(boolean isGravityAffected) {
        this.isGravityAffected = isGravityAffected;
    }

    public boolean isAllowYMove() {
        return this.allowYMove;
    }

    public void setAllowYMove(boolean allowYMove) {
        this.allowYMove = allowYMove;
    }

    public float getMyJumpHeight() {
        return this.myJumpHeight;
    }

    public void setMyJumpHeight(float myJumpHeight) {
        this.myJumpHeight = myJumpHeight;
    }

    public long getMyLastLeftUsageTime() {
        return this.myLastLeftUsageTime;
    }

    public void setMyLastLeftUsageTime(long myLastUsageTime) {
        this.myLastLeftUsageTime = myLastUsageTime;
    }

    public long getMyLastRightUsageTime() {
        return this.myLastRightUsageTime;
    }

    public void setMyLastRightUsageTime(long myLastRightUsageTime) {
        this.myLastRightUsageTime = myLastRightUsageTime;
    }

    public BaseItem getMyActiveItem() {
        return this.myActiveItem;
    }

    public void setMyActiveItem(BaseItem myActiveItem) {
        this.myActiveItem = myActiveItem;
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }

    public void setPlaying(boolean isPlaying) {
        this.isPlaying = isPlaying;
    }

    public Inventory getMyInventory() {
        return this.myInventory;
    }

    public void setMyInventory(Inventory myInventory) {
        this.myInventory = myInventory;
    }

    public boolean isInInventory() {
        return this.isInInventory;
    }

    public void setInInventory(boolean isInInventory) {
        this.isInInventory = isInInventory;
    }

    public boolean isInInventoryStateChange() {
        return this.isInInventoryStateChange;
    }

    public void setInInventoryStateChange(boolean isInInventoryStateChange) {
        this.isInInventoryStateChange = isInInventoryStateChange;
    }

    public boolean isInMenu() {
        return this.isInMenu;
    }

    public void setInMenu(boolean isInMenu) {
        this.isInMenu = isInMenu;
    }

    public boolean isInMenuStateChange() {
        return this.isInMenuStateChange;
    }

    public void setInMenuStateChange(boolean isInMenuStateChange) {
        this.isInMenuStateChange = isInMenuStateChange;
    }
}

