/*
 * Decompiled with CFR 0.152.
 */
package com.js.test.terra.area.animatedgenerator;

import com.js.test.terra.area.animatedgenerator.AnimatedGenerator;
import com.js.test.terra.area.chunks.BigChunkDataGrid;
import com.js.test.terra.math.Vector3;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;

public class BlockAnimatedGenerator
extends AnimatedGenerator {
    private BigChunkDataGrid myGrid;

    public BlockAnimatedGenerator(int w, int h, int d, int x, int y, int z, int blockId, BigChunkDataGrid theGrid, GL2 theGl) {
        super(w, h, d);
        this.myBlockId = blockId;
        this.myGrid = theGrid;
        if (theGrid.getBlockAt(x, y + 1, z) == 0) {
            this.myCenter = new Vector3(0.0, 0.0, 0.0);
            this.myCenter.x = x;
            this.myCenter.y = (float)y + (float)h / 2.0f + 0.5f;
            this.myCenter.z = z;
            this.myRenderCenter = new Vector3(0.0, 0.0, 0.0);
            this.myX = x;
            this.myY = y;
            this.myZ = z;
            this.fillCube(theGrid);
            this.generateVBOForMyBlock(theGl);
        } else {
            this.isInvalid = true;
        }
    }

    private void fillCube(BigChunkDataGrid theGrid) {
        int index = 0;
        int k = 0;
        while (k < this.myDepth) {
            int j = 0;
            while (j < this.myHeight) {
                int i = 0;
                while (i < this.myWidth) {
                    this.myBlocks[index] = this.myBlockId;
                    ++index;
                    ++i;
                }
                ++j;
            }
            ++k;
        }
        this.myAmountOfBlocks = index;
    }

    @Override
    public boolean doTick(GL2 theGl, GLU theGlu, float amount, BigChunkDataGrid theGrid) {
        if (this.isInvalid) {
            return true;
        }
        this.myAmountOfCurrentlyVisibleBlocks += amount * 27.0f;
        if ((int)this.myAmountOfCurrentlyVisibleBlocks >= this.myAmountOfBlocks) {
            this.myGrid.insertGeometry(this.myBlocks, this.myWidth, this.myHeight, this.myDepth, (int)((double)this.myX - Math.floor(this.myWidth / 2)), (int)((double)this.myY + Math.floor(this.myHeight)), (int)((double)this.myZ - Math.floor(this.myDepth / 2)), theGl, theGlu);
            return true;
        }
        return false;
    }
}

