/*
 * Decompiled with CFR 0.152.
 */
package com.js.test.terra.math;

public class Vector3 {
    public double x;
    public double y;
    public double z;

    public Vector3(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public float manhattanDistanceTo(double x, double y, double z) {
        double rX = x - this.x;
        double rY = y - this.y;
        double rZ = z - this.z;
        return (float)(rX * rX + rY * rY + rZ * rZ);
    }

    public float distanceTo(double x, double y, double z) {
        double rX = x - this.x;
        double rY = y - this.y;
        double rZ = z - this.z;
        return (float)Math.sqrt(rX * rX + rY * rY + rZ * rZ);
    }

    public void normalize() {
        double length = this.length();
        this.x /= length;
        this.y /= length;
        this.z /= length;
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public void scale(double scale) {
        this.x *= scale;
        this.y *= scale;
        this.z *= scale;
    }

    public static Vector3 rotateVector(Vector3 view, Vector3 rotateAround, double theta) {
        double c = Math.cos(theta * Math.PI / 180.0);
        double s = Math.sin(theta * Math.PI / 180.0);
        double k = (1.0 - c) * (view.x * rotateAround.x + view.y * rotateAround.y + view.z * rotateAround.z);
        double x = c * view.x + k * rotateAround.x + s * (rotateAround.y * view.z - rotateAround.z * view.y);
        double y = c * view.y + k * rotateAround.y + s * (rotateAround.z * view.x - rotateAround.x * view.z);
        double z = c * view.z + k * rotateAround.z + s * (rotateAround.x * view.y - rotateAround.y * view.x);
        return new Vector3(x, y, z);
    }

    public String toString() {
        return "[x: " + this.x + " y: " + this.y + " z: " + this.z + "]";
    }
}

