/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt.driver.awt;

import com.jogamp.newt.event.WindowAdapter;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.event.awt.AWTKeyAdapter;
import com.jogamp.newt.event.awt.AWTMouseAdapter;
import com.jogamp.newt.event.awt.AWTWindowAdapter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.DisplayMode;
import java.awt.Frame;
import java.awt.Insets;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.awt.AWTGraphicsConfiguration;
import javax.media.nativewindow.awt.AWTGraphicsDevice;
import javax.media.nativewindow.awt.AWTGraphicsScreen;
import javax.media.nativewindow.util.Point;
import jogamp.newt.WindowImpl;
import jogamp.newt.driver.awt.AWTCanvas;
import jogamp.newt.driver.awt.AWTDisplay;
import jogamp.newt.driver.awt.AWTScreen;

public class AWTWindow
extends WindowImpl {
    private boolean owningFrame;
    private Container container = null;
    private Frame frame = null;
    private AWTCanvas canvas;

    public AWTWindow() {
        this(null);
    }

    public static Class[] getCustomConstructorArgumentTypes() {
        return new Class[]{Container.class};
    }

    public AWTWindow(Container container) {
        this.title = "AWT NewtWindow";
        this.container = container;
        if (container instanceof Frame) {
            this.frame = (Frame)container;
        }
    }

    @Override
    protected void requestFocusImpl(boolean bl) {
        this.container.requestFocus();
    }

    @Override
    protected void setTitleImpl(String string) {
        if (this.frame != null) {
            this.frame.setTitle(string);
        }
    }

    @Override
    protected void createNativeImpl() {
        if (0L != this.getParentWindowHandle()) {
            throw new RuntimeException("Window parenting not supported in AWT, use AWTWindow(Frame) cstr for wrapping instead");
        }
        if (null == this.container) {
            this.frame = new Frame();
            this.container = this.frame;
            this.owningFrame = true;
        } else {
            this.owningFrame = false;
            this.width = this.container.getWidth();
            this.height = this.container.getHeight();
            this.x = this.container.getX();
            this.y = this.container.getY();
        }
        if (null != this.frame) {
            this.frame.setTitle(this.getTitle());
        }
        this.container.setLayout(new BorderLayout());
        this.canvas = new AWTCanvas(this.capsRequested, this.capabilitiesChooser);
        this.addWindowListener(new LocalWindowListener());
        new AWTMouseAdapter(this).addTo(this.canvas);
        new AWTKeyAdapter(this).addTo(this.canvas);
        this.container.add((Component)this.canvas, "Center");
        this.container.setSize(this.width, this.height);
        this.container.setLocation(this.x, this.y);
        new AWTWindowAdapter(this).addTo(this.container);
        this.reconfigureWindowImpl(this.x, this.y, this.width, this.height, this.getReconfigureFlags(18, true));
        this.setWindowHandle(1L);
    }

    @Override
    protected void closeNativeImpl() {
        this.setWindowHandle(0L);
        if (null != this.container) {
            this.container.setVisible(false);
            this.container.remove(this.canvas);
            this.container.setEnabled(false);
            this.canvas.setEnabled(false);
        }
        if (this.owningFrame && null != this.frame) {
            this.frame.dispose();
            this.owningFrame = false;
            this.frame = null;
        }
    }

    @Override
    public boolean hasDeviceChanged() {
        boolean bl = this.canvas.hasDeviceChanged();
        if (bl) {
            AWTGraphicsConfiguration aWTGraphicsConfiguration = this.canvas.getAWTGraphicsConfiguration();
            if (null == aWTGraphicsConfiguration) {
                throw new NativeWindowException("Error Device change null GraphicsConfiguration: " + this);
            }
            this.setGraphicsConfiguration(aWTGraphicsConfiguration);
            ((AWTScreen)this.getScreen()).setAWTGraphicsScreen((AWTGraphicsScreen)aWTGraphicsConfiguration.getScreen());
            ((AWTDisplay)this.getScreen().getDisplay()).setAWTGraphicsDevice((AWTGraphicsDevice)aWTGraphicsConfiguration.getScreen().getDevice());
            DisplayMode displayMode = ((AWTGraphicsDevice)aWTGraphicsConfiguration.getScreen().getDevice()).getGraphicsDevice().getDisplayMode();
            if (null != displayMode) {
                ((AWTScreen)this.getScreen()).setScreenSize(displayMode.getWidth(), displayMode.getHeight());
            }
        }
        return bl;
    }

    @Override
    protected void updateInsetsImpl(javax.media.nativewindow.util.Insets insets) {
        Insets insets2 = this.container.getInsets();
        insets.setLeftWidth(insets2.left);
        insets.setRightWidth(insets2.right);
        insets.setTopHeight(insets2.top);
        insets.setBottomHeight(insets2.bottom);
    }

    @Override
    protected boolean reconfigureWindowImpl(int n, int n2, int n3, int n4, int n5) {
        if (0 != (2 & n5) && null != this.frame) {
            if (!this.container.isDisplayable()) {
                this.frame.setUndecorated(this.isUndecorated());
            } else if (DEBUG_IMPLEMENTATION) {
                System.err.println("AWTWindow can't undecorate already created frame");
            }
        }
        if (0 != (0x10 & n5)) {
            this.container.setVisible(0 != (0x1000 & n5));
        }
        n = n >= 0 ? n : this.x;
        n2 = n >= 0 ? n2 : this.y;
        n3 = n3 > 0 ? n3 : this.width;
        n4 = n4 > 0 ? n4 : this.height;
        this.container.setLocation(n, n2);
        Insets insets = this.container.getInsets();
        this.container.setSize(n3 + insets.left + insets.right, n4 + insets.top + insets.bottom);
        if (0 != (0x10 & n5)) {
            if (0 != (0x1000 & n5) && !this.hasDeviceChanged()) {
                AWTGraphicsConfiguration aWTGraphicsConfiguration = this.canvas.getAWTGraphicsConfiguration();
                if (null == aWTGraphicsConfiguration) {
                    throw new NativeWindowException("Error: !hasDeviceChanged && null == GraphicsConfiguration: " + this);
                }
                this.setGraphicsConfiguration(aWTGraphicsConfiguration);
            }
            this.visibleChanged(false, 0 != (0x1000 & n5));
        }
        return true;
    }

    @Override
    protected Point getLocationOnScreenImpl(int n, int n2) {
        java.awt.Point point = this.canvas.getLocationOnScreen();
        point.translate(n, n2);
        return new Point((int)(point.getX() + 0.5), (int)(point.getY() + 0.5));
    }

    @Override
    public Object getWrappedWindow() {
        return this.canvas;
    }

    class LocalWindowListener
    extends WindowAdapter {
        LocalWindowListener() {
        }

        @Override
        public void windowMoved(WindowEvent windowEvent) {
            if (null != AWTWindow.this.container) {
                AWTWindow.this.x = AWTWindow.this.container.getX();
                AWTWindow.this.y = AWTWindow.this.container.getY();
            }
        }

        @Override
        public void windowResized(WindowEvent windowEvent) {
            if (null != AWTWindow.this.canvas) {
                AWTWindow.this.width = AWTWindow.this.canvas.getWidth();
                AWTWindow.this.height = AWTWindow.this.canvas.getHeight();
            }
        }
    }
}

