/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl;

import java.nio.ByteBuffer;
import java.util.HashMap;

public class MemoryObject {
    private long addr;
    private long size;
    private int hash32;
    private ByteBuffer buffer = null;

    public MemoryObject(long l, long l2) {
        this.addr = l;
        this.size = l2;
        this.hash32 = MemoryObject.getHash32(l, l2);
    }

    public void setBuffer(ByteBuffer byteBuffer) {
        this.buffer = byteBuffer;
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public int hashCode() {
        return this.hash32;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof MemoryObject) {
            MemoryObject memoryObject = (MemoryObject)object;
            return this.addr == memoryObject.addr && this.size == memoryObject.size;
        }
        return false;
    }

    public static int getHash32(long l, long l2) {
        int n = 31 + (int)l;
        n = (n << 5) - n + (int)(l >>> 32);
        n = (n << 5) - n + (int)l2;
        n = (n << 5) - n + (int)(l2 >>> 32);
        return n;
    }

    public static long getHash64(long l, long l2) {
        long l3 = 31L + l;
        return (l3 << 5) - l3 + l2;
    }

    public String toString() {
        return "MemoryObject[addr 0x" + Long.toHexString(this.addr) + ", size 0x" + Long.toHexString(this.size) + ", hash32: 0x" + Integer.toHexString(this.hash32) + "]";
    }

    public static MemoryObject getOrAddSafe(HashMap hashMap, MemoryObject memoryObject) {
        MemoryObject memoryObject2 = (MemoryObject)hashMap.get(memoryObject);
        if (null == memoryObject2) {
            hashMap.put(memoryObject, memoryObject);
            memoryObject2 = memoryObject;
        }
        return memoryObject2;
    }
}

