/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.egl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.PointerBuffer;
import java.io.PrintStream;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.CapabilitiesChooser;
import javax.media.nativewindow.CapabilitiesImmutable;
import javax.media.nativewindow.DefaultGraphicsScreen;
import javax.media.nativewindow.GraphicsConfigurationFactory;
import javax.media.nativewindow.egl.EGLGraphicsDevice;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import jogamp.opengl.GLGraphicsConfigurationFactory;
import jogamp.opengl.GLGraphicsConfigurationUtil;
import jogamp.opengl.egl.EGL;
import jogamp.opengl.egl.EGLDrawableFactory;
import jogamp.opengl.egl.EGLGLCapabilities;
import jogamp.opengl.egl.EGLGraphicsConfiguration;

public class EGLGraphicsConfigurationFactory
extends GLGraphicsConfigurationFactory {
    static EGLGLCapabilities.EglCfgIDComparator EglCfgIDComparator = new EGLGLCapabilities.EglCfgIDComparator();

    static void registerFactory() {
        GraphicsConfigurationFactory.registerFactory(EGLGraphicsDevice.class, new EGLGraphicsConfigurationFactory());
    }

    private EGLGraphicsConfigurationFactory() {
    }

    @Override
    protected AbstractGraphicsConfiguration chooseGraphicsConfigurationImpl(CapabilitiesImmutable capabilitiesImmutable, CapabilitiesImmutable capabilitiesImmutable2, CapabilitiesChooser capabilitiesChooser, AbstractGraphicsScreen abstractGraphicsScreen) {
        if (abstractGraphicsScreen == null) {
            throw new IllegalArgumentException("This NativeWindowFactory accepts only AbstractGraphicsDevice objects");
        }
        if (!(capabilitiesImmutable instanceof GLCapabilitiesImmutable)) {
            throw new IllegalArgumentException("This NativeWindowFactory accepts only GLCapabilities objects - chosen");
        }
        if (!(capabilitiesImmutable2 instanceof GLCapabilitiesImmutable)) {
            throw new IllegalArgumentException("This NativeWindowFactory accepts only GLCapabilities objects - requested");
        }
        if (capabilitiesChooser != null && !(capabilitiesChooser instanceof GLCapabilitiesChooser)) {
            throw new IllegalArgumentException("This NativeWindowFactory accepts only GLCapabilitiesChooser objects");
        }
        return EGLGraphicsConfigurationFactory.chooseGraphicsConfigurationStatic((GLCapabilitiesImmutable)capabilitiesImmutable, (GLCapabilitiesImmutable)capabilitiesImmutable2, (GLCapabilitiesChooser)capabilitiesChooser, abstractGraphicsScreen, -1);
    }

    protected static List<GLCapabilitiesImmutable> getAvailableCapabilities(EGLDrawableFactory eGLDrawableFactory, AbstractGraphicsDevice abstractGraphicsDevice) {
        EGLDrawableFactory.SharedResource sharedResource = eGLDrawableFactory.getOrCreateEGLSharedResource(abstractGraphicsDevice);
        if (null == sharedResource) {
            throw new GLException("Shared resource for device n/a: " + abstractGraphicsDevice);
        }
        EGLGraphicsDevice eGLGraphicsDevice = sharedResource.getDevice();
        long l = eGLGraphicsDevice.getHandle();
        List list = null;
        IntBuffer intBuffer = Buffers.newDirectIntBuffer((int)1);
        if (!EGL.eglGetConfigs(l, null, 0, intBuffer)) {
            throw new GLException("Graphics configuration get maxConfigs (eglGetConfigs) call failed, error " + EGLGraphicsConfigurationFactory.toHexString(EGL.eglGetError()));
        }
        if (0 == intBuffer.get(0)) {
            throw new GLException("Graphics configuration get maxConfigs (eglGetConfigs) no configs");
        }
        PointerBuffer pointerBuffer = PointerBuffer.allocateDirect((int)intBuffer.get(0));
        if (!EGL.eglGetConfigs(l, pointerBuffer, pointerBuffer.capacity(), intBuffer)) {
            throw new GLException("Graphics configuration get all configs (eglGetConfigs) call failed, error " + EGLGraphicsConfigurationFactory.toHexString(EGL.eglGetError()));
        }
        if (intBuffer.get(0) > 0 && null != (list = EGLGraphicsConfigurationFactory.eglConfigs2GLCaps(null, l, pointerBuffer, intBuffer.get(0), 7)) && list.size() > 1) {
            Collections.sort(list, EglCfgIDComparator);
        }
        return list;
    }

    public static EGLGraphicsConfiguration chooseGraphicsConfigurationStatic(GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesImmutable gLCapabilitiesImmutable2, GLCapabilitiesChooser gLCapabilitiesChooser, AbstractGraphicsScreen abstractGraphicsScreen, int n) {
        if (gLCapabilitiesImmutable == null) {
            gLCapabilitiesImmutable = new GLCapabilities(null);
        }
        if (null == abstractGraphicsScreen) {
            throw new GLException("Null AbstractGraphicsScreen");
        }
        AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsScreen.getDevice();
        if (null == abstractGraphicsDevice || !(abstractGraphicsDevice instanceof EGLGraphicsDevice)) {
            throw new GLException("GraphicsDevice must be a valid EGLGraphicsDevice");
        }
        long l = abstractGraphicsDevice.getHandle();
        if (l == 0L) {
            throw new GLException("Invalid EGL display: " + abstractGraphicsDevice);
        }
        EGLDrawableFactory eGLDrawableFactory = (EGLDrawableFactory)GLDrawableFactory.getEGLFactory();
        gLCapabilitiesImmutable = GLGraphicsConfigurationUtil.fixGLCapabilities(gLCapabilitiesImmutable, eGLDrawableFactory.canCreateGLPbuffer(abstractGraphicsDevice));
        GLProfile gLProfile = gLCapabilitiesImmutable.getGLProfile();
        EGLGraphicsConfiguration eGLGraphicsConfiguration = EGLGraphicsConfigurationFactory.eglChooseConfig(l, gLCapabilitiesImmutable, gLCapabilitiesImmutable2, gLCapabilitiesChooser, abstractGraphicsScreen, n);
        if (null != eGLGraphicsConfiguration) {
            return eGLGraphicsConfiguration;
        }
        if (DEBUG) {
            System.err.println("eglChooseConfig failed with given capabilities " + gLCapabilitiesImmutable);
        }
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setRedBits(8);
        gLCapabilities.setGreenBits(8);
        gLCapabilities.setBlueBits(8);
        gLCapabilities.setDepthBits(16);
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setNumSamples(4);
        if (DEBUG) {
            System.err.println("trying fixed caps (1): " + gLCapabilities);
        }
        if (null != (eGLGraphicsConfiguration = EGLGraphicsConfigurationFactory.eglChooseConfig(l, gLCapabilities, gLCapabilitiesImmutable2, gLCapabilitiesChooser, abstractGraphicsScreen, n))) {
            return eGLGraphicsConfiguration;
        }
        gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setRedBits(5);
        gLCapabilities.setGreenBits(6);
        gLCapabilities.setBlueBits(5);
        gLCapabilities.setDepthBits(16);
        if (DEBUG) {
            System.err.println("trying fixed caps (2): " + gLCapabilities);
        }
        if (null != (eGLGraphicsConfiguration = EGLGraphicsConfigurationFactory.eglChooseConfig(l, gLCapabilities, gLCapabilitiesImmutable2, gLCapabilitiesChooser, abstractGraphicsScreen, n))) {
            return eGLGraphicsConfiguration;
        }
        gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setRedBits(5);
        gLCapabilities.setGreenBits(6);
        gLCapabilities.setBlueBits(5);
        gLCapabilities.setDepthBits(16);
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setNumSamples(4);
        if (DEBUG) {
            System.err.println("trying fixed caps (3): " + gLCapabilities);
        }
        if (null != (eGLGraphicsConfiguration = EGLGraphicsConfigurationFactory.eglChooseConfig(l, gLCapabilities, gLCapabilitiesImmutable2, gLCapabilitiesChooser, abstractGraphicsScreen, n))) {
            return eGLGraphicsConfiguration;
        }
        throw new GLException("Graphics configuration failed [direct caps, eglGetConfig/chooser and fixed-caps(1-3)]");
    }

    static EGLGraphicsConfiguration eglChooseConfig(long l, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesImmutable gLCapabilitiesImmutable2, GLCapabilitiesChooser gLCapabilitiesChooser, AbstractGraphicsScreen abstractGraphicsScreen, int n) {
        int n2;
        GLProfile gLProfile = gLCapabilitiesImmutable.getGLProfile();
        boolean bl = gLCapabilitiesImmutable.isOnscreen();
        boolean bl2 = gLCapabilitiesImmutable.isPBuffer();
        int n3 = GLGraphicsConfigurationUtil.getWinAttributeBits(bl, bl2);
        List list = null;
        int n4 = -1;
        long l2 = -1L;
        IntBuffer intBuffer = Buffers.newDirectIntBuffer((int)1);
        if (!EGL.eglGetConfigs(l, null, 0, intBuffer)) {
            throw new GLException("EGLGraphicsConfiguration.eglChooseConfig: Get maxConfigs (eglGetConfigs) call failed, error " + EGLGraphicsConfigurationFactory.toHexString(EGL.eglGetError()));
        }
        if (0 == intBuffer.get(0)) {
            throw new GLException("EGLGraphicsConfiguration.eglChooseConfig: Get maxConfigs (eglGetConfigs) no configs");
        }
        if (DEBUG) {
            System.err.println("EGLGraphicsConfiguration.eglChooseConfig: eglChooseConfig maxConfigs: " + intBuffer.get(0));
            System.err.println("EGLGraphicsConfiguration.eglChooseConfig: eglDisplay " + EGLGraphicsConfigurationFactory.toHexString(l) + ", " + gLCapabilitiesImmutable);
        }
        IntBuffer intBuffer2 = Buffers.newDirectIntBuffer((int[])EGLGraphicsConfiguration.GLCapabilities2AttribList(gLCapabilitiesImmutable));
        PointerBuffer pointerBuffer = PointerBuffer.allocateDirect((int)intBuffer.get(0));
        if (0 <= n || !EGL.eglChooseConfig(l, intBuffer2, pointerBuffer, pointerBuffer.capacity(), intBuffer)) {
            if (DEBUG) {
                System.err.println("EGLGraphicsConfiguration.eglChooseConfig: #1 eglChooseConfig: false");
            }
        } else if (intBuffer.get(0) > 0) {
            list = EGLGraphicsConfigurationFactory.eglConfigs2GLCaps(gLProfile, l, pointerBuffer, intBuffer.get(0), n3);
            if (list.size() > 0) {
                l2 = pointerBuffer.get(0);
                n4 = 0;
                if (DEBUG) {
                    System.err.println("EGLGraphicsConfiguration.eglChooseConfig: #1 eglChooseConfig: recommended fbcfg " + EGLGraphicsConfigurationFactory.toHexString(l2) + ", idx " + n4);
                    System.err.println("EGLGraphicsConfiguration.eglChooseConfig: #1 fbcfg caps " + list.get(n4));
                }
            } else if (DEBUG) {
                System.err.println("EGLGraphicsConfiguration.eglChooseConfig: #1 eglChooseConfig: no caps for recommended fbcfg " + EGLGraphicsConfigurationFactory.toHexString(pointerBuffer.get(0)));
            }
        } else if (DEBUG) {
            System.err.println("EGLGraphicsConfiguration.eglChooseConfig: #1 eglChooseConfig: no configs");
        }
        if (null == list || 0 == list.size()) {
            l2 = -1L;
            n4 = -1;
            if (!EGL.eglGetConfigs(l, pointerBuffer, pointerBuffer.capacity(), intBuffer)) {
                throw new GLException("EGLGraphicsConfiguration.eglChooseConfig: #2 Get all configs (eglGetConfigs) call failed, error " + EGLGraphicsConfigurationFactory.toHexString(EGL.eglGetError()));
            }
            if (intBuffer.get(0) > 0) {
                list = EGLGraphicsConfigurationFactory.eglConfigs2GLCaps(gLProfile, l, pointerBuffer, intBuffer.get(0), n3);
            }
        }
        if (null == list || 0 == list.size()) {
            if (DEBUG) {
                System.err.println("EGLGraphicsConfiguration.eglChooseConfig: #2 Graphics configuration 1st choice and 2nd choice failed - no configs");
            }
            return null;
        }
        if (DEBUG) {
            System.err.println("EGLGraphicsConfiguration.eglChooseConfig: got configs: " + list.size());
            for (n2 = 0; n2 < list.size(); ++n2) {
                System.err.println(n2 + ": " + list.get(n2));
            }
        }
        if (0 <= n) {
            ArrayList arrayList = new ArrayList();
            int n5 = 0;
            while (n5 < list.size()) {
                EGLGLCapabilities eGLGLCapabilities = (EGLGLCapabilities)list.get(n5);
                if (eGLGLCapabilities.getNativeVisualID() != n) {
                    arrayList.add(list.remove(n5));
                    continue;
                }
                ++n5;
            }
            if (0 == list.size()) {
                list = arrayList;
                if (DEBUG) {
                    System.err.println("EGLGraphicsConfiguration.eglChooseConfig: post filter nativeVisualID (" + n + ") no config found, revert to all");
                }
            } else if (DEBUG) {
                System.err.println("EGLGraphicsConfiguration.eglChooseConfig: post filter nativeVisualID (" + n + ") got configs: " + list.size());
            }
        }
        if (0 > (n2 = EGLGraphicsConfigurationFactory.chooseCapabilities(gLCapabilitiesChooser, gLCapabilitiesImmutable, list, n4))) {
            if (DEBUG) {
                System.err.println("EGLGraphicsConfiguration.eglChooseConfig: #2 chooseCapabilities failed");
            }
            return null;
        }
        EGLGLCapabilities eGLGLCapabilities = (EGLGLCapabilities)list.get(n2);
        if (DEBUG) {
            System.err.println("EGLGraphicsConfiguration.eglChooseConfig: X chosen :" + n2 + ", eglConfig: " + EGLGraphicsConfigurationFactory.toHexString(eGLGLCapabilities.getEGLConfig()) + ", " + eGLGLCapabilities);
        }
        return new EGLGraphicsConfiguration(abstractGraphicsScreen, eGLGLCapabilities, gLCapabilitiesImmutable2, gLCapabilitiesChooser);
    }

    static List eglConfigs2GLCaps(GLProfile gLProfile, long l, PointerBuffer pointerBuffer, int n, int n2) {
        ArrayList arrayList = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            EGLGraphicsConfiguration.EGLConfig2Capabilities(arrayList, gLProfile, l, pointerBuffer.get(i), n2);
        }
        return arrayList;
    }

    static void printCaps(String string, List list, PrintStream printStream) {
        for (int i = 0; i < list.size(); ++i) {
            printStream.println(string + "[" + i + "] " + list.get(i));
        }
    }

    static EGLGraphicsConfiguration createOffscreenGraphicsConfiguration(AbstractGraphicsDevice abstractGraphicsDevice, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesImmutable gLCapabilitiesImmutable2, GLCapabilitiesChooser gLCapabilitiesChooser) {
        EGLGraphicsConfiguration eGLGraphicsConfiguration;
        Cloneable cloneable;
        if (gLCapabilitiesImmutable.isOnscreen()) {
            throw new GLException("Error: Onscreen set: " + gLCapabilitiesImmutable);
        }
        if (gLCapabilitiesImmutable.getDoubleBuffered()) {
            cloneable = (GLCapabilities)gLCapabilitiesImmutable.cloneMutable();
            cloneable.setDoubleBuffered(false);
            gLCapabilitiesImmutable = cloneable;
        }
        if (null == (eGLGraphicsConfiguration = EGLGraphicsConfigurationFactory.chooseGraphicsConfigurationStatic(gLCapabilitiesImmutable, gLCapabilitiesImmutable2, gLCapabilitiesChooser, (AbstractGraphicsScreen)(cloneable = new DefaultGraphicsScreen(abstractGraphicsDevice, 0)), -1))) {
            throw new GLException("Couldn't create EGLGraphicsConfiguration from " + cloneable);
        }
        if (DEBUG) {
            System.err.println("Chosen eglConfig: " + eGLGraphicsConfiguration);
        }
        return eGLGraphicsConfiguration;
    }
}

