/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.macosx.cgl;

import com.jogamp.common.nio.PointerBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import jogamp.nativewindow.MutableGraphicsConfiguration;
import jogamp.opengl.macosx.cgl.CGL;
import jogamp.opengl.macosx.cgl.MacOSXCGLContext;
import jogamp.opengl.macosx.cgl.MacOSXCGLDrawableFactory;

public class MacOSXCGLGraphicsConfiguration
extends MutableGraphicsConfiguration
implements Cloneable {
    long pixelformat;
    static final int[] cglInternalAttributeToken = new int[]{99, 58, 72, 73, 90, 5, 6, 8, 11, 12, 14, 13, 55, 56};

    MacOSXCGLGraphicsConfiguration(AbstractGraphicsScreen abstractGraphicsScreen, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesImmutable gLCapabilitiesImmutable2, long l) {
        super(abstractGraphicsScreen, gLCapabilitiesImmutable, gLCapabilitiesImmutable2);
        this.pixelformat = l;
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    void setChosenPixelFormat(long l) {
        this.pixelformat = l;
    }

    protected static List<GLCapabilitiesImmutable> getAvailableCapabilities(MacOSXCGLDrawableFactory macOSXCGLDrawableFactory, AbstractGraphicsDevice abstractGraphicsDevice) {
        MacOSXCGLDrawableFactory.SharedResource sharedResource = macOSXCGLDrawableFactory.getOrCreateOSXSharedResource(abstractGraphicsDevice);
        if (null == sharedResource) {
            throw new GLException("Shared resource for device n/a: " + abstractGraphicsDevice);
        }
        return new ArrayList<GLCapabilitiesImmutable>(0);
    }

    static int[] GLCapabilities2NSAttribList(GLCapabilitiesImmutable gLCapabilitiesImmutable, int n, int n2, int n3) {
        int n4 = cglInternalAttributeToken.length;
        int n5 = 0;
        if (!MacOSXCGLContext.isLionOrLater) {
            ++n5;
            --n4;
        }
        int[] nArray = new int[n4];
        block16: for (int i = 0; i < n4; ++i) {
            int n6 = cglInternalAttributeToken[i + n5];
            switch (n6) {
                case 99: {
                    nArray[i] = MacOSXCGLContext.GLProfile2CGLOGLProfileValue(n, n2, n3);
                    continue block16;
                }
                case 58: {
                    nArray[i] = gLCapabilitiesImmutable.getPbufferFloatingPointBuffers() ? 1 : 0;
                    continue block16;
                }
                case 72: {
                    nArray[i] = gLCapabilitiesImmutable.getHardwareAccelerated() ? 1 : 0;
                    continue block16;
                }
                case 73: {
                    nArray[i] = gLCapabilitiesImmutable.getHardwareAccelerated() ? 1 : 0;
                    continue block16;
                }
                case 90: {
                    nArray[i] = gLCapabilitiesImmutable.isPBuffer() ? 1 : 0;
                    continue block16;
                }
                case 5: {
                    nArray[i] = gLCapabilitiesImmutable.getDoubleBuffered() ? 1 : 0;
                    continue block16;
                }
                case 6: {
                    nArray[i] = gLCapabilitiesImmutable.getStereo() ? 1 : 0;
                    continue block16;
                }
                case 8: {
                    nArray[i] = gLCapabilitiesImmutable.getRedBits() + gLCapabilitiesImmutable.getGreenBits() + gLCapabilitiesImmutable.getBlueBits();
                    continue block16;
                }
                case 11: {
                    nArray[i] = gLCapabilitiesImmutable.getAlphaBits();
                    continue block16;
                }
                case 12: {
                    nArray[i] = gLCapabilitiesImmutable.getDepthBits();
                    continue block16;
                }
                case 14: {
                    nArray[i] = gLCapabilitiesImmutable.getAccumRedBits() + gLCapabilitiesImmutable.getAccumGreenBits() + gLCapabilitiesImmutable.getAccumBlueBits() + gLCapabilitiesImmutable.getAccumAlphaBits();
                    continue block16;
                }
                case 13: {
                    nArray[i] = gLCapabilitiesImmutable.getStencilBits();
                    continue block16;
                }
                case 55: {
                    nArray[i] = gLCapabilitiesImmutable.getSampleBuffers() ? 1 : 0;
                    continue block16;
                }
                case 56: {
                    nArray[i] = gLCapabilitiesImmutable.getSampleBuffers() ? gLCapabilitiesImmutable.getNumSamples() : 0;
                    continue block16;
                }
            }
        }
        return nArray;
    }

    static long GLCapabilities2NSPixelFormat(GLCapabilitiesImmutable gLCapabilitiesImmutable, int n, int n2, int n3) {
        int n4 = cglInternalAttributeToken.length;
        int n5 = 0;
        if (!MacOSXCGLContext.isLionOrLater) {
            ++n5;
            --n4;
        }
        int[] nArray = MacOSXCGLGraphicsConfiguration.GLCapabilities2NSAttribList(gLCapabilitiesImmutable, n, n2, n3);
        return CGL.createPixelFormat(cglInternalAttributeToken, n5, n4, nArray, 0);
    }

    static GLCapabilitiesImmutable NSPixelFormat2GLCapabilities(GLProfile gLProfile, long l) {
        return MacOSXCGLGraphicsConfiguration.PixelFormat2GLCapabilities(gLProfile, l, true);
    }

    static long GLCapabilities2CGLPixelFormat(GLCapabilitiesImmutable gLCapabilitiesImmutable, int n, int n2, int n3) {
        int[] nArray;
        PointerBuffer pointerBuffer;
        int n4;
        int[] nArray2 = new int[256];
        int n5 = 0;
        if (MacOSXCGLContext.isLionOrLater) {
            nArray2[n5++] = 99;
            nArray2[n5++] = MacOSXCGLContext.GLProfile2CGLOGLProfileValue(n, n2, n3);
        }
        if (gLCapabilitiesImmutable.isPBuffer()) {
            nArray2[n5++] = 90;
        }
        if (gLCapabilitiesImmutable.getPbufferFloatingPointBuffers()) {
            nArray2[n5++] = 58;
        }
        if (gLCapabilitiesImmutable.getDoubleBuffered()) {
            nArray2[n5++] = 5;
        }
        if (gLCapabilitiesImmutable.getStereo()) {
            nArray2[n5++] = 6;
        }
        nArray2[n5++] = 8;
        nArray2[n5++] = gLCapabilitiesImmutable.getRedBits() + gLCapabilitiesImmutable.getGreenBits() + gLCapabilitiesImmutable.getBlueBits();
        nArray2[n5++] = 11;
        nArray2[n5++] = gLCapabilitiesImmutable.getAlphaBits();
        nArray2[n5++] = 12;
        nArray2[n5++] = gLCapabilitiesImmutable.getDepthBits();
        nArray2[n5++] = 13;
        nArray2[n5++] = gLCapabilitiesImmutable.getStencilBits();
        nArray2[n5++] = 14;
        nArray2[n5++] = gLCapabilitiesImmutable.getAccumRedBits() + gLCapabilitiesImmutable.getAccumGreenBits() + gLCapabilitiesImmutable.getAccumBlueBits() + gLCapabilitiesImmutable.getAccumAlphaBits();
        if (gLCapabilitiesImmutable.getSampleBuffers()) {
            nArray2[n5++] = 55;
            nArray2[n5++] = 1;
            nArray2[n5++] = 56;
            nArray2[n5++] = gLCapabilitiesImmutable.getNumSamples();
        }
        if ((n4 = CGL.CGLChoosePixelFormat(nArray2, 0, pointerBuffer = PointerBuffer.allocateDirect((int)1), nArray = new int[1], 0)) != 0) {
            throw new GLException("Error code " + n4 + " while choosing pixel format");
        }
        return pointerBuffer.get(0);
    }

    static GLCapabilitiesImmutable CGLPixelFormat2GLCapabilities(long l) {
        return MacOSXCGLGraphicsConfiguration.PixelFormat2GLCapabilities(null, l, false);
    }

    private static GLCapabilitiesImmutable PixelFormat2GLCapabilities(GLProfile gLProfile, long l, boolean bl) {
        int n = cglInternalAttributeToken.length;
        int n2 = 0;
        if (!MacOSXCGLContext.isLionOrLater) {
            ++n2;
            --n;
        }
        int[] nArray = new int[n];
        if (bl) {
            CGL.queryPixelFormat(l, cglInternalAttributeToken, n2, n, nArray, 0);
        } else {
            CGL.CGLQueryPixelFormat(l, cglInternalAttributeToken, n2, n, nArray, 0);
        }
        if (null == gLProfile && MacOSXCGLContext.isLionOrLater) {
            block18: for (int i = 0; i < n; ++i) {
                if (99 != cglInternalAttributeToken[i + n2]) continue;
                switch (nArray[i]) {
                    case 12800: {
                        gLProfile = GLProfile.get("GL3");
                        continue block18;
                    }
                    case 4096: {
                        gLProfile = GLProfile.get("GL2");
                        continue block18;
                    }
                    default: {
                        throw new RuntimeException("Unhandled OSX OpenGL Profile: 0x" + Integer.toHexString(nArray[i]));
                    }
                }
            }
        }
        if (null == gLProfile) {
            gLProfile = GLProfile.get("GL2");
        }
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        block19: for (int i = 0; i < n; ++i) {
            int n3 = cglInternalAttributeToken[i + n2];
            switch (n3) {
                case 58: {
                    gLCapabilities.setPbufferFloatingPointBuffers(nArray[i] != 0);
                    continue block19;
                }
                case 73: {
                    gLCapabilities.setHardwareAccelerated(nArray[i] != 0);
                    continue block19;
                }
                case 90: {
                    gLCapabilities.setPBuffer(nArray[i] != 0);
                    continue block19;
                }
                case 5: {
                    gLCapabilities.setDoubleBuffered(nArray[i] != 0);
                    continue block19;
                }
                case 6: {
                    gLCapabilities.setStereo(nArray[i] != 0);
                    continue block19;
                }
                case 8: {
                    int n4 = nArray[i];
                    if (n4 == 32) {
                        n4 = 24;
                    }
                    gLCapabilities.setRedBits(n4 /= 3);
                    gLCapabilities.setGreenBits(n4);
                    gLCapabilities.setBlueBits(n4);
                    continue block19;
                }
                case 11: {
                    gLCapabilities.setAlphaBits(nArray[i]);
                    continue block19;
                }
                case 12: {
                    gLCapabilities.setDepthBits(nArray[i]);
                    continue block19;
                }
                case 14: {
                    int n4 = nArray[i] / 4;
                    gLCapabilities.setAccumRedBits(n4);
                    gLCapabilities.setAccumGreenBits(n4);
                    gLCapabilities.setAccumBlueBits(n4);
                    gLCapabilities.setAccumAlphaBits(n4);
                    continue block19;
                }
                case 13: {
                    gLCapabilities.setStencilBits(nArray[i]);
                    continue block19;
                }
                case 55: {
                    gLCapabilities.setSampleBuffers(nArray[i] != 0);
                    continue block19;
                }
                case 56: {
                    gLCapabilities.setNumSamples(nArray[i]);
                    continue block19;
                }
            }
        }
        return gLCapabilities;
    }
}

