/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl;

import com.jogamp.common.AutoCloseable;
import com.jogamp.common.nio.CachedBufferFactory;
import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.opencl.CLContext;
import com.jogamp.opencl.CLEvent;
import com.jogamp.opencl.CLResource;
import java.util.Iterator;

public final class CLEventList
implements CLResource,
AutoCloseable,
Iterable<CLEvent> {
    private final CLEvent[] events;
    final PointerBuffer IDs;
    final PointerBuffer IDsView;
    int size;

    public CLEventList(int n) {
        this(null, n);
    }

    public CLEventList(CLEvent ... cLEventArray) {
        this((CachedBufferFactory)null, cLEventArray);
    }

    public CLEventList(CachedBufferFactory cachedBufferFactory, int n) {
        this.events = new CLEvent[n];
        this.IDs = this.initIDBuffer(cachedBufferFactory, n);
        this.IDsView = this.IDs.duplicate();
    }

    public CLEventList(CachedBufferFactory cachedBufferFactory, CLEvent ... cLEventArray) {
        this.events = cLEventArray;
        this.IDs = this.initIDBuffer(cachedBufferFactory, cLEventArray.length);
        this.IDsView = this.IDs.duplicate();
        for (CLEvent cLEvent : cLEventArray) {
            if (cLEvent == null) {
                throw new IllegalArgumentException("event list containes null element.");
            }
            this.IDs.put(cLEvent.ID);
        }
        this.IDs.rewind();
        this.size = cLEventArray.length;
    }

    private PointerBuffer initIDBuffer(CachedBufferFactory cachedBufferFactory, int n) {
        if (cachedBufferFactory == null) {
            return PointerBuffer.allocateDirect(n);
        }
        return PointerBuffer.wrap(cachedBufferFactory.newDirectByteBuffer(n * PointerBuffer.ELEMENT_SIZE));
    }

    void createEvent(CLContext cLContext) {
        if (this.events[this.size] != null) {
            this.events[this.size].release();
        }
        this.events[this.size] = new CLEvent(cLContext, this.IDs.get());
        ++this.size;
    }

    PointerBuffer getEventBuffer(int n) {
        return this.IDs.duplicate();
    }

    public void waitForEvents() {
        if (this.size > 0) {
            this.events[0].getPlatform().getEventBinding().clWaitForEvents(this.size, this.IDsView);
        }
    }

    public void waitForEvents(int n, int n2) {
        if (n + n2 < this.size || n2 <= 0) {
            throw new IndexOutOfBoundsException("args: [start: " + n + " range: " + n2 + "], eventcount: " + this.size);
        }
        PointerBuffer pointerBuffer = this.getEventBuffer(n);
        this.getEvent(n).getPlatform().getEventBinding().clWaitForEvents(n2, pointerBuffer);
    }

    public void waitForEvent(int n) {
        PointerBuffer pointerBuffer = this.getEventBuffer(n);
        this.getEvent(n).getPlatform().getEventBinding().clWaitForEvents(1, pointerBuffer);
    }

    @Override
    public void release() {
        for (int i = 0; i < this.size; ++i) {
            this.events[i].release();
            this.events[i] = null;
        }
        this.size = 0;
        this.IDs.rewind();
    }

    @Override
    @Deprecated
    public final void close() throws Exception {
        this.release();
    }

    public CLEvent getEvent(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException("list contains " + this.size + " events, can not return event with index " + n);
        }
        return this.events[n];
    }

    public int size() {
        return this.size;
    }

    public int capacity() {
        return this.events.length;
    }

    @Override
    public boolean isReleased() {
        return this.size == 0;
    }

    @Override
    public Iterator<CLEvent> iterator() {
        return new EventIterator(this.events, this.size);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getName()).append('[');
        for (int i = 0; i < this.size; ++i) {
            stringBuilder.append(this.events[i].toString());
            if (i + 1 == this.size) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.append(']').toString();
    }

    private static class EventIterator
    implements Iterator<CLEvent> {
        private final CLEvent[] events;
        private final int size;
        private int index;

        private EventIterator(CLEvent[] cLEventArray, int n) {
            this.events = cLEventArray;
            this.size = n;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.size;
        }

        @Override
        public CLEvent next() {
            if (this.hasNext()) {
                return this.events[this.index++];
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove() not supported.");
        }
    }
}

