/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow.x11.awt;

import com.jogamp.nativewindow.awt.AWTGraphicsConfiguration;
import com.jogamp.nativewindow.awt.AWTGraphicsDevice;
import com.jogamp.nativewindow.awt.AWTGraphicsScreen;
import com.jogamp.nativewindow.x11.X11GraphicsDevice;
import com.jogamp.nativewindow.x11.X11GraphicsScreen;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.CapabilitiesChooser;
import javax.media.nativewindow.CapabilitiesImmutable;
import javax.media.nativewindow.GraphicsConfigurationFactory;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.NativeWindowFactory;
import javax.media.nativewindow.ToolkitLock;
import javax.media.nativewindow.VisualIDHolder;
import jogamp.nativewindow.jawt.x11.X11SunJDKReflection;
import jogamp.nativewindow.x11.X11Lib;
import jogamp.nativewindow.x11.X11Util;

public class X11AWTGraphicsConfigurationFactory
extends GraphicsConfigurationFactory {
    public static void registerFactory() {
        GraphicsConfigurationFactory.registerFactory(AWTGraphicsDevice.class, new X11AWTGraphicsConfigurationFactory());
    }

    private X11AWTGraphicsConfigurationFactory() {
    }

    @Override
    protected AbstractGraphicsConfiguration chooseGraphicsConfigurationImpl(CapabilitiesImmutable capabilitiesImmutable, CapabilitiesImmutable capabilitiesImmutable2, CapabilitiesChooser capabilitiesChooser, AbstractGraphicsScreen abstractGraphicsScreen) {
        if (abstractGraphicsScreen != null && !(abstractGraphicsScreen instanceof AWTGraphicsScreen)) {
            throw new IllegalArgumentException("This GraphicsConfigurationFactory accepts only AWTGraphicsScreen objects");
        }
        if (null == abstractGraphicsScreen) {
            abstractGraphicsScreen = AWTGraphicsScreen.createDefault();
        }
        return X11AWTGraphicsConfigurationFactory.chooseGraphicsConfigurationStatic(capabilitiesImmutable, capabilitiesImmutable2, capabilitiesChooser, (AWTGraphicsScreen)abstractGraphicsScreen);
    }

    public static AWTGraphicsConfiguration chooseGraphicsConfigurationStatic(CapabilitiesImmutable capabilitiesImmutable, CapabilitiesImmutable capabilitiesImmutable2, CapabilitiesChooser capabilitiesChooser, AWTGraphicsScreen aWTGraphicsScreen) {
        GraphicsConfiguration graphicsConfiguration;
        GraphicsConfigurationFactory graphicsConfigurationFactory;
        AbstractGraphicsConfiguration abstractGraphicsConfiguration;
        Object object;
        long l;
        if (DEBUG) {
            System.err.println("X11AWTGraphicsConfigurationFactory: got " + aWTGraphicsScreen);
        }
        GraphicsDevice graphicsDevice = ((AWTGraphicsDevice)aWTGraphicsScreen.getDevice()).getGraphicsDevice();
        long l2 = X11SunJDKReflection.graphicsDeviceGetDisplay(graphicsDevice);
        boolean bl = false;
        if (0L == l2) {
            l = X11Util.openDisplay(null);
            bl = true;
            if (DEBUG) {
                System.err.println(X11AWTGraphicsConfigurationFactory.getThreadName() + " - X11AWTGraphicsConfigurationFactory: Null AWT dpy, create local X11 display: " + X11AWTGraphicsConfigurationFactory.toHexString(l));
            }
        } else {
            object = X11Lib.XDisplayString(l2);
            l = X11Util.openDisplay((String)object);
            bl = true;
            if (DEBUG) {
                System.err.println(X11AWTGraphicsConfigurationFactory.getThreadName() + " - X11AWTGraphicsConfigurationFactory: AWT dpy " + (String)object + " / " + X11AWTGraphicsConfigurationFactory.toHexString(l2) + ", create X11 display " + X11AWTGraphicsConfigurationFactory.toHexString(l));
            }
        }
        object = bl ? NativeWindowFactory.getDefaultToolkitLock("AWT") : NativeWindowFactory.createDefaultToolkitLock("X11", "AWT", l);
        X11GraphicsDevice x11GraphicsDevice = new X11GraphicsDevice(l, 0, (ToolkitLock)object, bl);
        X11GraphicsScreen x11GraphicsScreen = new X11GraphicsScreen(x11GraphicsDevice, aWTGraphicsScreen.getIndex());
        if (DEBUG) {
            System.err.println("X11AWTGraphicsConfigurationFactory: made " + x11GraphicsScreen);
        }
        if ((abstractGraphicsConfiguration = (graphicsConfigurationFactory = GraphicsConfigurationFactory.getFactory(x11GraphicsDevice)).chooseGraphicsConfiguration(capabilitiesImmutable, capabilitiesImmutable2, capabilitiesChooser, x11GraphicsScreen)) == null) {
            throw new NativeWindowException("Unable to choose a GraphicsConfiguration (1): " + capabilitiesImmutable + ",\n\t" + capabilitiesChooser + "\n\t" + x11GraphicsScreen);
        }
        if (DEBUG) {
            System.err.println("X11AWTGraphicsConfigurationFactory: chosen config: " + abstractGraphicsConfiguration);
        }
        GraphicsConfiguration[] graphicsConfigurationArray = graphicsDevice.getConfigurations();
        int n = abstractGraphicsConfiguration.getVisualID(VisualIDHolder.VIDType.NATIVE);
        if (0 != n) {
            for (int i = 0; i < graphicsConfigurationArray.length; ++i) {
                GraphicsConfiguration graphicsConfiguration2 = graphicsConfigurationArray[i];
                if (graphicsConfiguration2 == null || X11SunJDKReflection.graphicsConfigurationGetVisualID(graphicsConfiguration2) != n) continue;
                if (DEBUG) {
                    System.err.println("Found matching AWT visual: 0x" + Integer.toHexString(n) + " -> " + abstractGraphicsConfiguration);
                }
                return new AWTGraphicsConfiguration(aWTGraphicsScreen, abstractGraphicsConfiguration.getChosenCapabilities(), abstractGraphicsConfiguration.getRequestedCapabilities(), graphicsConfiguration2, abstractGraphicsConfiguration);
            }
        }
        if ((abstractGraphicsConfiguration = graphicsConfigurationFactory.chooseGraphicsConfiguration(capabilitiesImmutable = AWTGraphicsConfiguration.setupCapabilitiesRGBABits(capabilitiesImmutable, graphicsConfiguration = graphicsDevice.getDefaultConfiguration()), capabilitiesImmutable2, capabilitiesChooser, x11GraphicsScreen)) == null) {
            throw new NativeWindowException("Unable to choose a GraphicsConfiguration (2): " + capabilitiesImmutable + ",\n\t" + capabilitiesChooser + "\n\t" + x11GraphicsScreen);
        }
        n = abstractGraphicsConfiguration.getVisualID(VisualIDHolder.VIDType.NATIVE);
        if (0 != n) {
            for (int i = 0; i < graphicsConfigurationArray.length; ++i) {
                graphicsConfiguration = graphicsConfigurationArray[i];
                if (X11SunJDKReflection.graphicsConfigurationGetVisualID(graphicsConfiguration) != n) continue;
                if (DEBUG) {
                    System.err.println("Found matching default AWT visual: 0x" + Integer.toHexString(n) + " -> " + abstractGraphicsConfiguration);
                }
                return new AWTGraphicsConfiguration(aWTGraphicsScreen, abstractGraphicsConfiguration.getChosenCapabilities(), abstractGraphicsConfiguration.getRequestedCapabilities(), graphicsConfiguration, abstractGraphicsConfiguration);
            }
        }
        if (DEBUG) {
            System.err.println("Using default configuration");
        }
        graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        return new AWTGraphicsConfiguration(aWTGraphicsScreen, abstractGraphicsConfiguration.getChosenCapabilities(), abstractGraphicsConfiguration.getRequestedCapabilities(), graphicsConfiguration, abstractGraphicsConfiguration);
    }
}

